set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9830316';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      3,
      1.490653,
      3,
      3,
      3,
      1.677762,
      3.143493,
      '420',
      '23340244',
      19,
      NULL,
      '4314433',
      2,
      0.672974,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 7- 8-1979',
      NULL,
      NULL,
      NULL,
      0,
      0.806311,
      ' 2- 0-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      2.586897,
      1,
      0,
      1.197370,
      1.015612,
      2.310493,
      0,
      2.404705,
      NULL,
      NULL,
      NULL,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      NULL,
      1,
      2,
      0,
      1.125168,
      0.294251,
      NULL,
      1,
      1.952373,
      0,
      0,
      0.466731,
      NULL,
      NULL,
      3,
      0,
      0,
      1,
      3,
      1,
      1,
      0,
      5,
      1,
      1,
      2,
      2,
      1,
      0,
      1,
      NULL,
      2,
      0,
      1.120253,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.456941,
      1.000988,
      0.429549,
      1.576371,
      2.979138,
      2.460458,
      NULL,
      1,
      0.115442,
      NULL,
      1.950059,
      0,
      2.526709,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      0.455220,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      NULL,
      2,
      4,
      2,
      2,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      1.095249,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      5,
      1.059609,
      1.254459,
      3,
      1.041619,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0.466582,
      NULL,
      1.200164,
      0.740997,
      1.570905,
      NULL,
      0.888149,
      0.395804,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.790828,
      2,
      0,
      0,
      2,
      3,
      3,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      NULL,
      1.541135,
      NULL,
      0,
      0.709838,
      2,
      NULL,
      0,
      0.203711,
      1.307979,
      0.224027,
      0.952007,
      1.235157,
      NULL,
      NULL,
      3.671517,
      1.862543,
      0,
      11.770281,
      1.627936,
      2,
      NULL,
      7.891235,
      0,
      3.476401,
      1.848465,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      NULL,
      NULL,
      NULL,
      '',
      0.539308,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.633865,
      15,
      17,
      11.746179,
      3,
      24.536141,
      NULL,
      5,
      2,
      0,
      0.108495,
      1,
      0,
      NULL,
      NULL,
      3.879488,
      NULL,
      0.287257,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.858046,
      NULL,
      NULL,
      NULL,
      0.444315,
      3,
      0.482055,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.580995,
      0.468432,
      3.456973,
      2,
      3.627980,
      1.832265,
      1,
      NULL,
      NULL,
      7,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.640275,
      3.831302,
      NULL,
      1,
      3.698735,
      0.103854,
      NULL,
      NULL,
      1.852292,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      NULL,
      1.198279,
      2.887979,
      1,
      1,
      0.874120,
      1,
      3,
      NULL,
      0,
      1.249828,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      2.306724,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3.786068,
      0.354429,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.951003,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.853505,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.813879,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      2.295602,
      3.144607,
      3,
      1,
      0.942661,
      6.549194,
      3,
      NULL,
      6,
      NULL,
      3,
      5.825748,
      5,
      0.447333,
      3,
      3,
      0.619533,
      0.142762,
      3,
      2.090792,
      NULL,
      2.458866,
      3.286614,
      0,
      3.598023,
      2.636956,
      2.433883,
      1,
      1,
      1.156056,
      1,
      1.045488,
      0,
      1.706932,
      3.331446,
      2.349598,
      NULL,
      0,
      NULL,
      2.291024,
      7,
      NULL,
      0.132746,
      0,
      0,
      2,
      3,
      1,
      0,
      1,
      0.578263,
      0,
      1.789892,
      NULL,
      NULL,
      0.227987,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.654055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.606261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.201332,
      3,
      NULL,
      1,
      NULL,
      3,
      1.096234,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.917806,
      NULL,
      NULL,
      NULL,
      3.274049,
      NULL,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      1.893365,
      1.673142,
      NULL,
      NULL,
      0.997081,
      0.641850,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0.599925,
      1.017383,
      NULL,
      NULL,
      1.617420,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      0.175260,
      NULL,
      NULL,
      5,
      6.976845,
      NULL,
      NULL,
      0.467221,
      NULL,
      NULL,
      NULL,
      1.659992,
      15,
      1,
      NULL,
      NULL,
      0.148438,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.202974,
      NULL,
      NULL,
      0.959827,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      86,
      0.391773,
      NULL,
      0,
      0.492953,
      0,
      NULL,
      0.676010,
      1,
      1.308310,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      2.090402,
      NULL,
      NULL,
      NULL,
      0.988736,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.598179,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.197455,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.994294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295678,
      0.944141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.564534,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.879079,
      NULL,
      2,
      NULL,
      0.673002,
      NULL,
      NULL,
      NULL,
      0.895003,
      NULL,
      1,
      NULL,
      NULL,
      1.158163,
      1.158111,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      1.886692,
      2,
      3,
      3.164257,
      3.716501,
      NULL,
      0.470541,
      0.008912,
      1.082443,
      0,
      0,
      3.685739,
      0.575704,
      0.405984,
      NULL,
      0.889974,
      1.361838,
      0,
      NULL,
      0,
      1,
      NULL,
      0,
      0.664247,
      0.571085,
      NULL,
      1,
      0.155332,
      NULL,
      0,
      0.756622,
      1,
      NULL,
      0,
      3.470439,
      3,
      0.727875,
      NULL,
      0,
      1,
      0.021364,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.387210,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.080408,
      0,
      1,
      1,
      1.696637,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      49,
      79,
      1,
      4.936517,
      0,
      '34414',
      '',
      '',
      0,
      NULL,
      '',
      NULL,
      1.414327,
      '',
      '',
      '');
commit;
end;
/


