set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2301343',
      0.150171,
      0,
      0,
      3,
      '2441',
      3.384189,
      0.602278,
      NULL,
      NULL,
      '10- 4-1996',
      42.830884,
      NULL,
      3,
      2.072503,
      0.028644,
      ' 1- 5-1985',
      3,
      2.927193,
      170,
      141.712164,
      2,
      ' 9-29-1990',
      ' 9-22-1980',
      NULL,
      NULL,
      0,
      1,
      1.763054,
      1,
      0,
      3,
      NULL,
      0,
      58.027618,
      5,
      3,
      2,
      53.527714,
      NULL,
      0,
      24,
      NULL,
      2,
      0,
      0,
      2,
      1,
      NULL,
      1.184405,
      0.882241,
      0,
      NULL,
      1.051365,
      NULL,
      1,
      1,
      NULL,
      1,
      2,
      5,
      1,
      0,
      1,
      1,
      0,
      5,
      1,
      1,
      1,
      1,
      1,
      0.139288,
      0,
      0,
      2,
      0,
      0.524740,
      NULL,
      NULL,
      1.442125,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.102206,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      NULL,
      5,
      1,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1.289234,
      NULL,
      3,
      1,
      1,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      4,
      1,
      1,
      0,
      3,
      4,
      4,
      3,
      NULL,
      5,
      1,
      0,
      2,
      0.352318,
      ' 6- 9-1980',
      NULL,
      ' 1- 9-1986',
      2.729754,
      0,
      1,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.747348,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1,
      1.124138,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.675919,
      NULL,
      2.223311,
      4.663292,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636918,
      1.858631,
      0.618513,
      1.028218,
      1.759286,
      NULL,
      23,
      NULL,
      0.389665,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0.442904,
      NULL,
      2,
      NULL,
      0,
      3,
      NULL,
      0,
      3,
      3,
      1,
      1,
      3,
      2,
      4,
      1,
      1.656073,
      2,
      2.107803,
      1.739524,
      0.991057,
      1.495743,
      1,
      1.940128,
      1,
      0,
      1,
      3,
      NULL,
      NULL,
      1.035995,
      2,
      1,
      NULL,
      9,
      NULL,
      3.850301,
      NULL,
      4,
      1,
      1,
      1.914766,
      22,
      3,
      2.482572,
      NULL,
      25,
      49,
      6.115434,
      2,
      0,
      1.090566,
      '31312',
      '11031',
      '20441',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      3,
      23.473718,
      16.476963,
      34.908577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.075745,
      1,
      0.235649,
      1,
      NULL,
      NULL,
      NULL,
      0.695791,
      0,
      1.558151,
      NULL,
      NULL,
      1.938457,
      NULL,
      NULL,
      0,
      NULL,
      0.984163,
      2,
      0,
      1,
      1.153864,
      NULL,
      NULL,
      0.380368,
      1,
      0.280221,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.481176,
      4.158936,
      0,
      0.455917,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.678760,
      NULL,
      NULL,
      NULL,
      3,
      0,
      1.897373,
      0,
      NULL,
      0,
      3.245649,
      0.764697,
      1,
      2.835285,
      0,
      0.418122,
      2,
      1,
      1.857986,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.014795,
      NULL,
      NULL,
      2,
      0.141183,
      1.715524,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1.650381,
      NULL,
      NULL,
      NULL,
      1.473090,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.051825,
      0.711553,
      NULL,
      NULL,
      0.126881,
      NULL,
      0.734905,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      1.874495,
      0.396439,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.731548,
      NULL,
      NULL,
      0.112983,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.183466,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.373701,
      1,
      1.782407,
      NULL,
      1,
      0,
      7,
      NULL,
      1,
      1.737809,
      NULL,
      NULL,
      1.793505,
      3,
      0.325091,
      1.931359,
      NULL,
      NULL,
      2,
      1,
      NULL,
      7.985517,
      1.805121,
      NULL,
      1.154035,
      0,
      1.498448,
      2,
      1.443857,
      0,
      0,
      0.709130,
      3,
      3,
      1.159323,
      1,
      7,
      2,
      5,
      0.480844,
      NULL,
      3.125861,
      0,
      1,
      4,
      0,
      1,
      0,
      1,
      0.993165,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.512828,
      NULL,
      NULL,
      2.814755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      2,
      0,
      NULL,
      3,
      5.709994,
      NULL,
      3.663166,
      2,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065776,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.094218,
      0,
      NULL,
      1.884828,
      NULL,
      1,
      NULL,
      0.431060,
      0.285063,
      3,
      NULL,
      0,
      2,
      NULL,
      NULL,
      0,
      1,
      1.917469,
      NULL,
      0.154615,
      1.062972,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      3.516381,
      0,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.848269,
      0.657470,
      NULL,
      0.060861,
      NULL,
      NULL,
      NULL,
      1,
      1.300596,
      NULL,
      NULL,
      0,
      6.114760,
      13,
      NULL,
      0.385240,
      NULL,
      NULL,
      NULL,
      3,
      4,
      NULL,
      2.670054,
      4.301525,
      NULL,
      0,
      NULL,
      NULL,
      1.316590,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.975787,
      4234.185129,
      1016.828730,
      0,
      0.105592,
      0.785175,
      1,
      0,
      0.817634,
      0,
      3,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3.924755,
      0.271077,
      1.863740,
      0,
      1,
      NULL,
      2.530559,
      NULL,
      0,
      NULL,
      3,
      NULL,
      3.361040,
      NULL,
      NULL,
      NULL,
      90.068510,
      NULL,
      1.775663,
      23,
      2.279267,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.788733,
      NULL,
      1.056813,
      NULL,
      0.896693,
      NULL,
      0.983432,
      NULL,
      NULL,
      NULL,
      0.760913,
      NULL,
      1.895144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.944906,
      NULL,
      0.258521,
      NULL,
      1,
      2.630453,
      NULL,
      0.775157,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.414569,
      0.482371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.320118,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.737999,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.858081,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.045543,
      NULL,
      0.976914,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.973608,
      1,
      1,
      32,
      26.074593,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.461782,
      1,
      0.432865,
      1,
      2,
      0.198451,
      NULL,
      0.528437,
      0.745042,
      1,
      1,
      1,
      1,
      NULL,
      0.151922,
      NULL,
      0,
      NULL,
      1.185401,
      1.019905,
      1.071211,
      1.711722,
      1.582126,
      1.903402,
      0,
      0.718266,
      1,
      1.795137,
      0,
      0.956322,
      0,
      0.344105,
      1,
      0.687725,
      0.453175,
      1,
      0,
      0.497015,
      2,
      2,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.308651,
      1.349937,
      1.148125,
      0,
      3.698156,
      1,
      1.937209,
      2.163791,
      1.274444,
      0,
      3.187238,
      1.607735,
      3.928945,
      1.906728,
      0,
      0,
      0,
      1.343882,
      3.979766,
      NULL,
      1,
      2.438872,
      0.143716,
      NULL,
      NULL,
      NULL,
      NULL,
      1834,
      3,
      2,
      0.052165,
      3,
      1.833561,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.747555,
      0,
      NULL,
      0,
      NULL,
      0,
      0.037015,
      1,
      1,
      0.942299,
      1,
      1.019602,
      0.714464,
      NULL,
      2,
      1,
      NULL,
      NULL,
      1.461941,
      1071.589832,
      0.844005,
      1,
      NULL,
      1.332440,
      2.077295,
      0,
      4,
      6,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.277667,
      NULL,
      '24313',
      NULL,
      '12304',
      NULL,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


