set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1987-12-02 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1332220',
      2,
      0.795364,
      6,
      2,
      '2204',
      3.856857,
      0,
      NULL,
      NULL,
      ' 9-24-1989',
      47,
      NULL,
      5,
      NULL,
      3.040886,
      NULL,
      47,
      3.606628,
      351,
      10,
      1,
      ' 4-17-1991',
      ' 4-12-2000',
      ' 2- 7-1975',
      NULL,
      0,
      2.464376,
      0,
      0.199166,
      1,
      3,
      0,
      NULL,
      12.545005,
      4,
      13.102714,
      1,
      11,
      NULL,
      0,
      18.804546,
      2,
      3,
      3.983129,
      NULL,
      0,
      1,
      0,
      0,
      0.316275,
      0,
      NULL,
      0.859919,
      0,
      NULL,
      NULL,
      5,
      5,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      3,
      NULL,
      0,
      0,
      1,
      3,
      1,
      2,
      2,
      NULL,
      1.355225,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      0.382439,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      4,
      NULL,
      5,
      4,
      2,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      2,
      NULL,
      1,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      3,
      1,
      2,
      3,
      2,
      3,
      2,
      0,
      2,
      0,
      5,
      3,
      0,
      2.120357,
      0,
      NULL,
      208.822483,
      ' 4-28-1989',
      55.938260,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.257526,
      1.915722,
      1,
      0.865423,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.809612,
      NULL,
      4,
      3.774613,
      1.345270,
      4,
      1,
      NULL,
      NULL,
      NULL,
      0.671735,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.103585,
      0,
      0.415022,
      NULL,
      NULL,
      1,
      3.049834,
      17.653428,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      3,
      0,
      1,
      3,
      0,
      NULL,
      2,
      2,
      2,
      3.322744,
      3,
      NULL,
      3.868141,
      0.289304,
      1,
      NULL,
      2.061744,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.642336,
      1,
      2.484029,
      5,
      1.378835,
      2.275386,
      3.280984,
      5,
      0.822464,
      5,
      2.143801,
      1.797279,
      2.768348,
      0,
      2.557137,
      1,
      3,
      63,
      3,
      3,
      NULL,
      10,
      8,
      NULL,
      1,
      NULL,
      3,
      '12442',
      '21310',
      '20124',
      0.140392,
      '',
      '',
      NULL,
      0,
      '',
      NULL,
      NULL,
      NULL,
      44.523710,
      71.290927,
      37.656795,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      3,
      0.773090,
      NULL,
      NULL,
      3.456002,
      0.640258,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.630064,
      0,
      0,
      2.796846,
      3,
      NULL,
      NULL,
      3.537075,
      0.978119,
      0,
      0.160177,
      1,
      2,
      0.745818,
      0.747728,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.093743,
      3.431180,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1.768229,
      1,
      3.243955,
      2,
      1.301174,
      NULL,
      NULL,
      NULL,
      NULL,
      2.981466,
      1,
      1,
      3,
      NULL,
      1.968128,
      1.177076,
      NULL,
      1,
      0,
      0.154298,
      1.336051,
      NULL,
      0,
      1.878411,
      1,
      0.449927,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.385844,
      NULL,
      NULL,
      1.634921,
      NULL,
      NULL,
      NULL,
      0.912656,
      0.803349,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.514379,
      NULL,
      NULL,
      3.458466,
      2.161946,
      0,
      1,
      NULL,
      2,
      1.781271,
      NULL,
      NULL,
      9,
      7.399997,
      3,
      1,
      NULL,
      NULL,
      0,
      1.282672,
      1,
      5.053469,
      NULL,
      NULL,
      0.045602,
      NULL,
      NULL,
      1.318732,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.502109,
      NULL,
      NULL,
      1.827665,
      NULL,
      NULL,
      0.822090,
      NULL,
      NULL,
      1.608605,
      NULL,
      NULL,
      3,
      0.907793,
      0,
      2,
      NULL,
      1.578579,
      6.700928,
      7,
      3,
      3.680068,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.328201,
      3,
      0,
      0,
      1.667343,
      0,
      NULL,
      5,
      NULL,
      NULL,
      0.863741,
      0.683056,
      1.548865,
      1,
      1,
      1.789310,
      1.173661,
      0,
      0,
      3,
      1.069584,
      NULL,
      NULL,
      NULL,
      1,
      4.538759,
      3,
      3.072823,
      2,
      NULL,
      0.925881,
      0.705009,
      1.510291,
      1,
      1,
      0.780569,
      NULL,
      NULL,
      0.526284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      3,
      0.230417,
      0.553141,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.673400,
      2.121659,
      2,
      NULL,
      NULL,
      NULL,
      2.587793,
      NULL,
      NULL,
      NULL,
      1.827940,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.632483,
      0.392295,
      NULL,
      NULL,
      3,
      3,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      0.487897,
      0.490696,
      NULL,
      0,
      0.482756,
      0,
      NULL,
      0.360421,
      1,
      1.548683,
      NULL,
      3.520013,
      0.689055,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      3,
      3.947327,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1.856947,
      0,
      NULL,
      NULL,
      1.175786,
      0.825743,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0.563474,
      1.883946,
      9.777867,
      NULL,
      6.761174,
      8.125500,
      2,
      NULL,
      1.450138,
      NULL,
      NULL,
      NULL,
      NULL,
      4.369841,
      1.388538,
      3,
      12.817494,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.225191,
      NULL,
      NULL,
      0.670830,
      NULL,
      NULL,
      0.714088,
      NULL,
      1,
      1804.434920,
      325.836595,
      0.790143,
      3.555529,
      1,
      2,
      NULL,
      2.746267,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      0.661081,
      NULL,
      3,
      NULL,
      3.313275,
      NULL,
      1.323643,
      NULL,
      NULL,
      NULL,
      2.567486,
      NULL,
      2.810027,
      NULL,
      18.351766,
      NULL,
      1.240983,
      12.841043,
      26,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.386979,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.448834,
      NULL,
      0.780512,
      NULL,
      0.777318,
      NULL,
      1,
      NULL,
      1.652113,
      0,
      1,
      0.875603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.231258,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.122508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.749566,
      2.124518,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      40,
      NULL,
      3,
      NULL,
      1.873630,
      NULL,
      1.243680,
      NULL,
      2.622609,
      12.740503,
      32.359044,
      1.343074,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.221325,
      1,
      1.831543,
      1.363613,
      1,
      3.531274,
      1.846363,
      NULL,
      3.684051,
      1.134523,
      0,
      0.697870,
      0,
      1,
      2.523565,
      0,
      2.085226,
      2,
      0,
      NULL,
      1,
      NULL,
      1.209370,
      1.093946,
      0.092551,
      1,
      NULL,
      0.734200,
      0.464186,
      0.024912,
      0,
      0.147590,
      1,
      1,
      1.428613,
      1,
      NULL,
      2.971755,
      NULL,
      0.254416,
      3,
      0.279148,
      NULL,
      1.602020,
      2.942468,
      3,
      2.302146,
      3,
      2.061016,
      2.023892,
      1.252173,
      1.013035,
      1.805164,
      3.752438,
      1.716566,
      NULL,
      3.776073,
      2,
      2,
      0.485154,
      NULL,
      0,
      1,
      2.155920,
      3.824101,
      NULL,
      1.214990,
      2.578185,
      0,
      NULL,
      1.621382,
      109,
      0.097617,
      NULL,
      2.110713,
      2,
      2.751067,
      0.307308,
      2,
      2.643523,
      3.052748,
      1,
      2,
      0.711174,
      0.881502,
      0.393525,
      1,
      NULL,
      NULL,
      2,
      NULL,
      0,
      3,
      3,
      1.554999,
      0.873100,
      NULL,
      0,
      3.668010,
      2,
      NULL,
      156.813596,
      NULL,
      856.096748,
      0,
      0,
      1,
      1.622346,
      3,
      3.218386,
      NULL,
      4,
      NULL,
      1.021522,
      NULL,
      NULL,
      99.227202,
      27.055207,
      0,
      0.752555,
      6.702299,
      '41400',
      '32034',
      '43014',
      1.358985,
      NULL,
      '',
      '',
      0.570141,
      NULL,
      NULL,
      '');
commit;
end;
/


