set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8734742';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-2-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      38,
      NULL,
      NULL,
      0.519906,
      NULL,
      '10-18-1979',
      9,
      0,
      32.601592,
      81,
      3,
      ' 5-12-1982',
      ' 1- 6-1978',
      NULL,
      1.455084,
      0.456823,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      1.251693,
      15,
      6,
      2,
      2,
      14.348267,
      20,
      1,
      0,
      1,
      3,
      1.739415,
      0.660682,
      0,
      NULL,
      1.625245,
      1.889159,
      1.922148,
      NULL,
      0,
      0,
      1.572999,
      1.408570,
      0,
      3,
      3,
      NULL,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      0,
      2,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      5,
      0,
      1,
      NULL,
      NULL,
      1,
      4,
      1,
      1,
      NULL,
      2,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      3,
      0.475949,
      0.007383,
      NULL,
      NULL,
      ' 1- 7-2002',
      11.225100,
      0.283850,
      0,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1.589129,
      1.738123,
      2.469303,
      1.108949,
      NULL,
      NULL,
      NULL,
      1.541681,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.470326,
      1.644698,
      0.135138,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0.306663,
      NULL,
      NULL,
      NULL,
      3,
      1.760166,
      1,
      2,
      NULL,
      3,
      2,
      1,
      1,
      2,
      0,
      2,
      1,
      1,
      0.303336,
      3,
      3,
      0.847254,
      1,
      1.014458,
      NULL,
      1,
      1,
      1.016943,
      0,
      1.631807,
      0,
      0.570170,
      0,
      1.960172,
      4,
      1.290262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.969760,
      NULL,
      43,
      40,
      39.204972,
      4,
      1.721793,
      NULL,
      NULL,
      '',
      '',
      1.948757,
      '',
      '',
      NULL,
      1.597478,
      NULL,
      '',
      '',
      2.661877,
      19.753283,
      42,
      9,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.300731,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.119369,
      NULL,
      NULL,
      0.569306,
      NULL,
      NULL,
      1.366036,
      NULL,
      NULL,
      NULL,
      2.798275,
      NULL,
      0.769670,
      2.601096,
      0.844438,
      0.067972,
      NULL,
      NULL,
      1.566505,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      9,
      3,
      NULL,
      0,
      0.453770,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      1,
      0.324948,
      NULL,
      NULL,
      0.813149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.023240,
      NULL,
      NULL,
      1.823093,
      NULL,
      NULL,
      0.194046,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.227619,
      0.423467,
      NULL,
      3.521246,
      0.083334,
      2,
      0,
      1.796178,
      1.211573,
      3.319640,
      0.102080,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.768005,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.726331,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.601496,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      2.398192,
      NULL,
      1,
      3,
      NULL,
      2.196380,
      0.002107,
      1,
      1.778020,
      2.950852,
      2.010791,
      NULL,
      0,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      2.290255,
      3,
      0.108953,
      3.475305,
      NULL,
      3,
      1.707681,
      2,
      0,
      0.154937,
      NULL,
      NULL,
      0,
      0,
      3,
      1.101343,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.879055,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.906420,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.986188,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.123310,
      NULL,
      NULL,
      1.264678,
      NULL,
      NULL,
      0,
      1,
      0,
      1.038627,
      NULL,
      2.543024,
      2,
      NULL,
      4.512676,
      3,
      0.871975,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.851122,
      NULL,
      NULL,
      NULL,
      0,
      4.773680,
      0.982145,
      NULL,
      1.293463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      17,
      0,
      NULL,
      2.876532,
      NULL,
      NULL,
      NULL,
      0.514272,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.016101,
      14,
      1,
      NULL,
      1.057501,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2,
      NULL,
      1.691374,
      3,
      0,
      NULL,
      1,
      7.055543,
      1,
      NULL,
      NULL,
      13.027912,
      0.030754,
      NULL,
      1,
      12,
      1.702526,
      NULL,
      1,
      2,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2.296489,
      8,
      NULL,
      1.727141,
      10.033402,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.368957,
      NULL,
      0,
      NULL,
      582,
      NULL,
      1.661898,
      0.481909,
      1,
      1,
      1.024596,
      0,
      1.902978,
      0.661164,
      1,
      0,
      1,
      NULL,
      NULL,
      1.635970,
      0.663903,
      0,
      1.139359,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.585974,
      NULL,
      0.851687,
      NULL,
      1.158087,
      NULL,
      2.561778,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.617963,
      NULL,
      0,
      NULL,
      1.457732,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.314427,
      NULL,
      0,
      NULL,
      0.656789,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.059463,
      NULL,
      0.546129,
      NULL,
      1.792692,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      1,
      2,
      3.137960,
      1.075053,
      2,
      0.791950,
      0.786740,
      0,
      2,
      1,
      0.288267,
      0.810817,
      NULL,
      1,
      2.978753,
      1.985130,
      1.659804,
      0,
      0.361825,
      0.272913,
      0,
      1.751231,
      1.012560,
      1.958636,
      0.532102,
      0.049379,
      0,
      1.847499,
      0,
      1,
      0,
      1.329863,
      1.693742,
      NULL,
      1,
      1.716557,
      NULL,
      NULL,
      1,
      1.710663,
      2,
      1,
      1,
      3.763191,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.036332,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.492595,
      0,
      1.502302,
      1,
      0,
      1.428557,
      NULL,
      4,
      NULL,
      1.942137,
      NULL,
      NULL,
      7.529973,
      97.817284,
      NULL,
      NULL,
      0.129136,
      '00434',
      NULL,
      NULL,
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '');
commit;
end;
/


