set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9839660';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-7-24 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2.649716,
      1.862644,
      0.382047,
      1.329296,
      0,
      0,
      0.209907,
      '012',
      NULL,
      41.024421,
      42,
      '2210220',
      2,
      0,
      4,
      0,
      '0211',
      3,
      0.617603,
      NULL,
      NULL,
      ' 6- 3-1993',
      30.200493,
      31.166917,
      NULL,
      0.071753,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '11-26-1981',
      ' 8-23-1975',
      NULL,
      3,
      2.879305,
      2.360527,
      3.740788,
      1.361077,
      3.115245,
      2,
      0,
      NULL,
      NULL,
      NULL,
      6,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1.404722,
      1,
      0,
      1,
      1,
      1.017155,
      1.141017,
      1.531371,
      1,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      5,
      NULL,
      5,
      0,
      0,
      2,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      5,
      9.309492,
      0.332846,
      NULL,
      NULL,
      NULL,
      0.589611,
      1,
      0,
      3,
      1,
      2.849748,
      0,
      0.136967,
      0.768390,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      5,
      0,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      0,
      NULL,
      1.396166,
      0,
      1,
      3,
      1,
      0,
      3,
      4,
      NULL,
      NULL,
      5,
      5,
      2,
      2,
      1,
      1,
      NULL,
      1,
      0,
      0,
      3,
      2,
      1,
      2,
      NULL,
      NULL,
      0.875926,
      1.644103,
      '10- 0-1992',
      NULL,
      '11- 4-1982',
      NULL,
      3,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1.712958,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      3,
      0.354097,
      0.083985,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.773516,
      0.712286,
      6.459718,
      1,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      0.360894,
      5.775670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.351628,
      1.237066,
      0.658181,
      1,
      0.309118,
      0,
      NULL,
      9.131636,
      3,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.745219,
      0.096589,
      2,
      NULL,
      2,
      NULL,
      3,
      0,
      2,
      1,
      3,
      2,
      NULL,
      2.960619,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.792860,
      1.201730,
      1,
      1,
      1.228074,
      0,
      0,
      0,
      NULL,
      0.260095,
      1.307950,
      9.877948,
      7,
      6.873099,
      0.724463,
      7.519477,
      4.114972,
      0.580477,
      1,
      1,
      0,
      3.270498,
      NULL,
      38,
      NULL,
      2,
      26,
      NULL,
      53,
      NULL,
      1,
      0,
      2.411017,
      '32311',
      NULL,
      NULL,
      0.379351,
      '',
      NULL,
      '',
      NULL,
      '',
      NULL,
      '',
      1.455048,
      NULL,
      25.870201,
      NULL,
      NULL,
      4.678299,
      1,
      0.442346,
      5,
      1.533765,
      1.536194,
      NULL,
      1.992626,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.883087,
      NULL,
      NULL,
      1,
      3.544987,
      1,
      1.059979,
      NULL,
      NULL,
      NULL,
      2,
      0.303711,
      3.304266,
      NULL,
      0,
      1.109814,
      NULL,
      NULL,
      1.911830,
      NULL,
      NULL,
      11,
      5.383463,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.423370,
      NULL,
      1,
      0.258059,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      2,
      NULL,
      0,
      3.079287,
      3.504327,
      2.787558,
      2.644526,
      1.548980,
      0.513386,
      0.935340,
      2,
      0,
      NULL,
      NULL,
      NULL,
      1.276528,
      NULL,
      NULL,
      1.779867,
      NULL,
      NULL,
      9.791696,
      0.268289,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.226018,
      NULL,
      NULL,
      NULL,
      0,
      0.625217,
      0.994865,
      NULL,
      0,
      0,
      0.501813,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      1.573818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.047020,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671085,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.867727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.289548,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.698703,
      0,
      NULL,
      2.584536,
      NULL,
      NULL,
      NULL,
      0.548078,
      2,
      1,
      3.188248,
      0.519059,
      NULL,
      0.147475,
      3,
      NULL,
      3.711211,
      NULL,
      1,
      2.665061,
      NULL,
      3,
      1.793516,
      0,
      0,
      3.836993,
      NULL,
      2.809297,
      1.078630,
      3,
      NULL,
      9,
      6.713840,
      2.862358,
      3.399449,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      1.177687,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.816140,
      NULL,
      NULL,
      1.289645,
      NULL,
      NULL,
      0.343131,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.530686,
      NULL,
      NULL,
      NULL,
      NULL,
      1.183875,
      NULL,
      NULL,
      3.852278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      18,
      5,
      0.929288,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.884087,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.357636,
      1.384142,
      1.399122,
      0,
      1.185130,
      NULL,
      1,
      0.389139,
      1,
      1.949911,
      1,
      1,
      NULL,
      1.283221,
      NULL,
      NULL,
      1,
      1,
      1.976342,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.610457,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.849954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.630423,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.753923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.873709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.925223,
      3.332564,
      NULL,
      NULL,
      NULL,
      1.297032,
      NULL,
      NULL,
      NULL,
      0.339666,
      NULL,
      NULL,
      NULL,
      1.906401,
      0.198856,
      0.571129,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.108432,
      NULL,
      3.676085,
      NULL,
      1,
      7,
      0,
      0,
      1,
      0.881039,
      1.844785,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      NULL,
      0.792404,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      NULL,
      3.813118,
      2.545067,
      NULL,
      1.473618,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.980314,
      NULL,
      1.782486,
      NULL,
      2,
      3,
      1,
      1,
      NULL,
      NULL,
      30,
      102,
      2,
      NULL,
      3.609853,
      '21244',
      NULL,
      '',
      0,
      '',
      '',
      '',
      1.620521,
      '',
      '',
      '');
commit;
end;
/


