set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9730051';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      1,
      0.195544,
      0,
      NULL,
      2.581098,
      1.019867,
      NULL,
      '01',
      NULL,
      9,
      '2310021',
      3.896516,
      1.052782,
      0,
      NULL,
      '3143',
      NULL,
      0,
      NULL,
      NULL,
      '11-21-1990',
      36.794603,
      56,
      NULL,
      2,
      NULL,
      ' 2-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 8-10-1998',
      NULL,
      ' 9-25-1993',
      0,
      2.453613,
      3,
      0.583714,
      0.281449,
      0.215138,
      2,
      NULL,
      0,
      NULL,
      6,
      6,
      7.293289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.798160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      3,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      4,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      5,
      1,
      0,
      2,
      0,
      0,
      0,
      0,
      0,
      5,
      0,
      5,
      1,
      0,
      1,
      0,
      1,
      NULL,
      1,
      4,
      5,
      4,
      0,
      5,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      4,
      NULL,
      3,
      4,
      2,
      2,
      NULL,
      1,
      5,
      5,
      NULL,
      2,
      1,
      ' 5-11-1979',
      NULL,
      ' 3-24-1978',
      NULL,
      3,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.130077,
      NULL,
      1.143291,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      3.285093,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0.616851,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      1,
      NULL,
      2,
      NULL,
      '10-13-2003',
      320,
      ' 7-13-1993',
      11.783391,
      2.687146,
      0,
      NULL,
      0.379411,
      0.077743,
      1.614175,
      1,
      0.493551,
      NULL,
      NULL,
      0.115692,
      NULL,
      0.006479,
      0.798239,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.312542,
      3,
      0,
      0,
      0,
      1,
      2,
      2,
      1,
      NULL,
      1,
      7,
      2.155362,
      2.155391,
      12,
      1.869229,
      1,
      9.170066,
      1,
      0,
      1,
      NULL,
      NULL,
      0.121916,
      1,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      8,
      NULL,
      3,
      NULL,
      7,
      5,
      0,
      4,
      2.520598,
      NULL,
      1.428670,
      NULL,
      2,
      3.128608,
      45,
      NULL,
      27,
      14.581695,
      5,
      1.350315,
      2,
      NULL,
      NULL,
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      3.503956,
      42.700285,
      21,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.141095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.616076,
      NULL,
      NULL,
      2,
      3,
      0.978605,
      1.139978,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.737270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763462,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.582597,
      NULL,
      NULL,
      0.571878,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919732,
      NULL,
      NULL,
      0.765858,
      NULL,
      NULL,
      0.153830,
      NULL,
      NULL,
      0.857949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.780854,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.924711,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.552651,
      NULL,
      NULL,
      1.917390,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.828995,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.774580,
      0.854492,
      0.122748,
      3,
      4.896795,
      2,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      2,
      1,
      1.437222,
      0.540630,
      NULL,
      4.076707,
      NULL,
      1.656521,
      NULL,
      3,
      1,
      3.659049,
      2.086599,
      0.487379,
      0.724412,
      3,
      2.971675,
      2.068158,
      3,
      0,
      3.367363,
      5.539882,
      1,
      1,
      NULL,
      NULL,
      0.227070,
      NULL,
      NULL,
      0,
      NULL,
      1.105051,
      0.883216,
      0,
      1.185097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.944605,
      0,
      0,
      NULL,
      0.097935,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3.338521,
      NULL,
      NULL,
      NULL,
      3.203002,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890430,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.586652,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.444987,
      NULL,
      NULL,
      NULL,
      1.651981,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      3.278484,
      NULL,
      NULL,
      NULL,
      0.308376,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.425552,
      NULL,
      NULL,
      NULL,
      2.855086,
      NULL,
      0.490933,
      1,
      4.422200,
      NULL,
      0.001287,
      NULL,
      NULL,
      1.417132,
      NULL,
      NULL,
      1.738331,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0.164697,
      1.164079,
      0,
      1.265421,
      0,
      1.698094,
      1,
      NULL,
      1.981281,
      NULL,
      0.742113,
      0.980015,
      NULL,
      1.391111,
      1.014478,
      1,
      NULL,
      1.076841,
      NULL,
      0.294798,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      6,
      2,
      5,
      3,
      3,
      15.271872,
      NULL,
      2,
      3,
      1,
      NULL,
      1,
      0,
      1.534785,
      NULL,
      2.149559,
      0,
      0,
      1,
      1.984882,
      0.843714,
      0.115752,
      1,
      3,
      1,
      NULL,
      2,
      NULL,
      2.085256,
      2,
      NULL,
      0,
      1.373011,
      1,
      3.167308,
      1,
      NULL,
      0,
      1.133586,
      1,
      0.095309,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.330254,
      0.517826,
      1.685177,
      0.626793,
      1,
      1,
      2,
      0,
      0,
      2,
      1.508896,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.976615,
      '34424',
      NULL,
      NULL,
      0,
      '',
      '',
      '',
      1.225071,
      '',
      '',
      '');
commit;
end;
/


