set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9228941';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1992-10-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '3212144',
      NULL,
      0.444758,
      0,
      NULL,
      '2213',
      1.034484,
      1.612096,
      NULL,
      NULL,
      ' 6-16-1994',
      31,
      NULL,
      3,
      1,
      1.604941,
      ' 5- 6-1982',
      28.903232,
      1.628960,
      253.607202,
      NULL,
      2,
      ' 7-18-1977',
      '10- 0-1984',
      ' 9-24-1994',
      2.429784,
      1.863493,
      NULL,
      2.130435,
      0.344553,
      1,
      NULL,
      3.803703,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      18,
      3,
      5,
      NULL,
      1,
      0,
      5,
      NULL,
      2,
      NULL,
      0,
      1.897095,
      0,
      1.129436,
      3.179588,
      NULL,
      0.733516,
      1.975437,
      3,
      1,
      NULL,
      1,
      2,
      1,
      1,
      1,
      1,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.387076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0.232181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      3,
      1,
      0,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      0,
      0,
      1,
      1.856977,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      2,
      4,
      3,
      4,
      1,
      1,
      4,
      NULL,
      0,
      3,
      0,
      1,
      5,
      3,
      5,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.741925,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.141095,
      3,
      0.974850,
      0,
      1,
      NULL,
      3.504951,
      0,
      0,
      4,
      0,
      0.664226,
      NULL,
      2,
      NULL,
      0,
      1.883543,
      2.318479,
      0.535301,
      0,
      4.135482,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.399497,
      1.055333,
      1.156345,
      1,
      0,
      NULL,
      1.884113,
      NULL,
      2.953515,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0.112005,
      3,
      2,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      2.298669,
      13,
      12.867181,
      155,
      NULL,
      73.238727,
      187.840547,
      106.048342,
      46.007447,
      0,
      0.673974,
      NULL,
      1,
      0.561883,
      0,
      NULL,
      18,
      5,
      1,
      5.320099,
      1,
      NULL,
      0,
      8.084342,
      3.008694,
      0.057980,
      NULL,
      2.613681,
      3.565280,
      1.755019,
      NULL,
      69,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      69,
      2,
      NULL,
      0,
      '12444',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      1,
      32.716555,
      20,
      NULL,
      3,
      5.560632,
      3,
      3.169940,
      4,
      3.840193,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.023254,
      NULL,
      NULL,
      1.066264,
      NULL,
      NULL,
      1.921394,
      NULL,
      NULL,
      NULL,
      2.227163,
      1.701331,
      0.410848,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.982065,
      NULL,
      NULL,
      1.158979,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.680962,
      1.847473,
      1.563347,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.107853,
      NULL,
      NULL,
      NULL,
      0,
      2.970071,
      0.039057,
      1.848990,
      NULL,
      NULL,
      0.636066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      3,
      0,
      1,
      1,
      0,
      3,
      1,
      NULL,
      2,
      3,
      1.829734,
      NULL,
      NULL,
      1.086881,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.521764,
      NULL,
      1,
      0,
      0.469759,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.740755,
      3.386877,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.018401,
      NULL,
      1.327537,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.100746,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.822921,
      NULL,
      NULL,
      10,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.447791,
      NULL,
      NULL,
      1.167448,
      NULL,
      NULL,
      3.420689,
      5.090532,
      0.748616,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.857861,
      NULL,
      NULL,
      3.121858,
      3.148965,
      1.841377,
      2,
      1.059819,
      1,
      0,
      NULL,
      1.145895,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.445817,
      3.801648,
      0,
      2.815096,
      0,
      1.857934,
      1.191140,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.277798,
      0.580368,
      1.382774,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.499093,
      NULL,
      1,
      NULL,
      0.584258,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      6,
      1,
      NULL,
      NULL,
      0.669089,
      1,
      1,
      1,
      NULL,
      NULL,
      1.783868,
      NULL,
      NULL,
      1,
      NULL,
      1.706493,
      68.885890,
      0,
      1.357270,
      1.390163,
      0.932966,
      1,
      NULL,
      0.036572,
      1.753232,
      0.724410,
      1,
      1.916827,
      0.401265,
      NULL,
      0,
      1,
      1,
      NULL,
      0.173898,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      6.644659,
      NULL,
      3,
      0.249787,
      0,
      1.797680,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      1.047222,
      1.464905,
      NULL,
      1,
      1.667621,
      NULL,
      0,
      1.472638,
      NULL,
      1.560000,
      0.977535,
      NULL,
      0,
      0.306982,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.773056,
      0,
      NULL,
      0.300408,
      0.683227,
      0.634054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.378990,
      NULL,
      0,
      NULL,
      0.562742,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      149.648351,
      2,
      1,
      0.364491,
      '21110',
      '',
      '',
      NULL,
      '',
      '',
      '',
      0.545606,
      '',
      NULL,
      '');
commit;
end;
/


