set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9753771';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-4-20 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      3,
      0.007699,
      3,
      4.468849,
      2.830241,
      2.477507,
      1.445588,
      '130',
      NULL,
      43.132121,
      28,
      '0430240',
      1.229187,
      0.124220,
      3,
      NULL,
      '3131',
      1.902107,
      1,
      NULL,
      NULL,
      ' 6-16-1991',
      64,
      NULL,
      NULL,
      3,
      5.425102,
      ' 5- 0-1983',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      ' 1-21-1995',
      ' 2- 6-2001',
      ' 0-27-1983',
      NULL,
      2,
      0,
      2.247466,
      1,
      3.761224,
      NULL,
      0.084995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      1.167341,
      1,
      2,
      2.590245,
      NULL,
      1.553673,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2,
      NULL,
      1,
      0.863300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      1,
      0,
      1,
      3,
      2,
      0.347600,
      NULL,
      0,
      2,
      NULL,
      1,
      0,
      NULL,
      0,
      0.358120,
      0,
      3.153984,
      5,
      1,
      3,
      4.568188,
      1,
      0,
      3.730694,
      1.321328,
      NULL,
      NULL,
      1.287994,
      NULL,
      NULL,
      NULL,
      1,
      3,
      5,
      NULL,
      0,
      3,
      1,
      NULL,
      5,
      1,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      1,
      2,
      1,
      2,
      3,
      0,
      0,
      0,
      3,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      5,
      3,
      1,
      3,
      NULL,
      2,
      0,
      0,
      0,
      2,
      ' 3-21-1996',
      123,
      NULL,
      77,
      2.690426,
      2,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.270128,
      NULL,
      2,
      NULL,
      1,
      1.475463,
      1,
      2.122727,
      2,
      4,
      1.276492,
      1.159306,
      3,
      2,
      2,
      0.440638,
      1.739129,
      4,
      1,
      NULL,
      2,
      3,
      2.102865,
      1.746049,
      0,
      0.699260,
      NULL,
      1.284610,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0,
      2.612166,
      0.674460,
      1,
      0,
      1.431012,
      NULL,
      2.183785,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0.031701,
      NULL,
      2,
      3,
      3,
      NULL,
      3,
      0,
      3,
      3,
      2,
      3.097416,
      0,
      NULL,
      2,
      1,
      1,
      NULL,
      0,
      0,
      2.481078,
      1.117388,
      NULL,
      1.459601,
      1.797284,
      0,
      NULL,
      NULL,
      NULL,
      0.918550,
      NULL,
      5.901062,
      1.819376,
      9.256398,
      4,
      3.631931,
      3,
      NULL,
      NULL,
      1.125357,
      NULL,
      NULL,
      NULL,
      1,
      1,
      58,
      NULL,
      28,
      61,
      NULL,
      1.581760,
      3,
      NULL,
      NULL,
      '',
      1.337319,
      NULL,
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      0,
      49,
      NULL,
      9,
      NULL,
      39,
      1.884731,
      0,
      3,
      1.422846,
      0.352356,
      1,
      0.521908,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0.310598,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3.206584,
      0.961359,
      NULL,
      0.070219,
      NULL,
      NULL,
      1.446260,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.183056,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.185619,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.080848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.797599,
      0,
      0.446965,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.831416,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.945175,
      NULL,
      NULL,
      0.102097,
      NULL,
      NULL,
      1.073666,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.732889,
      NULL,
      NULL,
      0,
      3.232652,
      NULL,
      1.648794,
      NULL,
      3,
      2.492330,
      7.111431,
      0.589578,
      4.081816,
      2,
      1.382802,
      1,
      NULL,
      NULL,
      NULL,
      1,
      2.891211,
      1,
      2.624648,
      0,
      1,
      2,
      0,
      6,
      4,
      5,
      2.848438,
      3.443123,
      1.919566,
      NULL,
      3.480200,
      1,
      3.150596,
      3,
      1.448639,
      NULL,
      2,
      3,
      9.584293,
      0,
      2.287559,
      7,
      1.408971,
      1.738137,
      3.709185,
      3,
      1,
      0,
      NULL,
      0,
      0,
      0.629526,
      0.910599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635665,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.766666,
      NULL,
      NULL,
      0.344749,
      NULL,
      NULL,
      0.161164,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      4.640311,
      NULL,
      NULL,
      1,
      2.454313,
      2,
      0.068927,
      0.198947,
      NULL,
      NULL,
      NULL,
      NULL,
      3.726084,
      NULL,
      NULL,
      NULL,
      481.935589,
      NULL,
      NULL,
      NULL,
      0.487145,
      NULL,
      NULL,
      NULL,
      0.093096,
      NULL,
      NULL,
      NULL,
      2.815554,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.091557,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.019772,
      NULL,
      NULL,
      NULL,
      1.427607,
      NULL,
      NULL,
      NULL,
      0.748676,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.207759,
      NULL,
      NULL,
      NULL,
      0.604874,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415490,
      NULL,
      NULL,
      NULL,
      NULL,
      0.671422,
      1.372000,
      2,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.647462,
      25,
      16,
      0.077617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.741916,
      NULL,
      NULL,
      230.034086,
      8.851137,
      0.776933,
      1,
      1.610407,
      0.868890,
      NULL,
      1.342739,
      1.566522,
      NULL,
      1,
      NULL,
      0.598827,
      0.503863,
      0,
      1,
      0,
      0,
      0,
      0.340560,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.097506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3.354461,
      1,
      0,
      NULL,
      2,
      3,
      NULL,
      3.936219,
      0.396739,
      1.297732,
      NULL,
      NULL,
      0.345296,
      0,
      NULL,
      0.017863,
      1,
      NULL,
      1.719949,
      1.191655,
      NULL,
      0,
      1.162386,
      NULL,
      0,
      1,
      NULL,
      1.652216,
      1.315708,
      NULL,
      1.107599,
      1.867220,
      NULL,
      0,
      0.285930,
      NULL,
      0,
      1,
      NULL,
      1.220223,
      0,
      NULL,
      3,
      0.200807,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.650223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      41,
      39,
      5,
      NULL,
      2,
      '11010',
      '',
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


