set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7901496';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-6-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      '4301021',
      1.720134,
      0,
      NULL,
      1,
      NULL,
      3,
      1,
      NULL,
      NULL,
      ' 6- 5-1986',
      44,
      NULL,
      2,
      NULL,
      NULL,
      ' 2-22-1984',
      NULL,
      2.149886,
      296,
      22.321109,
      0,
      ' 7- 1-1985',
      ' 2-13-2000',
      NULL,
      3.395662,
      1.764545,
      2,
      1.215305,
      0,
      0.773158,
      1,
      NULL,
      NULL,
      18.940580,
      1,
      0.763364,
      2.524188,
      4,
      101.719299,
      1,
      16.936633,
      5,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.491139,
      1,
      NULL,
      0,
      0,
      1.965449,
      1.251306,
      39.982120,
      NULL,
      2,
      4,
      NULL,
      2,
      1,
      1,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      0,
      0,
      NULL,
      6.633484,
      1,
      1,
      1,
      0,
      1.088935,
      NULL,
      NULL,
      0.862439,
      NULL,
      NULL,
      0,
      1,
      1.988344,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      5,
      5,
      1,
      1,
      5,
      0,
      1,
      0,
      5,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      3,
      NULL,
      1,
      4,
      4,
      0,
      NULL,
      1,
      5,
      1,
      2,
      1,
      1,
      3,
      NULL,
      3,
      1,
      NULL,
      4,
      1,
      1.528094,
      0,
      ' 4-21-1978',
      675,
      ' 9-16-2001',
      772,
      NULL,
      1,
      0,
      4,
      NULL,
      3,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1,
      1,
      0,
      0,
      0.058796,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.564479,
      0.947485,
      0,
      0.252483,
      NULL,
      3.874852,
      1.848689,
      NULL,
      NULL,
      NULL,
      0.602440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946151,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.000648,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0.732231,
      1,
      2,
      0,
      0,
      2,
      0,
      1,
      2,
      NULL,
      0,
      NULL,
      3,
      11,
      9.537148,
      NULL,
      84,
      NULL,
      6,
      NULL,
      NULL,
      0.149493,
      1.924189,
      0,
      1.000698,
      1.725449,
      0,
      0,
      1.921455,
      7.227114,
      0.766692,
      6,
      NULL,
      3.891707,
      6.331533,
      NULL,
      4,
      3,
      3.715158,
      4,
      0,
      NULL,
      NULL,
      21,
      NULL,
      2.600932,
      NULL,
      NULL,
      NULL,
      22.482962,
      NULL,
      NULL,
      1,
      '34204',
      NULL,
      '',
      0.132958,
      '33223',
      NULL,
      '',
      1.174026,
      '',
      '',
      '',
      1.924240,
      9,
      NULL,
      NULL,
      1,
      20,
      NULL,
      2.233393,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      0.131246,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.490580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      3,
      1,
      1.149063,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.263170,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.825812,
      0,
      6.061904,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.287139,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.624191,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.941155,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.360619,
      2,
      3.293298,
      2.644117,
      0.787364,
      NULL,
      NULL,
      NULL,
      NULL,
      10.728525,
      6.008314,
      8,
      3.257193,
      3.733264,
      0.198915,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.099351,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.109533,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.573271,
      0.107446,
      3.679001,
      5,
      NULL,
      6.257333,
      1.852805,
      NULL,
      NULL,
      NULL,
      4,
      9,
      0.961857,
      NULL,
      NULL,
      NULL,
      3.791718,
      0.260579,
      0.844807,
      NULL,
      NULL,
      7.853102,
      4,
      1.161409,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.241246,
      2,
      2.434810,
      NULL,
      3.325789,
      3.752039,
      2.177775,
      2,
      7,
      2.192726,
      2,
      0.461508,
      5,
      0.283950,
      1,
      4,
      0,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0.840064,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.687807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.434469,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.904627,
      1.704239,
      1.379694,
      0.797977,
      1,
      1.230287,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445983,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.505010,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.296366,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.324415,
      NULL,
      NULL,
      NULL,
      3,
      2.935141,
      0,
      4,
      0.618562,
      52.486688,
      1,
      3.025479,
      6,
      0.031860,
      1.932287,
      NULL,
      NULL,
      1,
      1.493472,
      1,
      1,
      0.845102,
      2.940398,
      1.144001,
      NULL,
      NULL,
      1,
      NULL,
      0.756978,
      79,
      4,
      1,
      1.715843,
      0,
      1,
      1.391386,
      0.137806,
      NULL,
      NULL,
      0,
      0,
      1.131586,
      0.951936,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      4.130157,
      NULL,
      5.927507,
      3,
      NULL,
      NULL,
      NULL,
      3.394553,
      1,
      1,
      NULL,
      NULL,
      1,
      3.210741,
      NULL,
      NULL,
      2.903132,
      NULL,
      1,
      1.985769,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3.431935,
      NULL,
      1,
      1.066668,
      NULL,
      3.811570,
      0.831739,
      NULL,
      2.685974,
      1,
      NULL,
      3.328915,
      2,
      NULL,
      1.624760,
      0.555422,
      NULL,
      2.702984,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483792,
      NULL,
      0,
      NULL,
      1,
      5,
      NULL,
      3.443915,
      3.224705,
      1.236337,
      17.949947,
      NULL,
      NULL,
      0.772706,
      NULL,
      '23342',
      '33201',
      '',
      3.499024,
      '21240',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


