set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '3',
      NULL,
      NULL,
      NULL,
      3,
      0.094138,
      NULL,
      2,
      '0113',
      1.703747,
      0,
      NULL,
      NULL,
      ' 1-21-1993',
      9,
      NULL,
      4,
      2.479905,
      NULL,
      ' 3-17-1984',
      10.527244,
      1.428602,
      164,
      51.303920,
      3,
      ' 5-17-1998',
      ' 7- 0-1988',
      NULL,
      3,
      0.639819,
      0.719642,
      NULL,
      1.253926,
      2,
      0,
      0.615980,
      NULL,
      NULL,
      NULL,
      5.586160,
      9.536518,
      145.148878,
      13.604091,
      4,
      24.219080,
      3,
      3,
      9.161972,
      1.780237,
      0,
      1,
      NULL,
      1.838783,
      0.408843,
      1,
      0,
      1,
      1,
      0.406817,
      5,
      1,
      3,
      0.254920,
      2,
      0,
      1,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.780000,
      0,
      1,
      3.840380,
      2.170664,
      0,
      0.088932,
      0,
      0,
      0,
      4,
      0,
      10.207723,
      3,
      0,
      1,
      1.898402,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      5,
      0,
      2,
      2,
      1,
      1,
      0,
      4,
      NULL,
      NULL,
      2,
      0,
      1,
      1,
      NULL,
      1,
      1.488613,
      NULL,
      0,
      NULL,
      2,
      1,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      1,
      1,
      1,
      1,
      3,
      2,
      4,
      NULL,
      0,
      4,
      3,
      NULL,
      1,
      1,
      0,
      NULL,
      '11-26-2001',
      27.846188,
      ' 7-17-1998',
      57.503547,
      1.194336,
      2,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      1,
      1,
      NULL,
      2.127349,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.010748,
      5,
      1,
      0,
      NULL,
      2,
      2,
      NULL,
      NULL,
      NULL,
      0.132560,
      NULL,
      1.313894,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094334,
      0.364572,
      NULL,
      1,
      0,
      1.836173,
      0,
      3.051547,
      24,
      NULL,
      0.262701,
      NULL,
      NULL,
      NULL,
      2,
      0.251428,
      0.320848,
      1,
      3,
      0,
      0,
      2,
      NULL,
      0,
      3,
      2,
      2,
      3,
      2.052568,
      9.184795,
      1.128312,
      1.710134,
      0.932666,
      1.416969,
      NULL,
      1.893873,
      NULL,
      1,
      1.219467,
      0,
      0,
      NULL,
      1,
      1.029636,
      2,
      0.097405,
      7.508483,
      6.589567,
      7,
      NULL,
      NULL,
      NULL,
      5,
      3.956848,
      6,
      2,
      3,
      2.617239,
      16,
      NULL,
      0,
      NULL,
      45,
      22,
      65,
      2,
      0.195208,
      4,
      '43412',
      NULL,
      '',
      0,
      '',
      '',
      '',
      NULL,
      '2134',
      NULL,
      '',
      1.276090,
      44,
      22.218819,
      4,
      1,
      40.360696,
      3,
      NULL,
      1,
      0.217263,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.449676,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.562560,
      NULL,
      NULL,
      0.366431,
      NULL,
      NULL,
      1.031383,
      NULL,
      NULL,
      1.717993,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.568468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.429012,
      NULL,
      NULL,
      3,
      0.573294,
      1.176973,
      3.574972,
      3,
      1.298901,
      NULL,
      1.457653,
      2.544340,
      3.320292,
      0.108148,
      0,
      2,
      0.255140,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.843624,
      2.580021,
      NULL,
      2.910544,
      1.888568,
      NULL,
      8,
      10,
      5.706845,
      NULL,
      1.128273,
      NULL,
      NULL,
      NULL,
      0.461280,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.706738,
      0.168121,
      0.334062,
      NULL,
      2.563374,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.341842,
      1,
      3.856568,
      1,
      2.421116,
      1,
      NULL,
      3.271841,
      4.418223,
      1.409516,
      0,
      NULL,
      NULL,
      0.766410,
      NULL,
      NULL,
      1.354416,
      NULL,
      NULL,
      0.079291,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.698468,
      NULL,
      NULL,
      0.704566,
      NULL,
      NULL,
      0.936815,
      NULL,
      NULL,
      2.281102,
      NULL,
      3.875303,
      3.858832,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.219243,
      NULL,
      NULL,
      0,
      1,
      3.163304,
      2.731916,
      1,
      3,
      5.354643,
      1.337350,
      NULL,
      NULL,
      0,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      1.382051,
      1.375952,
      NULL,
      NULL,
      NULL,
      5.241737,
      0.137617,
      7,
      3.861564,
      2,
      0.028999,
      0,
      1,
      1.793863,
      1.409147,
      0.644310,
      0.961456,
      0,
      NULL,
      NULL,
      NULL,
      3.802057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.706087,
      NULL,
      NULL,
      1.506954,
      NULL,
      NULL,
      1.124581,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      0.807494,
      0,
      NULL,
      NULL,
      1,
      2.128907,
      1.032427,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.966523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.604325,
      NULL,
      NULL,
      NULL,
      1.225737,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.191032,
      NULL,
      NULL,
      0.131822,
      NULL,
      NULL,
      1.123198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      235,
      NULL,
      1.879745,
      1,
      1,
      1,
      0.063479,
      1.382694,
      NULL,
      1.923408,
      2.205595,
      1,
      NULL,
      1.957536,
      0,
      0,
      1.439492,
      0,
      0.553656,
      0.607438,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2.633931,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.817387,
      NULL,
      NULL,
      NULL,
      1,
      1.038269,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.687345,
      NULL,
      0.661403,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.275528,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.090101,
      NULL,
      1.470857,
      0,
      1.861489,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.483885,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.111001,
      0.362345,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.698419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.636968,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      1.273753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.483339,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.680410,
      1.244066,
      1.568764,
      1.438090,
      3,
      NULL,
      2,
      3.714448,
      NULL,
      0,
      0.406625,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0.144889,
      1.361991,
      NULL,
      0,
      NULL,
      NULL,
      1.815512,
      0,
      NULL,
      1.644686,
      1.868795,
      NULL,
      2.244355,
      0,
      NULL,
      0.357541,
      0,
      NULL,
      1.356414,
      NULL,
      NULL,
      NULL,
      1.488277,
      NULL,
      3,
      0,
      3,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.542448,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.337653,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      130,
      0,
      76,
      3.428598,
      3.097614,
      NULL,
      NULL,
      NULL,
      3.268788,
      NULL,
      1,
      NULL,
      0.192266,
      NULL,
      0,
      NULL,
      1.461847,
      NULL,
      2.309534,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.154136,
      NULL,
      0,
      NULL,
      128.061876,
      1,
      1854.317516,
      NULL,
      NULL,
      0.150016,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1,
      0.702541,
      NULL,
      NULL,
      70,
      25,
      2,
      0.190233,
      1,
      '03032',
      NULL,
      '',
      1,
      '',
      '',
      '',
      3,
      '1343',
      NULL,
      NULL);
commit;
end;
/


