set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '0',
      NULL,
      NULL,
      '0441202',
      2,
      0,
      3,
      NULL,
      '0330',
      3,
      1.827639,
      NULL,
      NULL,
      ' 0-25-1999',
      24.185436,
      NULL,
      0,
      3,
      1.848632,
      NULL,
      NULL,
      0.889756,
      280,
      NULL,
      1,
      NULL,
      ' 7- 4-1997',
      ' 4- 4-1998',
      1.184137,
      1.475655,
      0,
      2,
      NULL,
      2,
      0,
      1.923308,
      NULL,
      NULL,
      NULL,
      3.513890,
      7.006817,
      81.279433,
      3,
      0,
      7.219473,
      NULL,
      2,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.142550,
      0.622141,
      0.419036,
      1.490565,
      NULL,
      0,
      2,
      0.407935,
      2,
      2,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.960695,
      2,
      1,
      1.915827,
      3,
      1,
      NULL,
      NULL,
      0,
      0.292716,
      1,
      NULL,
      NULL,
      0,
      0.318254,
      0.497579,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      1.119576,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      2,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5,
      1,
      0,
      1,
      NULL,
      0.418561,
      NULL,
      1.214785,
      5,
      0,
      0,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      5,
      0,
      2,
      NULL,
      0,
      1,
      4,
      2,
      0,
      0,
      3,
      NULL,
      0,
      4,
      5,
      NULL,
      5,
      2.948316,
      ' 2- 8-2001',
      102,
      ' 9-24-1979',
      39,
      0.116290,
      2,
      1,
      2,
      1,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0,
      3.602547,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      6.254688,
      NULL,
      3.870128,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5.315227,
      1.849297,
      0.604497,
      5.322218,
      NULL,
      4,
      5,
      1,
      NULL,
      NULL,
      1,
      9.815472,
      0.415809,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.104029,
      0,
      0.623606,
      1.991079,
      1,
      1.897122,
      0.214368,
      0,
      13,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      2,
      0,
      0,
      1,
      2,
      3,
      1,
      NULL,
      2.116220,
      1,
      1.159938,
      1.396061,
      0.876276,
      NULL,
      NULL,
      0.691749,
      1,
      1.219061,
      0.046852,
      1.041526,
      1.757907,
      0.356463,
      NULL,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      10,
      55,
      15.468094,
      1,
      NULL,
      5,
      '13213',
      NULL,
      '',
      1.119259,
      '',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      2.758989,
      NULL,
      8,
      7,
      NULL,
      34.617499,
      1.513470,
      2.965966,
      2,
      0.154075,
      NULL,
      NULL,
      1.998013,
      NULL,
      NULL,
      1.626873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.198704,
      NULL,
      NULL,
      0.691845,
      NULL,
      NULL,
      0.435831,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.214737,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.858493,
      0.661116,
      2.570159,
      0,
      NULL,
      NULL,
      1.000526,
      NULL,
      NULL,
      2,
      0,
      0,
      3.429546,
      2.496527,
      0.557638,
      0.884916,
      1,
      1,
      2.855168,
      0,
      0.506804,
      0.583582,
      NULL,
      1.939930,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.084017,
      NULL,
      NULL,
      1,
      8,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.555729,
      0,
      0.301362,
      1,
      NULL,
      0.802037,
      NULL,
      NULL,
      2.572001,
      6.863819,
      1.606701,
      1.635470,
      3,
      0,
      3,
      1.469823,
      1.111320,
      3.911613,
      4.625334,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.658803,
      NULL,
      NULL,
      3.782121,
      0.326601,
      NULL,
      3,
      3.538296,
      0.200384,
      2.045723,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297747,
      NULL,
      NULL,
      NULL,
      0.246711,
      1,
      3.235243,
      0.161820,
      0,
      1,
      3.118057,
      3.472477,
      10.357788,
      11.835309,
      7.923546,
      NULL,
      3,
      NULL,
      1.383800,
      NULL,
      NULL,
      2,
      2.751805,
      1.385422,
      NULL,
      2.487468,
      3,
      4,
      NULL,
      2,
      NULL,
      1.823068,
      1,
      0.637918,
      NULL,
      3,
      0.777856,
      NULL,
      NULL,
      0.673476,
      NULL,
      1.005319,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.966282,
      NULL,
      NULL,
      0.401160,
      NULL,
      NULL,
      1.769300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314881,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2.025943,
      NULL,
      NULL,
      1.617450,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.028873,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.084608,
      1,
      1.064986,
      0.637272,
      NULL,
      NULL,
      NULL,
      NULL,
      7.321092,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.385867,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.684233,
      NULL,
      NULL,
      NULL,
      1.981620,
      NULL,
      NULL,
      NULL,
      1.009129,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.784018,
      NULL,
      NULL,
      NULL,
      2.510883,
      NULL,
      NULL,
      NULL,
      1.252757,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      14.252969,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      4.620994,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.225508,
      17640,
      114.883788,
      0,
      NULL,
      NULL,
      NULL,
      1.185207,
      0,
      0,
      0,
      NULL,
      0,
      2,
      1.157937,
      0.233361,
      1.823532,
      0,
      NULL,
      NULL,
      1.323729,
      1.389405,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.520332,
      NULL,
      NULL,
      NULL,
      42.003342,
      NULL,
      0.142740,
      NULL,
      24,
      NULL,
      1,
      1.047788,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.920947,
      NULL,
      0.413366,
      NULL,
      0.739727,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.014393,
      NULL,
      0.441894,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.118830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      2.618988,
      0,
      1.596020,
      NULL,
      2,
      2.279354,
      NULL,
      NULL,
      0.234357,
      1.570925,
      NULL,
      NULL,
      14.988695,
      NULL,
      2.143183,
      NULL,
      NULL,
      1.441559,
      1.836019,
      NULL,
      1.711647,
      3.876421,
      NULL,
      1.078770,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.285165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.521143,
      NULL,
      0,
      0.156582,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.718445,
      NULL,
      1,
      NULL,
      2.957001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.206723,
      NULL,
      8,
      NULL,
      0.385713,
      NULL,
      0,
      NULL,
      3.197452,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.544603,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.748152,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.093211,
      NULL,
      1.718032,
      NULL,
      0.583181,
      NULL,
      0,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.235463,
      NULL,
      0.533259,
      NULL,
      1,
      3,
      4,
      0.924353,
      NULL,
      NULL,
      77.784364,
      73.594051,
      5,
      NULL,
      NULL,
      '44414',
      '32122',
      '23411',
      1.699191,
      NULL,
      NULL,
      NULL,
      1,
      '',
      '',
      '');
commit;
end;
/


