set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8816454';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      '4302444',
      NULL,
      1.648856,
      NULL,
      0,
      '2043',
      0,
      0,
      NULL,
      NULL,
      ' 4- 5-1995',
      34,
      NULL,
      4,
      NULL,
      0,
      ' 3- 4-1984',
      15.059411,
      NULL,
      178.161701,
      50,
      1,
      NULL,
      ' 5-22-1992',
      '10-17-1984',
      0.999052,
      1.074376,
      1.136676,
      NULL,
      0,
      1.873418,
      2,
      3.324873,
      NULL,
      NULL,
      NULL,
      NULL,
      1.755255,
      80,
      11,
      2,
      NULL,
      2,
      NULL,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      1.587250,
      NULL,
      1.145483,
      2.798680,
      NULL,
      0,
      1,
      2,
      0.888125,
      2,
      0,
      0,
      NULL,
      1,
      0,
      2,
      1,
      1,
      0,
      0,
      1,
      3.141199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      3.140239,
      0.813427,
      0,
      1.810728,
      2,
      NULL,
      3,
      1.894895,
      NULL,
      3,
      2.791194,
      1,
      1.412341,
      2.800239,
      0.621116,
      0.100820,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      1.126100,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      5,
      4,
      0,
      2,
      5,
      4,
      NULL,
      0,
      0,
      4,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      0,
      0.464251,
      NULL,
      0.432227,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      5,
      0,
      1,
      NULL,
      NULL,
      4,
      NULL,
      5,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.996329,
      '11-19-1989',
      23.056566,
      ' 5-20-1993',
      29.846658,
      0.184646,
      2,
      1,
      1,
      NULL,
      3,
      NULL,
      NULL,
      0,
      0,
      5,
      3,
      2,
      NULL,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.971657,
      NULL,
      NULL,
      NULL,
      2,
      2.870253,
      NULL,
      4,
      4,
      0,
      3.639026,
      1.619521,
      NULL,
      NULL,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.673290,
      0,
      NULL,
      NULL,
      0,
      0,
      0,
      3.781720,
      15,
      1.659295,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.876241,
      3,
      0,
      3,
      2,
      NULL,
      NULL,
      0,
      2,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      0,
      0.170542,
      3.871879,
      1.884276,
      0.615942,
      1.270624,
      0,
      1.735639,
      0.596887,
      1,
      0,
      0,
      NULL,
      0.505462,
      0,
      1,
      4,
      NULL,
      0,
      5,
      5.631966,
      NULL,
      0,
      4,
      NULL,
      2,
      0,
      NULL,
      0,
      2.627373,
      NULL,
      31,
      18,
      17,
      1,
      NULL,
      NULL,
      NULL,
      '02334',
      '',
      NULL,
      NULL,
      '',
      '',
      0.105366,
      '4322',
      NULL,
      '',
      1.093809,
      29.700904,
      NULL,
      37.818063,
      NULL,
      15,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.639415,
      NULL,
      NULL,
      0.854172,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.673858,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.880203,
      NULL,
      NULL,
      1.330377,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.349059,
      0,
      0.934284,
      NULL,
      NULL,
      0.836669,
      NULL,
      NULL,
      1.464276,
      1.108937,
      1.860723,
      1.656787,
      3.153581,
      1,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2.275737,
      NULL,
      NULL,
      1.688472,
      0,
      0.535963,
      NULL,
      NULL,
      1,
      3.102201,
      0.716586,
      NULL,
      0.984449,
      NULL,
      NULL,
      3,
      2.360432,
      0,
      0.573255,
      NULL,
      NULL,
      NULL,
      0.030972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.761739,
      NULL,
      0.319960,
      0,
      3.448040,
      2.011447,
      0.852380,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.463791,
      2.661161,
      1,
      NULL,
      3.934912,
      NULL,
      5,
      0.641583,
      0.990493,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.148248,
      NULL,
      NULL,
      0.965435,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.776860,
      NULL,
      NULL,
      3,
      0.760739,
      NULL,
      NULL,
      NULL,
      1,
      0.321269,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.520147,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.188889,
      2,
      3,
      3,
      1.660746,
      3,
      5,
      4.626585,
      NULL,
      0.573536,
      1,
      0.407265,
      2.397164,
      0,
      0,
      3,
      1.649689,
      0,
      3.501013,
      0.850240,
      0.431933,
      1,
      2.736206,
      NULL,
      6,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1.417862,
      NULL,
      1.012753,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.280671,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.601574,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      3.466591,
      0.153670,
      NULL,
      NULL,
      2.101144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.547552,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.551991,
      NULL,
      NULL,
      NULL,
      1.416424,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.427496,
      1.396000,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.212145,
      NULL,
      NULL,
      0.932552,
      NULL,
      NULL,
      1.061846,
      NULL,
      NULL,
      1.140993,
      NULL,
      0,
      89,
      11,
      0,
      1.881850,
      NULL,
      0,
      1,
      1.700814,
      1,
      0,
      3,
      NULL,
      2,
      0.218246,
      1.444831,
      NULL,
      1.086779,
      1,
      2.814512,
      NULL,
      3,
      NULL,
      1.026257,
      NULL,
      NULL,
      NULL,
      2.597532,
      NULL,
      NULL,
      NULL,
      97,
      NULL,
      NULL,
      NULL,
      20,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.229982,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.441343,
      NULL,
      0.658333,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.495343,
      NULL,
      0,
      NULL,
      0.407681,
      NULL,
      0.218223,
      0.197031,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.291656,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.828883,
      0.543451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.946331,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.381643,
      2.544525,
      NULL,
      1.565517,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.890104,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      3,
      1,
      1.026135,
      0.998698,
      0,
      1,
      1,
      1,
      NULL,
      0,
      0.307507,
      NULL,
      1.488389,
      0,
      NULL,
      2.254461,
      1,
      NULL,
      NULL,
      0.040278,
      NULL,
      0.929529,
      0.812966,
      NULL,
      1.393282,
      0.240702,
      NULL,
      0,
      0.348335,
      NULL,
      1.752713,
      1.977517,
      NULL,
      0.936962,
      0.599652,
      NULL,
      1.081304,
      3,
      NULL,
      0.152869,
      1,
      NULL,
      2,
      0.439848,
      3.011374,
      0.431431,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.279962,
      NULL,
      0,
      NULL,
      3.480876,
      NULL,
      2,
      NULL,
      3,
      NULL,
      0,
      NULL,
      11,
      NULL,
      NULL,
      2.731595,
      NULL,
      NULL,
      1.546640,
      NULL,
      NULL,
      NULL,
      2.628401,
      NULL,
      3,
      NULL,
      0,
      NULL,
      3.315025,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.708503,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      25,
      1.579952,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      0.830258,
      NULL,
      NULL,
      96.677523,
      NULL,
      4,
      1,
      1.214630,
      '12333',
      NULL,
      '00423',
      1,
      '',
      '',
      '',
      0,
      '0112',
      '',
      '');
commit;
end;
/


