set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8119304';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-6-30 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      7.799542,
      2.802361,
      NULL,
      1,
      0,
      3,
      5.219434,
      3.854438,
      NULL,
      '11331332',
      NULL,
      16,
      '4140222',
      NULL,
      NULL,
      1,
      1,
      '3032',
      NULL,
      1.877258,
      NULL,
      NULL,
      ' 6-18-1982',
      34,
      11,
      NULL,
      2.110060,
      4,
      ' 2- 2-2002',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 4-18-2001',
      ' 6-15-1988',
      ' 5-26-1978',
      1.759454,
      0.359309,
      3,
      2.804679,
      1.412068,
      1,
      0,
      NULL,
      1,
      38.069705,
      NULL,
      9,
      0.813919,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      NULL,
      0.580974,
      0,
      1,
      1,
      0,
      0,
      0,
      1.779759,
      NULL,
      NULL,
      0,
      NULL,
      4,
      3,
      NULL,
      2,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0,
      2,
      4,
      3.761669,
      0,
      2,
      0,
      0,
      0.259427,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      NULL,
      3.659827,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3,
      7,
      1,
      NULL,
      1.745441,
      1.049922,
      NULL,
      NULL,
      0,
      0,
      2,
      NULL,
      1,
      2,
      0,
      4,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      0.802314,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      0.213451,
      0,
      0,
      NULL,
      4,
      NULL,
      1,
      1,
      1,
      3,
      3,
      1,
      1,
      5,
      1,
      0,
      3,
      2,
      5,
      3,
      0,
      2,
      0,
      0,
      3,
      NULL,
      NULL,
      2.402445,
      NULL,
      3,
      ' 9-13-1977',
      21.184620,
      1.157651,
      1,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      7,
      1.931432,
      2.148775,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400942,
      1,
      0,
      4.564284,
      0,
      1.037793,
      7.960797,
      0.126164,
      0.672977,
      NULL,
      0.077784,
      NULL,
      3,
      0,
      3,
      NULL,
      5.712130,
      '11-17-1999',
      NULL,
      '10- 0-1990',
      NULL,
      0.900669,
      1,
      NULL,
      0.969545,
      1.739199,
      0,
      NULL,
      0,
      1,
      0.324077,
      1,
      11.236589,
      NULL,
      0.505048,
      NULL,
      NULL,
      NULL,
      NULL,
      0.625181,
      0.964340,
      3,
      2,
      1,
      2,
      1,
      1,
      2,
      NULL,
      NULL,
      3,
      3.943970,
      2,
      2,
      2.036567,
      1,
      0.868909,
      1.988990,
      0.016311,
      1.203744,
      0,
      0,
      NULL,
      1,
      1.924441,
      1,
      NULL,
      1.678358,
      2,
      0.928036,
      4,
      NULL,
      NULL,
      1,
      6.118560,
      1,
      NULL,
      2.753717,
      4,
      2.995916,
      NULL,
      3.641433,
      1.629959,
      2,
      NULL,
      46,
      NULL,
      53,
      21,
      0,
      4.620013,
      2,
      '11433',
      '32312',
      NULL,
      3,
      '2041',
      NULL,
      '',
      0.361842,
      '',
      '',
      '',
      NULL,
      20,
      4.483000,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.462778,
      1.946300,
      NULL,
      2.371504,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.833226,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.416235,
      201,
      0.318465,
      0,
      1.723704,
      1.748303,
      0.447485,
      1.498664,
      1.516910,
      0.460635,
      NULL,
      0,
      0.249400,
      NULL,
      0.505644,
      1,
      0,
      0,
      0,
      0,
      1.621803,
      0,
      NULL,
      0.660588,
      NULL,
      1,
      NULL,
      2.936525,
      NULL,
      0,
      NULL,
      127,
      NULL,
      3.080146,
      NULL,
      3,
      NULL,
      0,
      1.649583,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.056216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.898075,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.837065,
      NULL,
      0.449188,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.584401,
      1.962883,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.165023,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.269199,
      NULL,
      1.740701,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.403626,
      1.304655,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.716171,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.089027,
      1.140437,
      NULL,
      0,
      NULL,
      3.828100,
      NULL,
      359,
      NULL,
      0.577833,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      4,
      NULL,
      3.905545,
      0,
      0.602880,
      NULL,
      NULL,
      3,
      3,
      2.281818,
      NULL,
      1,
      1,
      3,
      NULL,
      1.819624,
      1.980223,
      1.890473,
      0.935729,
      NULL,
      NULL,
      1,
      1.892785,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.125841,
      NULL,
      1,
      2,
      NULL,
      1.157989,
      2,
      NULL,
      NULL,
      1.921174,
      NULL,
      0,
      NULL,
      NULL,
      0.473240,
      NULL,
      NULL,
      1.297731,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.003371,
      NULL,
      0,
      2,
      NULL,
      1,
      3,
      0.510369,
      87.225453,
      46.329883,
      1,
      NULL,
      2.409295,
      '22303',
      NULL,
      '',
      2,
      '1324',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


