set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7837080';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-5-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '31',
      '33',
      6,
      32,
      '4144412',
      NULL,
      1.420067,
      NULL,
      1,
      '1123',
      5.361240,
      0,
      NULL,
      NULL,
      ' 5-21-1974',
      52.646053,
      3,
      NULL,
      1,
      NULL,
      ' 9-26-1997',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 1- 6-1980',
      0,
      1.585776,
      NULL,
      NULL,
      1.591612,
      2.944664,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0.881905,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.459823,
      NULL,
      1,
      0.721658,
      1,
      0,
      3,
      1,
      3,
      1,
      0,
      0,
      3,
      2,
      1,
      0,
      0,
      2,
      0,
      NULL,
      0,
      4,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.040227,
      NULL,
      NULL,
      1,
      0,
      0.533076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.295613,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0,
      4,
      NULL,
      NULL,
      1,
      1,
      4,
      0,
      0,
      0,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      1,
      2,
      1,
      1,
      1,
      1,
      1,
      0,
      0,
      4,
      NULL,
      1,
      1,
      1,
      3,
      1,
      1,
      5,
      5,
      NULL,
      0,
      0,
      1.543049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      2,
      0,
      NULL,
      4,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      0,
      1.427321,
      0.861450,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.730449,
      0.415958,
      3.655613,
      0.826194,
      0.894381,
      NULL,
      NULL,
      2.730856,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.616288,
      NULL,
      0,
      2,
      NULL,
      0,
      NULL,
      3,
      3,
      2,
      0,
      3,
      1.699907,
      3,
      0,
      0.103367,
      0,
      1,
      5,
      2.284213,
      0,
      1.079181,
      0,
      0,
      0.334128,
      0.286587,
      1.360618,
      3,
      2.468982,
      4,
      1.247302,
      NULL,
      NULL,
      3,
      7,
      0.313229,
      4,
      0.842197,
      3,
      5.421014,
      2,
      3.041350,
      3.752086,
      6,
      3,
      1,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.985445,
      NULL,
      '',
      '',
      3,
      '30143',
      '',
      NULL,
      0.791372,
      '',
      NULL,
      '',
      0.612084,
      6.686704,
      202.568122,
      52.779511,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.029684,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140198,
      NULL,
      NULL,
      0,
      1.165946,
      0.239550,
      NULL,
      0.418103,
      1.799143,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.445237,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.283460,
      NULL,
      0,
      0,
      1.836139,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.148725,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.630316,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.216994,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.983607,
      NULL,
      NULL,
      2,
      0.954006,
      NULL,
      NULL,
      NULL,
      NULL,
      0.520266,
      NULL,
      NULL,
      5.639738,
      0,
      0.666301,
      1,
      0.692730,
      0.007061,
      NULL,
      NULL,
      NULL,
      NULL,
      1.008373,
      1.955374,
      0.519580,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.968744,
      0,
      0.273349,
      4,
      NULL,
      1.595372,
      0,
      5.070043,
      0.005940,
      5,
      0,
      0,
      0.478424,
      NULL,
      NULL,
      1.347707,
      2,
      0.509141,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      0.419916,
      0,
      0,
      3.663476,
      NULL,
      1,
      0.993783,
      0.706889,
      1,
      NULL,
      0.751820,
      2,
      3,
      NULL,
      2.112264,
      2.201063,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.097638,
      1.277465,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.709667,
      2,
      3.864156,
      1.971412,
      0.299366,
      0,
      2.334741,
      NULL,
      NULL,
      NULL,
      7.963758,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.163042,
      NULL,
      NULL,
      NULL,
      0.569611,
      NULL,
      NULL,
      NULL,
      1.143313,
      NULL,
      NULL,
      NULL,
      2.248733,
      NULL,
      NULL,
      NULL,
      3.466076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.070560,
      NULL,
      NULL,
      NULL,
      0.473143,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.420482,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.184133,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.186086,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.546765,
      NULL,
      NULL,
      0.867618,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.317423,
      0.087457,
      1,
      1.728843,
      NULL,
      NULL,
      1.566056,
      NULL,
      NULL,
      138.973228,
      0,
      1,
      0.078533,
      1.822941,
      0,
      0,
      NULL,
      0,
      1,
      1.401765,
      1,
      0,
      0,
      1,
      0,
      0.745827,
      1.328777,
      0,
      0.176516,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.383130,
      1.974782,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.685323,
      0.575123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.054300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.277160,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.575891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      1.955437,
      NULL,
      NULL,
      NULL,
      1.338984,
      1,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.069934,
      NULL,
      1.139996,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      10,
      NULL,
      2.685389,
      4.918978,
      0,
      NULL,
      1.128641,
      3.134716,
      3.473218,
      0,
      1,
      0,
      0.337758,
      NULL,
      1,
      0,
      0.275250,
      0.141206,
      0,
      1,
      1,
      1.123004,
      0.472941,
      NULL,
      0.777260,
      2,
      3.417142,
      3.391745,
      2.297198,
      0,
      1.907067,
      2,
      2.422914,
      0,
      0.547669,
      1,
      1.416796,
      1,
      NULL,
      0.182759,
      NULL,
      1,
      2.622047,
      0,
      3.337588,
      0.496574,
      NULL,
      0.539471,
      1.203459,
      0.690956,
      0,
      NULL,
      2,
      1.383504,
      0,
      1,
      2.334206,
      0,
      1.971840,
      0.101873,
      3.821877,
      NULL,
      3.639949,
      NULL,
      NULL,
      1,
      1.051069,
      NULL,
      NULL,
      NULL,
      1,
      38,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.403046,
      NULL,
      1.598449,
      NULL,
      1,
      0,
      3,
      1,
      5,
      0.833925,
      NULL,
      NULL,
      103.991616,
      13,
      NULL,
      NULL,
      1,
      '30211',
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      0.586173,
      '',
      '',
      '');
commit;
end;
/


