set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '0000069';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-11-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '3322443',
      3.709655,
      1.770923,
      3,
      2,
      NULL,
      0.154893,
      2.398635,
      NULL,
      NULL,
      '10- 0-1992',
      41,
      NULL,
      NULL,
      1,
      0.232455,
      ' 9-19-1996',
      NULL,
      NULL,
      NULL,
      95.280357,
      5,
      NULL,
      NULL,
      ' 0-10-1998',
      0.894624,
      1,
      1,
      1,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5.262570,
      NULL,
      18,
      0,
      1,
      4,
      NULL,
      5.480354,
      1,
      1,
      NULL,
      1.850518,
      1,
      5.878819,
      0,
      1.045172,
      NULL,
      1,
      1.792262,
      2,
      0,
      5,
      3.652519,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1.909415,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.984675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      0.373997,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0.608489,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.490973,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      1,
      0,
      1,
      1,
      1,
      0,
      1,
      0.096411,
      1.883133,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.320236,
      NULL,
      1.338252,
      4,
      0,
      0.439276,
      3.163873,
      1.631384,
      1.896287,
      4,
      1,
      0,
      2,
      0,
      1,
      NULL,
      1,
      1,
      1.709646,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.790801,
      NULL,
      0.678897,
      0.223535,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.674132,
      0,
      3,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      2,
      1,
      NULL,
      7,
      NULL,
      0,
      6.440313,
      0.331295,
      NULL,
      0,
      NULL,
      1.053751,
      NULL,
      0.545737,
      1.222126,
      0.349809,
      5,
      7,
      4,
      6.707466,
      9,
      3.509246,
      5,
      0,
      2,
      3.914574,
      1.101842,
      3,
      56.949108,
      2,
      1.373719,
      52,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      '',
      '',
      '',
      1.942988,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      3,
      9,
      NULL,
      23.703389,
      1.494698,
      0.902561,
      NULL,
      1.691529,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.948501,
      NULL,
      NULL,
      0.072637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.632970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.333655,
      NULL,
      NULL,
      0.330583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.944097,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.712857,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.305470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.553013,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.812812,
      NULL,
      NULL,
      0.130839,
      NULL,
      NULL,
      0.549284,
      NULL,
      NULL,
      1.907669,
      NULL,
      NULL,
      1.501199,
      NULL,
      NULL,
      0.571863,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.475267,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.399035,
      NULL,
      NULL,
      0.367241,
      NULL,
      NULL,
      0.041278,
      NULL,
      NULL,
      1.398800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391766,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.035955,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747029,
      NULL,
      NULL,
      1.947510,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.451085,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.108510,
      NULL,
      0.529630,
      NULL,
      0.763360,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.832329,
      2,
      1.235933,
      0.910020,
      0.288566,
      5.665266,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.333393,
      NULL,
      NULL,
      NULL,
      0.145917,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.662772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.419124,
      NULL,
      NULL,
      NULL,
      0.074111,
      NULL,
      NULL,
      NULL,
      0.070103,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.077217,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0.412265,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.477318,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.731617,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.621665,
      NULL,
      1,
      NULL,
      1810,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1.368288,
      1.898910,
      NULL,
      0,
      1.865055,
      0.127086,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      2,
      NULL,
      2,
      NULL,
      1.999916,
      1,
      1.514724,
      3.752183,
      NULL,
      3.509162,
      1.159867,
      1,
      0.132166,
      0.909590,
      1.528767,
      NULL,
      0,
      0.496601,
      NULL,
      1.292674,
      1,
      NULL,
      0.105891,
      1.229354,
      0.342996,
      1,
      1.804942,
      1.121177,
      0.398376,
      0.799572,
      1,
      1,
      1,
      1.175766,
      0.665374,
      1.233828,
      0,
      0,
      0.560500,
      1,
      0,
      NULL,
      NULL,
      0.947054,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.036246,
      17,
      0.055988,
      NULL,
      NULL,
      NULL,
      0.360415,
      NULL,
      17.440038,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.646565,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      16,
      1,
      NULL,
      0.941417,
      0,
      0,
      NULL,
      1.541688,
      0.907954,
      NULL,
      NULL,
      1,
      1.934494,
      NULL,
      NULL,
      131,
      NULL,
      0,
      0.696762,
      2,
      '10240',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      0.021837,
      '',
      '',
      '');
commit;
end;
/


