set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9130391';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-10-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      '4',
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      5,
      1,
      '1040',
      NULL,
      1,
      NULL,
      NULL,
      ' 2-19-1974',
      41,
      NULL,
      NULL,
      3,
      3.415741,
      ' 5- 8-1985',
      34,
      4.953283,
      NULL,
      23.329080,
      1,
      NULL,
      ' 1-15-1996',
      ' 3-13-1984',
      3,
      2.319282,
      0.372952,
      1.972348,
      1.594204,
      1,
      0,
      0.569486,
      1.124812,
      3,
      7,
      12,
      0,
      29.934795,
      31,
      0,
      14.218212,
      2,
      1,
      2,
      1.120325,
      3,
      0,
      1,
      1.333213,
      0,
      1,
      2.577941,
      0,
      1.245266,
      NULL,
      3,
      NULL,
      0,
      1,
      2,
      0,
      0,
      1,
      0,
      0,
      NULL,
      1,
      1,
      0,
      NULL,
      0,
      0.007753,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.759633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.505705,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      NULL,
      3,
      1,
      2,
      1,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      1,
      NULL,
      3,
      5,
      2,
      NULL,
      1,
      2,
      5,
      0,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      2,
      NULL,
      5,
      5,
      3,
      NULL,
      1.599336,
      ' 6-20-1998',
      104.131532,
      ' 6-27-1974',
      78,
      3.923829,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      0.781164,
      0,
      7.608069,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      1.822515,
      1.834691,
      1.664044,
      1.008380,
      NULL,
      2.917170,
      46,
      0.107418,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.991323,
      0,
      1,
      2,
      3,
      0,
      2,
      3,
      NULL,
      0,
      2,
      3.894071,
      15.520462,
      4,
      NULL,
      NULL,
      67.120886,
      NULL,
      186.737217,
      47,
      NULL,
      0.741965,
      0.333608,
      0,
      1.105650,
      1,
      0,
      NULL,
      14.608063,
      1,
      NULL,
      NULL,
      3.254549,
      4,
      3.750030,
      NULL,
      3,
      NULL,
      0.877765,
      0.959272,
      2,
      0,
      36,
      1,
      NULL,
      NULL,
      27,
      15,
      NULL,
      NULL,
      NULL,
      3,
      '11024',
      NULL,
      '',
      NULL,
      '',
      '',
      NULL,
      0.485931,
      NULL,
      '',
      NULL,
      0.439555,
      NULL,
      12,
      NULL,
      1.330266,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      3.637880,
      0.436697,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      3.874802,
      1,
      NULL,
      NULL,
      0.741542,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.489529,
      1.097425,
      3.905731,
      NULL,
      1.916781,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.130690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.887538,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.856554,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.074531,
      0,
      NULL,
      1,
      NULL,
      NULL,
      3,
      7.060084,
      0.474138,
      0,
      1,
      0,
      1.211326,
      NULL,
      NULL,
      NULL,
      4,
      7,
      0,
      NULL,
      NULL,
      1.948131,
      NULL,
      NULL,
      1.281893,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.214955,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      3.621849,
      0,
      2,
      NULL,
      NULL,
      6,
      8.945236,
      10.034813,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      2,
      1.267264,
      1,
      2,
      1.310247,
      3,
      0.898407,
      2,
      0.771225,
      2,
      3.622088,
      NULL,
      0.288122,
      1.519533,
      0,
      NULL,
      NULL,
      3,
      3.162192,
      2.451572,
      NULL,
      NULL,
      3.232411,
      NULL,
      10.324975,
      NULL,
      2.926917,
      NULL,
      2.613115,
      1,
      3,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.767901,
      NULL,
      NULL,
      1.380020,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.245520,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.365112,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.779040,
      NULL,
      NULL,
      NULL,
      0.902583,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.395325,
      NULL,
      NULL,
      NULL,
      1.687951,
      NULL,
      NULL,
      NULL,
      3.989730,
      0.044165,
      NULL,
      3.106385,
      12,
      2.032512,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.665030,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.770939,
      NULL,
      1,
      NULL,
      1,
      0,
      0.734042,
      1,
      0.864874,
      0.861979,
      0,
      1.874201,
      0,
      1,
      1,
      1.396924,
      1,
      0,
      0.510138,
      1,
      1,
      1.979184,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      2,
      0,
      4,
      4,
      0,
      0,
      17,
      3,
      3,
      NULL,
      0.746815,
      1,
      NULL,
      0.107266,
      NULL,
      NULL,
      0,
      2.407738,
      NULL,
      NULL,
      1.659618,
      NULL,
      2,
      3,
      NULL,
      1.533730,
      3.922195,
      NULL,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.887697,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      1,
      NULL,
      1.914478,
      0,
      1.135432,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.295057,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      6,
      1,
      1,
      NULL,
      NULL,
      49,
      NULL,
      NULL,
      1.175655,
      0.894956,
      '31244',
      '',
      '',
      0,
      '',
      '',
      '',
      1.424178,
      NULL,
      '',
      NULL);
commit;
end;
/


