set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9237179';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-2-03 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '4',
      '3',
      NULL,
      NULL,
      '0432412',
      NULL,
      0,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      20.337822,
      NULL,
      0,
      2.458701,
      0.027126,
      ' 7-11-1986',
      36,
      3.801634,
      302,
      NULL,
      NULL,
      NULL,
      '10- 3-1995',
      ' 0-15-1990',
      1.017962,
      1.154708,
      NULL,
      NULL,
      0,
      3.934600,
      3,
      1,
      1.846313,
      50,
      0,
      1,
      0,
      16,
      22.345033,
      NULL,
      19,
      NULL,
      1,
      6.543314,
      NULL,
      3,
      0,
      0.198811,
      1,
      1,
      0.350929,
      1.066308,
      1,
      0,
      0,
      2,
      NULL,
      0,
      1.962912,
      NULL,
      0,
      1,
      4,
      3,
      3,
      2,
      NULL,
      NULL,
      4,
      3,
      1,
      2,
      1,
      2,
      1,
      2,
      0.380901,
      NULL,
      NULL,
      1.459434,
      NULL,
      NULL,
      5,
      2,
      NULL,
      1,
      1.793511,
      0,
      2,
      2.113980,
      2.037989,
      0.395806,
      1,
      3,
      0.253789,
      NULL,
      NULL,
      0.340631,
      2.466556,
      3,
      NULL,
      NULL,
      0,
      1,
      6.329014,
      NULL,
      NULL,
      NULL,
      1.409364,
      NULL,
      NULL,
      0.072931,
      NULL,
      NULL,
      0,
      3,
      4,
      NULL,
      5,
      3,
      NULL,
      2,
      5,
      0,
      2,
      3,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.656664,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      3,
      2,
      NULL,
      2,
      5,
      NULL,
      1,
      NULL,
      2,
      0,
      5,
      5,
      5,
      4,
      1,
      5,
      2,
      NULL,
      1,
      3,
      3,
      6.915151,
      3.721655,
      ' 2-12-1984',
      153,
      ' 1- 4-1990',
      284.270523,
      1.984791,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      1,
      2,
      3,
      0,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.552575,
      0,
      0.304725,
      0.868936,
      0,
      2,
      NULL,
      0,
      0.457921,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.036289,
      0.841988,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.392656,
      1.114307,
      1.321070,
      3.317534,
      NULL,
      3,
      1,
      1.013774,
      NULL,
      3.578791,
      0.314121,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      0,
      2,
      3,
      2,
      17,
      6,
      NULL,
      121.649147,
      188.833150,
      163.260633,
      114.953032,
      188.159287,
      NULL,
      NULL,
      NULL,
      NULL,
      1.088127,
      0.581167,
      1,
      13,
      1,
      0.779251,
      10,
      0,
      2.173999,
      3.128990,
      NULL,
      6,
      1.487033,
      1,
      NULL,
      NULL,
      3.612887,
      0.368404,
      15.352062,
      NULL,
      3.158469,
      NULL,
      32,
      0,
      NULL,
      NULL,
      0,
      2.410752,
      '30041',
      '',
      '',
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      2,
      32,
      88.404289,
      10,
      1,
      29.939387,
      2.456311,
      7,
      2,
      1,
      3,
      3,
      0.401345,
      NULL,
      NULL,
      2,
      0.518542,
      NULL,
      0.741077,
      1,
      0,
      1.618614,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      NULL,
      0.772656,
      1,
      NULL,
      NULL,
      3.076856,
      0.386577,
      1,
      1.242328,
      1.377137,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      7.010623,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.179510,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.123257,
      3,
      3.671453,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      0.556782,
      NULL,
      3,
      2.439782,
      1.377849,
      2.019347,
      1.165467,
      1.034458,
      2.494400,
      1,
      NULL,
      2,
      1.412179,
      2.309376,
      0.590978,
      NULL,
      NULL,
      1.816981,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.667145,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.381644,
      NULL,
      NULL,
      2,
      1,
      2.246237,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.758437,
      4,
      NULL,
      2,
      2.817115,
      3,
      3,
      0.503215,
      0.000395,
      NULL,
      3.771821,
      0.510863,
      1.382143,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.497141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400027,
      NULL,
      NULL,
      0.705859,
      0.815341,
      1,
      9.214424,
      5.571004,
      5,
      6.649457,
      NULL,
      1.946655,
      1.251037,
      0,
      3.724939,
      3.486215,
      0.213912,
      0.293724,
      1.883130,
      NULL,
      3.939387,
      1.046601,
      0.549616,
      1.412614,
      8.191402,
      6.117584,
      NULL,
      2.176901,
      NULL,
      0.335827,
      3.977655,
      3,
      0,
      0.299275,
      NULL,
      0,
      0,
      3.169059,
      1.473891,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.423943,
      3.495767,
      2,
      0,
      0.467788,
      NULL,
      0.185131,
      1.390785,
      NULL,
      1.684737,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.723437,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.625126,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.864964,
      NULL,
      NULL,
      0.963289,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1.701172,
      1.563136,
      1.465776,
      0.352680,
      NULL,
      NULL,
      2.213771,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.916345,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.094252,
      NULL,
      NULL,
      NULL,
      0.415494,
      NULL,
      NULL,
      NULL,
      0.431443,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.102048,
      NULL,
      NULL,
      NULL,
      0.479739,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.351906,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      35.951540,
      19,
      2,
      10,
      4,
      NULL,
      NULL,
      NULL,
      1.120882,
      1,
      1,
      NULL,
      71,
      21,
      2,
      NULL,
      13,
      1.703262,
      NULL,
      1,
      NULL,
      1,
      0.871388,
      NULL,
      0.321316,
      0.874508,
      NULL,
      1,
      1.364365,
      0.420873,
      1,
      1,
      0.022100,
      1.281041,
      NULL,
      0.158241,
      1.829511,
      NULL,
      1,
      0.920180,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      8.638272,
      1,
      0,
      0,
      2,
      0.480003,
      2.954512,
      3.639057,
      1.999125,
      1.268774,
      0.372757,
      NULL,
      0.320183,
      1.349012,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      NULL,
      3.808261,
      0.901844,
      NULL,
      1,
      1,
      NULL,
      0.717864,
      NULL,
      NULL,
      0.152919,
      0,
      NULL,
      0.730773,
      1,
      NULL,
      3.791212,
      3.712254,
      NULL,
      0,
      1.834804,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.023120,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      3.568307,
      1.671602,
      2.801901,
      5.557734,
      64.315455,
      4,
      0.379830,
      3,
      '24101',
      '',
      '',
      0.691299,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


