set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1993-9-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1413430',
      NULL,
      0,
      NULL,
      3,
      '3304',
      3.452364,
      0.949000,
      NULL,
      NULL,
      ' 7- 5-1980',
      20.976501,
      NULL,
      3,
      0.749259,
      NULL,
      ' 9-16-1977',
      9,
      1.553444,
      250.006017,
      43,
      2,
      ' 4-14-2001',
      ' 7-19-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2.971917,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7.710455,
      5.198639,
      20.945283,
      9.069074,
      0,
      7.338767,
      NULL,
      0,
      0.529659,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1,
      4,
      1.050885,
      4,
      0,
      1,
      5,
      5,
      1,
      NULL,
      1,
      NULL,
      2,
      1,
      0,
      9.707898,
      0,
      1,
      1,
      1,
      0.443431,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      0.881637,
      0,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0,
      1,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      4,
      NULL,
      0,
      NULL,
      0,
      2,
      2,
      0,
      NULL,
      1,
      2,
      ' 3-17-1995',
      17,
      ' 4- 1-1976',
      7,
      0,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      1,
      1,
      0,
      1,
      1.382995,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      16.056603,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.883798,
      1,
      1.329120,
      0,
      1,
      0.735583,
      6.440332,
      0,
      NULL,
      NULL,
      0,
      2.052223,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.649429,
      1,
      NULL,
      0,
      0.769711,
      0.376709,
      1,
      3.813781,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.716975,
      1,
      2,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.045421,
      2.297770,
      0,
      2,
      NULL,
      0.517031,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1.748605,
      0,
      1.679868,
      4,
      0.476182,
      8.873961,
      NULL,
      1,
      2,
      10.956405,
      4.450023,
      4.399033,
      3,
      6.104227,
      0.104661,
      0,
      0.814830,
      0,
      2,
      3,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      0.215513,
      '33233',
      '',
      '',
      0.996437,
      '',
      '',
      '',
      0.521543,
      '',
      '',
      '',
      1.390100,
      23,
      8.674907,
      29,
      NULL,
      16.715080,
      2,
      1,
      0,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.195799,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.959359,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.244585,
      NULL,
      NULL,
      NULL,
      9.434292,
      0.839386,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.474577,
      1,
      NULL,
      2.942862,
      0.494097,
      0,
      0,
      1,
      2.893987,
      2.204198,
      1.548033,
      0.661711,
      NULL,
      0.489794,
      0.595622,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.012891,
      NULL,
      0,
      5,
      3,
      1.981684,
      0,
      1.253123,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.838558,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.633104,
      NULL,
      1.585375,
      1.106498,
      0,
      0,
      1,
      NULL,
      NULL,
      3.215962,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.177425,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.082953,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      4,
      0,
      1.753514,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.659927,
      2.762129,
      0.818239,
      NULL,
      NULL,
      2.369633,
      3,
      1.353839,
      NULL,
      NULL,
      NULL,
      0,
      0.060763,
      3.776386,
      NULL,
      2.354385,
      0,
      NULL,
      2.854631,
      3.926127,
      6.829678,
      3.349440,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.860430,
      0.096265,
      0.633563,
      0.961505,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.886374,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.797248,
      0.743822,
      0.870709,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.163171,
      NULL,
      NULL,
      NULL,
      1.267739,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.137831,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.217897,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1,
      3.005981,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      1.930217,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.622879,
      1,
      NULL,
      NULL,
      4,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.680210,
      0.523804,
      NULL,
      NULL,
      0.710901,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      588.332168,
      1,
      1.893702,
      1,
      0,
      0.346312,
      1.033797,
      0.167473,
      0.476982,
      0.516868,
      NULL,
      NULL,
      NULL,
      0.030954,
      NULL,
      1,
      0.049515,
      1.008541,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.781470,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.794701,
      0.529777,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.608402,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.187683,
      0.559025,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683194,
      0.874508,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.924259,
      0,
      1.582062,
      1,
      1,
      NULL,
      NULL,
      1.655737,
      0.008233,
      1.634427,
      1,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1.623876,
      0,
      0,
      NULL,
      2,
      5.369190,
      NULL,
      NULL,
      3,
      NULL,
      1.310272,
      1,
      0.836861,
      1.637354,
      NULL,
      1,
      3.561643,
      2.484366,
      1,
      1,
      1,
      1.048934,
      2.635870,
      0.521203,
      0.991189,
      0.313703,
      NULL,
      0.239048,
      1,
      1,
      NULL,
      NULL,
      1.941916,
      0,
      NULL,
      1.866596,
      0,
      0,
      2,
      NULL,
      1,
      0.657324,
      3.955596,
      0.502949,
      0.343723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.620435,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.470047,
      1.585314,
      NULL,
      1.564214,
      NULL,
      1,
      1,
      2,
      3,
      1,
      NULL,
      NULL,
      63,
      55.282698,
      0,
      1,
      2,
      '01322',
      NULL,
      NULL,
      NULL,
      '',
      '',
      NULL,
      NULL,
      '',
      NULL,
      NULL);
commit;
end;
/


