set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9109901';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-12-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      2,
      1,
      2.961871,
      NULL,
      NULL,
      3,
      '344',
      NULL,
      56,
      44.059034,
      '1014022',
      3,
      0,
      NULL,
      NULL,
      '2404',
      1,
      1,
      NULL,
      NULL,
      ' 4-24-1979',
      20.673919,
      NULL,
      NULL,
      0.304695,
      NULL,
      ' 6-20-1977',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 3-12-1993',
      ' 0-18-1980',
      NULL,
      1,
      0,
      3.566089,
      3.315031,
      0,
      2,
      2,
      NULL,
      NULL,
      43.603709,
      0,
      17.459654,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      3.807497,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.410064,
      1,
      1,
      1,
      0,
      0,
      2,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      3,
      3,
      1,
      NULL,
      2,
      3,
      1,
      2,
      4,
      NULL,
      NULL,
      5,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      0.375491,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.388041,
      1,
      0,
      NULL,
      1,
      1.013446,
      0.372027,
      NULL,
      NULL,
      NULL,
      NULL,
      0.032377,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0.830794,
      0,
      1,
      0.971045,
      1.368774,
      2.811669,
      68,
      3.560866,
      0.255410,
      NULL,
      NULL,
      NULL,
      NULL,
      0.763777,
      2.952561,
      NULL,
      1,
      3,
      3,
      3,
      1,
      2,
      0,
      2,
      3,
      2,
      1,
      3,
      1,
      1.195197,
      1,
      1.024292,
      NULL,
      0.328471,
      0.437457,
      0,
      1.898084,
      1.646818,
      1.096960,
      1.155624,
      0,
      NULL,
      0.318771,
      0,
      11,
      NULL,
      4,
      NULL,
      10.403090,
      6.859227,
      0.110128,
      1,
      6.901988,
      0,
      NULL,
      3.890444,
      5,
      2,
      3.591170,
      NULL,
      NULL,
      20,
      43.508558,
      2,
      NULL,
      2.700250,
      '21324',
      '',
      '',
      1,
      '',
      '',
      '',
      0.201837,
      '',
      '',
      '',
      3,
      NULL,
      NULL,
      35.335968,
      NULL,
      12,
      3,
      1,
      4,
      0.043478,
      1.224264,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.602348,
      0.121420,
      1.067930,
      NULL,
      NULL,
      1.427135,
      NULL,
      NULL,
      1.209598,
      NULL,
      NULL,
      0.166507,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.672534,
      6.263483,
      NULL,
      NULL,
      1.501420,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.676565,
      NULL,
      NULL,
      0.389670,
      NULL,
      NULL,
      0.509229,
      1,
      1.993584,
      NULL,
      1,
      0,
      3.013820,
      NULL,
      0,
      NULL,
      0,
      0,
      NULL,
      1.905815,
      0,
      1,
      1,
      NULL,
      NULL,
      0.856510,
      NULL,
      NULL,
      3.332955,
      0.906449,
      3,
      7,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      1.748846,
      NULL,
      NULL,
      NULL,
      NULL,
      5.720364,
      0.313563,
      3.939630,
      3,
      0.743251,
      1,
      NULL,
      NULL,
      4.596989,
      2,
      NULL,
      1.726907,
      NULL,
      NULL,
      1.480044,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.074812,
      NULL,
      NULL,
      0.073565,
      NULL,
      NULL,
      0.644629,
      NULL,
      NULL,
      1.316425,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      1,
      0.371744,
      5,
      2,
      2,
      4.571824,
      5,
      NULL,
      0,
      1,
      3.549758,
      1.733938,
      2.195914,
      3,
      NULL,
      3,
      0,
      6.665673,
      5.148797,
      0,
      0.396887,
      NULL,
      0,
      3,
      1.189137,
      1,
      1,
      3.107579,
      0,
      1,
      3,
      0.522207,
      0,
      0,
      5,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.680246,
      0,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.993348,
      NULL,
      NULL,
      0.396292,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      0.165934,
      0,
      1,
      1,
      0.853436,
      3.805604,
      2.694528,
      NULL,
      NULL,
      4.276534,
      0,
      NULL,
      NULL,
      22.718553,
      5,
      NULL,
      NULL,
      0.860271,
      3,
      NULL,
      NULL,
      1,
      0.231509,
      NULL,
      NULL,
      2.897003,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.014823,
      0,
      NULL,
      NULL,
      1.502945,
      1,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.019573,
      0.827608,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.142851,
      NULL,
      NULL,
      NULL,
      1.159797,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      39.117097,
      8.291148,
      2,
      NULL,
      2,
      1.475568,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.873393,
      NULL,
      NULL,
      0.464115,
      NULL,
      NULL,
      1.319230,
      NULL,
      0.870648,
      31,
      NULL,
      0.145215,
      NULL,
      0.592704,
      NULL,
      0,
      1,
      0.455916,
      NULL,
      0,
      0.889921,
      1.542197,
      NULL,
      1,
      0.346572,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.717565,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.769711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.704217,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.472967,
      1.365560,
      NULL,
      0.019091,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.912502,
      NULL,
      1.699695,
      0,
      1.607848,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0,
      0,
      2,
      5.193601,
      1.668964,
      3,
      NULL,
      0.086742,
      1.435035,
      2.648458,
      1.259885,
      0.936712,
      0,
      1.804866,
      NULL,
      1.855424,
      0.036251,
      NULL,
      2.559424,
      1,
      0.857641,
      1,
      3,
      1.872997,
      3.041572,
      NULL,
      1.217161,
      0,
      NULL,
      0.325245,
      0,
      1.431045,
      1,
      0.861105,
      1.189713,
      NULL,
      NULL,
      NULL,
      1,
      1.914825,
      NULL,
      1,
      2.337083,
      1.057222,
      2.706641,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.533076,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.279228,
      1.787384,
      1,
      1,
      1,
      NULL,
      7,
      1,
      NULL,
      0.069405,
      41,
      61,
      NULL,
      5.243385,
      3.370086,
      NULL,
      '',
      '',
      1.637346,
      '',
      NULL,
      '',
      1,
      '',
      '',
      NULL);
commit;
end;
/


