set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423644';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.371552,
      2.512916,
      0,
      2,
      3,
      1,
      2,
      2,
      '203',
      NULL,
      35.425843,
      31,
      '4320013',
      3,
      0,
      3,
      NULL,
      '4141',
      3,
      1.748327,
      NULL,
      NULL,
      ' 8- 4-1988',
      NULL,
      1.073212,
      NULL,
      1.589592,
      0.409672,
      '11- 3-1991',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 9-27-2002',
      NULL,
      0.435905,
      3,
      2.408482,
      0.111758,
      3,
      NULL,
      3.639884,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      1,
      1,
      0.087161,
      1.638148,
      1,
      0,
      4,
      NULL,
      NULL,
      0.045817,
      NULL,
      1,
      1,
      0,
      1,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      0,
      1,
      1,
      0,
      0,
      0,
      0,
      0,
      0.532541,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      0.465712,
      0,
      1,
      0,
      0,
      0,
      0,
      1,
      1,
      1,
      1,
      1,
      0,
      4,
      0,
      1,
      NULL,
      1,
      1,
      1,
      4,
      1,
      1,
      NULL,
      1,
      0,
      1.070968,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.181779,
      0.794213,
      NULL,
      NULL,
      NULL,
      1,
      1.966905,
      0,
      0.318468,
      0.033295,
      0,
      1.760464,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.000507,
      0,
      1.704064,
      1.078512,
      1.883678,
      NULL,
      1.266616,
      1,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.447176,
      3,
      1,
      1,
      NULL,
      2,
      3,
      2,
      3,
      1,
      0,
      0,
      2,
      2,
      4,
      NULL,
      3,
      0,
      0.850441,
      1.102324,
      1,
      1.127174,
      1.797866,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      5,
      NULL,
      2.539293,
      11,
      5.608679,
      6,
      NULL,
      3,
      3.414565,
      NULL,
      2,
      0,
      1.517088,
      NULL,
      26,
      NULL,
      0.878749,
      35,
      NULL,
      NULL,
      NULL,
      0,
      1.500548,
      1,
      '22032',
      '',
      '',
      1,
      '',
      '',
      '',
      0.856097,
      '2030',
      '',
      NULL,
      3,
      15.130881,
      130.289743,
      NULL,
      0,
      30.526447,
      4.712619,
      NULL,
      3,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1.644574,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0,
      NULL,
      1,
      2,
      0,
      0,
      3.040306,
      0,
      1,
      2,
      0.190867,
      NULL,
      2.894786,
      3,
      NULL,
      11,
      6,
      5,
      NULL,
      0.482851,
      NULL,
      NULL,
      NULL,
      3,
      1.636940,
      NULL,
      2.168523,
      NULL,
      3.983851,
      1,
      0.152191,
      NULL,
      NULL,
      1.260297,
      NULL,
      NULL,
      NULL,
      0.541666,
      1.280211,
      2.455525,
      1,
      3,
      NULL,
      2.832763,
      1.032472,
      NULL,
      1.116330,
      0.004961,
      1.956867,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.478825,
      1.974262,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.872627,
      NULL,
      NULL,
      1.608183,
      NULL,
      NULL,
      2,
      NULL,
      0,
      1.737427,
      NULL,
      1.062341,
      NULL,
      NULL,
      NULL,
      9,
      6.219899,
      1.892546,
      0.349200,
      0,
      1.056609,
      NULL,
      1.570770,
      1.729221,
      3,
      1.669646,
      1.586205,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.346509,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.767081,
      NULL,
      NULL,
      1.067013,
      NULL,
      NULL,
      NULL,
      1,
      0.228781,
      4.868961,
      0,
      0.946046,
      1,
      1.820666,
      NULL,
      1,
      NULL,
      NULL,
      3.493360,
      1,
      0.927095,
      2.662100,
      0.991686,
      NULL,
      3.700131,
      1,
      1,
      4.420913,
      0,
      1.470076,
      NULL,
      NULL,
      0.435047,
      3.310476,
      0,
      NULL,
      1.193276,
      3.219822,
      3.686323,
      2,
      2,
      1.085069,
      3.908967,
      5.705475,
      3.298055,
      4.717775,
      0,
      1.039604,
      2.971897,
      0,
      NULL,
      1,
      NULL,
      1.338584,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      19.898307,
      NULL,
      NULL,
      2.810594,
      NULL,
      NULL,
      2.387669,
      NULL,
      NULL,
      0.898795,
      NULL,
      NULL,
      1.471400,
      NULL,
      NULL,
      2.720113,
      NULL,
      NULL,
      3.546138,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.438205,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.820958,
      2,
      1.517472,
      0,
      2.025089,
      2,
      2.942150,
      NULL,
      5,
      NULL,
      0.228052,
      NULL,
      3,
      9,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.068289,
      NULL,
      NULL,
      3,
      0.780658,
      0.537273,
      NULL,
      0.951282,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.093047,
      3.824104,
      0,
      NULL,
      1,
      0.721568,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.837712,
      NULL,
      NULL,
      NULL,
      3.871601,
      3,
      NULL,
      NULL,
      NULL,
      1,
      0.096437,
      NULL,
      0,
      0.257838,
      NULL,
      NULL,
      0,
      0.347940,
      2.614347,
      NULL,
      0.521910,
      0.013219,
      0.700619,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1.633557,
      NULL,
      3.985827,
      0,
      1.300482,
      NULL,
      13.135979,
      3.451953,
      3,
      NULL,
      2.062154,
      0.931569,
      3.457192,
      2,
      4,
      2.922463,
      397.415153,
      56.400708,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      79.819775,
      10.848295,
      1.911722,
      25.996283,
      27.356529,
      1.976556,
      11.043199,
      NULL,
      1.383441,
      NULL,
      0,
      41.570808,
      0,
      NULL,
      0,
      0,
      1.165252,
      NULL,
      0,
      0,
      0.671072,
      1,
      0.428745,
      0.365975,
      1.515805,
      1.619647,
      1.327564,
      0.613823,
      0,
      NULL,
      1.241810,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666487,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.198283,
      0,
      NULL,
      0,
      0,
      NULL,
      1.487070,
      3.721036,
      1.875672,
      1.822949,
      NULL,
      NULL,
      0,
      NULL,
      1.864156,
      2.132726,
      3.034562,
      0.274818,
      NULL,
      0.494601,
      1,
      1,
      0,
      0.780394,
      NULL,
      1.603775,
      1,
      3,
      0,
      1.506451,
      0.330452,
      1.519273,
      1.745763,
      1.631076,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.687772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.059717,
      1.719130,
      0,
      2,
      1,
      NULL,
      1.100576,
      NULL,
      NULL,
      55,
      110,
      5,
      0.155477,
      3,
      '31012',
      '',
      '',
      0,
      '',
      NULL,
      '',
      1,
      '2330',
      '',
      '');
commit;
end;
/


