set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9422857';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1994-8-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      '4312212',
      3,
      1.242704,
      1,
      3,
      '2411',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      45,
      NULL,
      5,
      2.027523,
      2.228308,
      NULL,
      51,
      NULL,
      13,
      1.297441,
      3,
      NULL,
      NULL,
      ' 2-22-1995',
      3.867783,
      0.153205,
      0,
      3,
      0,
      3.730612,
      2,
      0,
      0.175075,
      9.258409,
      NULL,
      4,
      2,
      NULL,
      4.766948,
      NULL,
      NULL,
      5,
      2,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1.950535,
      0,
      NULL,
      NULL,
      1.135009,
      4,
      0,
      1,
      NULL,
      3,
      0,
      4,
      0,
      0,
      NULL,
      1,
      1,
      4,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      0.755253,
      1.996817,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      2,
      3,
      0,
      1,
      3,
      1,
      NULL,
      1,
      5,
      1,
      1,
      1,
      1,
      1.465846,
      NULL,
      0,
      0,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      NULL,
      1,
      2,
      1,
      0,
      4,
      NULL,
      2,
      NULL,
      0,
      0,
      0.790337,
      ' 5-21-1976',
      NULL,
      ' 4- 4-1997',
      9,
      3.849824,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.247736,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1.526337,
      1.627958,
      1,
      0.835367,
      1.289837,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.075051,
      1.475532,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.945745,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.318410,
      0,
      NULL,
      NULL,
      1.387197,
      NULL,
      NULL,
      NULL,
      0,
      0.447447,
      2.429216,
      2,
      0,
      1,
      1,
      1,
      NULL,
      0,
      3,
      NULL,
      1,
      3,
      0,
      3,
      1,
      1,
      NULL,
      0,
      2.408773,
      0.856810,
      1.936959,
      0,
      1,
      0.154187,
      0,
      1.329550,
      1,
      0.309802,
      0.725387,
      NULL,
      7,
      9.956845,
      2,
      9.967729,
      8.434079,
      5.190139,
      NULL,
      0,
      5,
      2,
      3.830581,
      0.690363,
      41,
      0,
      0.039928,
      44,
      NULL,
      NULL,
      NULL,
      2,
      4,
      1.507261,
      NULL,
      '',
      '',
      0.374569,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '',
      NULL,
      15,
      163,
      61.233675,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.396043,
      2,
      0.668015,
      NULL,
      NULL,
      1.281119,
      NULL,
      NULL,
      0.222322,
      NULL,
      NULL,
      3.501965,
      NULL,
      2,
      0.074918,
      NULL,
      NULL,
      3.078817,
      2.844429,
      1,
      1.749216,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4.191942,
      NULL,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.265983,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.457237,
      NULL,
      NULL,
      0.768306,
      NULL,
      NULL,
      0.709631,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.716765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3.492223,
      0.776175,
      NULL,
      NULL,
      1,
      NULL,
      2,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.330165,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.918139,
      NULL,
      NULL,
      NULL,
      0.176852,
      0,
      1.911933,
      NULL,
      5.148916,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391437,
      1,
      NULL,
      0,
      3.032998,
      0.598536,
      NULL,
      NULL,
      NULL,
      5.526849,
      2,
      1.362562,
      3,
      0,
      3,
      1.789559,
      2.253544,
      0.979721,
      2.928919,
      1.634429,
      0,
      0.102473,
      NULL,
      NULL,
      4,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.626628,
      0.927832,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.025123,
      NULL,
      NULL,
      0.230035,
      NULL,
      NULL,
      1.317373,
      NULL,
      NULL,
      0.444741,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.819356,
      0.830867,
      0.860930,
      0,
      0,
      2.510972,
      NULL,
      NULL,
      NULL,
      0.864972,
      NULL,
      NULL,
      NULL,
      247.501602,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.459947,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.163889,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.178295,
      NULL,
      NULL,
      NULL,
      3.802800,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.978876,
      NULL,
      NULL,
      NULL,
      2.846001,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417448,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      88,
      2.739192,
      0.125503,
      NULL,
      NULL,
      0.839941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.661735,
      NULL,
      NULL,
      0.900153,
      NULL,
      NULL,
      0,
      1.902930,
      0.715394,
      1.262463,
      0,
      1.640122,
      0.408728,
      0,
      NULL,
      0,
      0,
      NULL,
      1.844894,
      1.417594,
      0,
      0.126545,
      1.345632,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      9,
      2,
      NULL,
      3,
      NULL,
      6.021748,
      NULL,
      0,
      1.566884,
      0.113560,
      0.533846,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0.822754,
      0,
      NULL,
      1.014576,
      1.103412,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1.552452,
      1.029823,
      NULL,
      0.664890,
      2,
      NULL,
      NULL,
      2.949724,
      NULL,
      2,
      1.319218,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193839,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      0,
      4,
      NULL,
      0,
      1,
      9,
      84,
      0,
      0.182254,
      0,
      '12013',
      '',
      '',
      1.266800,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


