set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9321577';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '10',
      '42',
      43,
      30,
      '3013443',
      2.638800,
      1,
      4,
      NULL,
      '4100',
      2,
      NULL,
      NULL,
      NULL,
      '10- 0-1975',
      104,
      13.227659,
      NULL,
      2,
      1.978260,
      ' 4-18-1993',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 5- 8-1998',
      ' 0-11-1993',
      NULL,
      0.745974,
      0,
      3,
      0.458663,
      0,
      3.328100,
      0,
      1,
      NULL,
      1,
      8,
      17,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.537653,
      1.890904,
      1.538283,
      4,
      0,
      1.365871,
      1.229059,
      2,
      1,
      1,
      0,
      5,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      3,
      1,
      0,
      0,
      1,
      1,
      1,
      2,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1,
      1,
      1,
      1,
      0,
      NULL,
      0,
      1,
      0,
      1,
      0.012248,
      NULL,
      NULL,
      0,
      1,
      1.126947,
      NULL,
      0.178480,
      NULL,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      2,
      5,
      0,
      4,
      3,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7.227643,
      NULL,
      1.673015,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.288287,
      0.843321,
      1,
      2,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.303229,
      0.131257,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.468706,
      1.391462,
      0,
      0,
      1.970331,
      1.874388,
      3.883772,
      0,
      0,
      1.835313,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      2.449382,
      3,
      0,
      1,
      3,
      3,
      1,
      1,
      NULL,
      0,
      1,
      0.180892,
      3.085764,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1,
      1,
      0.033788,
      NULL,
      1,
      1.556196,
      1.900877,
      0,
      0,
      1,
      2,
      0.713694,
      9,
      NULL,
      3,
      2.705561,
      NULL,
      1.484686,
      1.833353,
      3.811947,
      NULL,
      NULL,
      1,
      1,
      15,
      1,
      NULL,
      33,
      NULL,
      15,
      NULL,
      4,
      NULL,
      0,
      '40010',
      '21023',
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.944151,
      15,
      7.605367,
      31.534360,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.696013,
      1,
      1,
      1.665548,
      NULL,
      NULL,
      0.989764,
      NULL,
      NULL,
      0,
      3.250402,
      0.274447,
      3,
      1,
      3.617690,
      3,
      NULL,
      0.474218,
      0,
      1.507417,
      0.877190,
      NULL,
      NULL,
      NULL,
      1.794598,
      2.428423,
      NULL,
      3,
      NULL,
      0.812482,
      0,
      2,
      1.176473,
      3.537409,
      1,
      NULL,
      3.152725,
      3.831758,
      0.800411,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.948182,
      NULL,
      NULL,
      1.523400,
      NULL,
      NULL,
      1.656807,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.218801,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.004529,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      2,
      3,
      1,
      NULL,
      NULL,
      0.805691,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.967595,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.344881,
      NULL,
      NULL,
      1.712463,
      NULL,
      NULL,
      1.443738,
      NULL,
      NULL,
      1.107071,
      NULL,
      NULL,
      2,
      NULL,
      3,
      0.105000,
      2,
      0.518137,
      6,
      4.410990,
      NULL,
      NULL,
      0,
      3.365184,
      1,
      3,
      0.412525,
      2,
      0,
      1.990532,
      1,
      NULL,
      NULL,
      4,
      0,
      4.226872,
      NULL,
      NULL,
      NULL,
      0.380510,
      0,
      3,
      0,
      0.631563,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      1,
      1,
      NULL,
      0,
      0.698511,
      NULL,
      NULL,
      7,
      2.264021,
      NULL,
      NULL,
      2,
      13,
      NULL,
      NULL,
      3,
      0.625844,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.502127,
      1,
      NULL,
      NULL,
      1.697143,
      0,
      NULL,
      NULL,
      2,
      3.198937,
      NULL,
      NULL,
      3.614551,
      NULL,
      NULL,
      NULL,
      0.541309,
      0.078402,
      NULL,
      NULL,
      NULL,
      1.926173,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      2.291134,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.813547,
      0,
      1,
      13,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.960605,
      NULL,
      2,
      NULL,
      NULL,
      0.559069,
      1,
      NULL,
      1,
      3,
      0,
      1.860387,
      NULL,
      0,
      1,
      3.270401,
      NULL,
      1.400811,
      0,
      0.913426,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.692729,
      NULL,
      3.754847,
      NULL,
      NULL,
      NULL,
      3.614632,
      NULL,
      3,
      NULL,
      19.200756,
      NULL,
      0.855931,
      1.004006,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.332757,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.523069,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.739325,
      NULL,
      1.524796,
      NULL,
      0,
      1.636588,
      0.287223,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.321659,
      1,
      NULL,
      0.526776,
      NULL,
      2.831035,
      NULL,
      1,
      NULL,
      2.243616,
      NULL,
      0.420205,
      NULL,
      1,
      NULL,
      1.951406,
      NULL,
      2.407657,
      NULL,
      3,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1.637822,
      NULL,
      1,
      NULL,
      0.801149,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763886,
      1.707550,
      NULL,
      0.301323,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0.292100,
      0.273687,
      NULL,
      1.513613,
      NULL,
      103,
      NULL,
      0,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2,
      3,
      8,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      2,
      0,
      4.671143,
      1.703523,
      1.866072,
      1.357895,
      1,
      0,
      1,
      1,
      3,
      1,
      1.836763,
      1,
      NULL,
      NULL,
      3,
      0,
      2,
      3.720708,
      NULL,
      1.578808,
      NULL,
      0.122814,
      1.084202,
      0,
      1,
      1.783498,
      1.156694,
      1.431615,
      NULL,
      0.600916,
      0,
      1,
      1,
      0,
      1,
      0,
      1.367816,
      NULL,
      2.437092,
      0.020628,
      1,
      0,
      3.909462,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0.431141,
      1.882821,
      NULL,
      0.867621,
      4,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      19,
      99,
      NULL,
      0.590243,
      1,
      '34414',
      '42332',
      NULL,
      0,
      '',
      NULL,
      NULL,
      1,
      '02300',
      '',
      '');
commit;
end;
/


