set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710835';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-1-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '44',
      NULL,
      1.480018,
      31,
      '4002302',
      3,
      NULL,
      NULL,
      2,
      '4231',
      5,
      NULL,
      NULL,
      NULL,
      ' 9-24-1992',
      NULL,
      12,
      NULL,
      NULL,
      2.034267,
      ' 0-25-2000',
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      '10-21-1976',
      ' 7- 7-2002',
      ' 3-22-1998',
      2,
      2.578926,
      NULL,
      NULL,
      1,
      1.498105,
      2,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      3.018449,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      3.535987,
      1,
      NULL,
      NULL,
      0,
      5,
      NULL,
      5,
      2,
      1,
      0,
      0,
      0,
      9,
      NULL,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      0.099017,
      2.052813,
      0,
      1.917795,
      1,
      2.413555,
      3.825206,
      NULL,
      NULL,
      0,
      0,
      0,
      0.257403,
      1.062267,
      0,
      0.689590,
      1.245870,
      1,
      1,
      1,
      4,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0,
      1,
      2,
      1,
      0,
      1,
      3,
      0,
      1,
      NULL,
      1.555426,
      1,
      0,
      1,
      1,
      1,
      NULL,
      0.535721,
      1,
      0,
      4,
      2,
      NULL,
      1,
      2,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      5,
      NULL,
      2,
      ' 2-16-1989',
      NULL,
      ' 6-19-2002',
      129.543608,
      0.357694,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      2,
      3,
      1.055407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      40,
      2,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      1.765332,
      0.954991,
      0.170916,
      NULL,
      4,
      NULL,
      1.590663,
      3,
      NULL,
      1.204531,
      NULL,
      NULL,
      0.969500,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0.493676,
      1,
      1.993581,
      1.162762,
      1,
      NULL,
      17,
      3.884841,
      0.192017,
      NULL,
      NULL,
      NULL,
      0,
      0,
      3.360237,
      0,
      3,
      1,
      2,
      0,
      3,
      NULL,
      NULL,
      3,
      3,
      1,
      0.212239,
      2.170931,
      0,
      0.544603,
      1.843473,
      0,
      1.237990,
      NULL,
      1.422007,
      0,
      0.222291,
      0.960382,
      0,
      1,
      0,
      2.456718,
      3,
      1,
      8,
      5,
      NULL,
      11,
      8.103508,
      1.392975,
      4,
      0.520251,
      1,
      0,
      3,
      2,
      66,
      1,
      1.393910,
      37,
      NULL,
      5,
      13,
      3,
      NULL,
      0.991319,
      '34412',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      0.150874,
      44,
      31.066993,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.407332,
      0,
      0.164840,
      NULL,
      NULL,
      2.019256,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.669443,
      1.677060,
      NULL,
      1,
      NULL,
      NULL,
      0.832945,
      NULL,
      NULL,
      1.632150,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      2.979739,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.943307,
      0.897128,
      NULL,
      0.113308,
      0,
      2.536291,
      1,
      NULL,
      1.448811,
      1.738686,
      NULL,
      NULL,
      2,
      NULL,
      1.598266,
      0,
      2,
      2,
      0,
      0.785459,
      NULL,
      NULL,
      0.315104,
      NULL,
      NULL,
      2,
      3,
      NULL,
      0,
      0.180488,
      NULL,
      NULL,
      NULL,
      0.430488,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.938998,
      0.951399,
      1,
      1.094667,
      NULL,
      0,
      NULL,
      NULL,
      4.238163,
      5,
      NULL,
      1,
      NULL,
      NULL,
      1.874994,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.375417,
      NULL,
      NULL,
      1.664257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4.051994,
      NULL,
      3.730654,
      NULL,
      NULL,
      0.833244,
      0,
      4.978301,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2.708396,
      2.297716,
      NULL,
      0,
      4.333210,
      NULL,
      3,
      1.630657,
      1.175588,
      2.195550,
      1.458357,
      0,
      3,
      NULL,
      2,
      NULL,
      2.804360,
      NULL,
      3,
      NULL,
      3.629156,
      5,
      NULL,
      4.260401,
      3.745901,
      NULL,
      3,
      0.726617,
      NULL,
      0,
      NULL,
      NULL,
      0.224517,
      NULL,
      NULL,
      0.220889,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.569649,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.717951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.356270,
      NULL,
      NULL,
      NULL,
      1,
      1.837640,
      1.640592,
      NULL,
      3.974767,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      37,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.979900,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.995054,
      NULL,
      NULL,
      NULL,
      1.905611,
      NULL,
      NULL,
      NULL,
      3.330139,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.738948,
      NULL,
      NULL,
      NULL,
      5.062880,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      2.035077,
      3,
      1,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.877655,
      78,
      0.386926,
      1,
      0,
      1,
      0.744938,
      0.278112,
      1,
      0.038858,
      1.000223,
      0,
      NULL,
      0.947993,
      1,
      1,
      0,
      0.502204,
      1.281055,
      NULL,
      0.410614,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.489250,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4,
      3,
      6,
      6.131695,
      3.623312,
      NULL,
      3,
      NULL,
      1,
      2,
      0,
      0,
      0,
      NULL,
      0.120939,
      1,
      NULL,
      3.913078,
      1.018600,
      NULL,
      0,
      1,
      NULL,
      2.342320,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.621914,
      0.635512,
      NULL,
      NULL,
      0.270199,
      NULL,
      2.722135,
      2.980980,
      NULL,
      3.357407,
      2,
      NULL,
      1.675795,
      0,
      NULL,
      3.505237,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.340270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.433071,
      NULL,
      1.539117,
      NULL,
      2,
      6,
      6,
      NULL,
      NULL,
      NULL,
      89.779384,
      9,
      5,
      5,
      1,
      NULL,
      '',
      '',
      1.264647,
      '',
      '',
      '',
      0.494181,
      '',
      NULL,
      '');
commit;
end;
/


