set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6458228';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1988-10-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      '2044',
      2.985703,
      1,
      4.229675,
      1,
      '11- 2-1983',
      22,
      NULL,
      2,
      3.563624,
      NULL,
      ' 0-26-1991',
      38.803851,
      5.068489,
      43,
      49.931466,
      0,
      NULL,
      NULL,
      '11-24-1976',
      3,
      1.718742,
      3,
      0,
      1,
      0,
      2,
      0.403766,
      1.771961,
      346,
      1,
      10.712508,
      2,
      12,
      23,
      NULL,
      13.575674,
      0,
      NULL,
      11.743483,
      1,
      1,
      NULL,
      NULL,
      1,
      0.758869,
      1.162714,
      0,
      NULL,
      2,
      1,
      3,
      2,
      6,
      1.697734,
      0,
      1,
      1,
      NULL,
      3,
      1,
      0,
      1,
      1,
      0,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      0.040404,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      3.497142,
      NULL,
      NULL,
      1.583110,
      3.213727,
      NULL,
      0.879164,
      0.298332,
      1,
      1,
      1,
      1,
      0,
      1,
      8.878922,
      0,
      NULL,
      0.672256,
      NULL,
      NULL,
      NULL,
      1.325059,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      1,
      1.505303,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      4,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      5,
      2,
      0,
      1,
      0,
      NULL,
      3,
      3,
      1,
      0,
      1,
      2,
      3,
      5,
      4,
      0,
      2,
      NULL,
      NULL,
      ' 5-29-1976',
      NULL,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      5,
      1,
      1,
      NULL,
      1,
      1.150949,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.450465,
      1,
      2.530752,
      2,
      9,
      3.780857,
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      7.371276,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.156266,
      2.208213,
      0,
      0,
      2,
      1,
      1,
      1.908273,
      NULL,
      NULL,
      1.528098,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.289013,
      0,
      0,
      1,
      3,
      NULL,
      0,
      2,
      3,
      1,
      1,
      NULL,
      3.540388,
      2,
      2.659285,
      1.002139,
      0.960879,
      0,
      1.624429,
      NULL,
      NULL,
      1.479975,
      0,
      0,
      1,
      0,
      1,
      0.101160,
      2.181258,
      1.377263,
      5,
      1,
      6,
      3,
      1,
      2.735301,
      2,
      1.295182,
      1.240380,
      3,
      3.494544,
      NULL,
      14.872256,
      1,
      1.688677,
      65,
      NULL,
      NULL,
      NULL,
      4,
      0.221959,
      1.860977,
      '32134',
      '',
      '',
      1,
      NULL,
      '',
      NULL,
      1,
      '',
      '',
      '',
      0.115750,
      26,
      244,
      15.674802,
      0,
      NULL,
      NULL,
      75.905735,
      1,
      2,
      4,
      1,
      11.635759,
      NULL,
      NULL,
      2.545289,
      6,
      1.685548,
      NULL,
      1.892187,
      NULL,
      0,
      16,
      0.073651,
      18.919420,
      NULL,
      NULL,
      3.471839,
      2,
      0.381374,
      16,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      8,
      0.731970,
      5.696697,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      12,
      0,
      18,
      3.976188,
      0,
      1.853168,
      NULL,
      1,
      2.219459,
      NULL,
      NULL,
      NULL,
      3.759764,
      1,
      0.172429,
      2.782423,
      2.670432,
      3.133827,
      NULL,
      1.139237,
      1,
      1.855921,
      NULL,
      NULL,
      2,
      0,
      1,
      1.443423,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.898393,
      NULL,
      NULL,
      7,
      1.624370,
      4,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      18,
      0,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      0,
      18,
      4,
      1.841222,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.381171,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.405089,
      NULL,
      NULL,
      NULL,
      0.167141,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      0,
      4.681936,
      NULL,
      NULL,
      NULL,
      3,
      7.312622,
      0,
      NULL,
      0.262012,
      3.701102,
      NULL,
      17.028349,
      0,
      NULL,
      6,
      8,
      2,
      2.467519,
      2.093579,
      2,
      NULL,
      1.717180,
      0.364737,
      NULL,
      NULL,
      3.826940,
      1.298474,
      1.882403,
      3,
      2,
      1,
      2,
      7.860621,
      1,
      NULL,
      3,
      4,
      NULL,
      NULL,
      2,
      0.735213,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.755034,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.814046,
      NULL,
      NULL,
      13.965299,
      NULL,
      NULL,
      1.717764,
      NULL,
      NULL,
      0.110844,
      NULL,
      NULL,
      0.258323,
      NULL,
      NULL,
      1.346082,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      3,
      0.181129,
      1.429941,
      1.766394,
      0.121770,
      0,
      0.493929,
      NULL,
      6.810934,
      3,
      4.289211,
      NULL,
      2,
      NULL,
      25,
      NULL,
      2,
      NULL,
      0.992744,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3.576234,
      1,
      1.518994,
      NULL,
      1.225018,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1.372502,
      NULL,
      3.157062,
      NULL,
      5,
      0.511547,
      NULL,
      NULL,
      17,
      16,
      NULL,
      NULL,
      8,
      14.975122,
      16.447911,
      NULL,
      0,
      17,
      NULL,
      NULL,
      NULL,
      1.473900,
      3.898040,
      NULL,
      1,
      0.968994,
      0.370725,
      NULL,
      0.705405,
      1,
      1.871353,
      NULL,
      2,
      1,
      1.698671,
      NULL,
      NULL,
      1.448945,
      1.507626,
      NULL,
      3.043890,
      1,
      1,
      NULL,
      2.332564,
      2.848251,
      0,
      NULL,
      4,
      4,
      8,
      NULL,
      133,
      3,
      3,
      6,
      3,
      1,
      84,
      101,
      0.661291,
      303,
      45.444517,
      0.394730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.857460,
      0,
      1.332855,
      0,
      NULL,
      NULL,
      0,
      535.315899,
      1.764647,
      17837.209432,
      NULL,
      1,
      1.969319,
      NULL,
      NULL,
      1,
      NULL,
      1.018951,
      0,
      1,
      NULL,
      0.201283,
      1,
      1.742205,
      2.776308,
      0.233914,
      0.673675,
      NULL,
      2,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.504545,
      NULL,
      1.329419,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      6.424225,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      2.300980,
      1.112886,
      0,
      NULL,
      NULL,
      1,
      1.784960,
      NULL,
      0,
      2,
      3.280107,
      NULL,
      1,
      3,
      1,
      1,
      1,
      NULL,
      0.453519,
      1,
      NULL,
      0.483815,
      1,
      1,
      0.243337,
      0,
      1,
      1,
      0,
      0,
      2.585732,
      0,
      NULL,
      0.353403,
      1.207761,
      3.253289,
      1.505215,
      1.000723,
      0,
      2.540485,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.337382,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.881505,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.039345,
      NULL,
      0.234570,
      NULL,
      0.063430,
      44.650953,
      1,
      NULL,
      3,
      1.608763,
      3,
      NULL,
      0.805363,
      NULL,
      0,
      NULL,
      1.071724,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.345374,
      NULL,
      1,
      NULL,
      0.308688,
      NULL,
      1,
      NULL,
      0.558843,
      NULL,
      NULL,
      NULL,
      2.996612,
      NULL,
      1,
      NULL,
      NULL,
      1.305871,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.223328,
      0,
      NULL,
      54,
      53.946496,
      0,
      0,
      1,
      NULL,
      '',
      '',
      0.961744,
      '',
      NULL,
      '',
      0.188566,
      '03001',
      NULL,
      NULL);
commit;
end;
/


