set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9621804';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-11-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '33',
      NULL,
      26,
      '3243140',
      2,
      1.197664,
      0,
      2,
      '3104',
      0.588780,
      0.130160,
      NULL,
      NULL,
      '11-11-1977',
      135,
      9,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7- 0-1982',
      NULL,
      NULL,
      2.212370,
      NULL,
      2.335320,
      NULL,
      0,
      1.808394,
      NULL,
      NULL,
      0,
      NULL,
      8,
      17,
      15,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0.058648,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1,
      1.554190,
      0,
      0,
      1,
      5,
      2,
      1,
      1,
      4,
      4,
      1,
      NULL,
      0,
      6.522349,
      0,
      2,
      1,
      1,
      0,
      NULL,
      NULL,
      1.401559,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.813198,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      0,
      7,
      1,
      1,
      2,
      1.645657,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      0,
      0,
      NULL,
      0,
      1,
      1,
      3.700825,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.490840,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      1,
      4,
      NULL,
      NULL,
      3,
      0,
      3,
      1,
      0,
      1,
      4,
      4,
      1,
      0,
      NULL,
      0,
      ' 7- 7-1990',
      85.106312,
      ' 5- 9-1995',
      62,
      2.042132,
      2,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.287941,
      5.280140,
      3.149723,
      1,
      NULL,
      2,
      4,
      NULL,
      NULL,
      NULL,
      0.652041,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1.060667,
      0,
      1.672895,
      1.494203,
      1.939806,
      2.013671,
      19,
      3.796418,
      0.449653,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.569031,
      0,
      2,
      1,
      0,
      2,
      NULL,
      NULL,
      1,
      3,
      0,
      1.348198,
      3.594091,
      NULL,
      1.135271,
      NULL,
      0.258457,
      1,
      0,
      1.163532,
      0.166115,
      1,
      1,
      0,
      0.080420,
      0,
      1,
      0,
      0,
      1,
      9,
      6,
      NULL,
      9,
      11,
      7,
      1.654916,
      3,
      7,
      2.670867,
      1,
      1.085899,
      15,
      NULL,
      0.167706,
      73,
      NULL,
      81,
      41,
      NULL,
      3,
      5,
      NULL,
      '01000',
      '',
      0.630658,
      '1130',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3,
      39,
      10.032444,
      1.670711,
      NULL,
      29,
      0,
      1.374412,
      NULL,
      3.749533,
      3,
      1,
      0,
      NULL,
      NULL,
      3.292550,
      0,
      3.781875,
      1.372007,
      2,
      0,
      NULL,
      2.997554,
      1,
      0.192957,
      NULL,
      NULL,
      0.870526,
      1.037416,
      NULL,
      1.117221,
      2.342861,
      0.150221,
      3,
      NULL,
      0,
      1.528464,
      NULL,
      NULL,
      3.573164,
      0.562339,
      2,
      0.744306,
      NULL,
      NULL,
      6.886359,
      2,
      0.007404,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.025244,
      3.156883,
      NULL,
      3,
      0.262796,
      NULL,
      3.459610,
      3.489612,
      0,
      1.291032,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1.935214,
      1,
      3,
      NULL,
      1,
      1.182268,
      3.162435,
      0.363792,
      2.075165,
      3.442582,
      3.030237,
      NULL,
      0.620310,
      NULL,
      NULL,
      1.505665,
      1.245687,
      NULL,
      0.537728,
      7.542820,
      0.411464,
      1,
      0.617326,
      NULL,
      NULL,
      NULL,
      0.039923,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.017175,
      3.226541,
      NULL,
      3,
      1.850866,
      1.128006,
      NULL,
      NULL,
      NULL,
      5,
      2,
      1.933927,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.495900,
      NULL,
      NULL,
      1.212229,
      NULL,
      NULL,
      0.640200,
      NULL,
      NULL,
      0.691676,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.081788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.035690,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.132868,
      1.784006,
      1.078469,
      1.240291,
      NULL,
      NULL,
      0.082258,
      3.129081,
      1.960095,
      3.232342,
      2,
      2.845130,
      1.217509,
      NULL,
      NULL,
      7.904098,
      6.786388,
      0.684273,
      1,
      NULL,
      NULL,
      2,
      1,
      1,
      2,
      3,
      2,
      0.838305,
      3,
      2.143468,
      NULL,
      4.408332,
      3,
      1.190718,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.050737,
      NULL,
      1.431737,
      0.921294,
      1,
      0.663237,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      2.058481,
      1.380324,
      NULL,
      NULL,
      1.529077,
      NULL,
      NULL,
      NULL,
      50,
      NULL,
      NULL,
      NULL,
      1.052959,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.103513,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.938742,
      NULL,
      NULL,
      NULL,
      3.144244,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.895973,
      NULL,
      NULL,
      NULL,
      0.315027,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      2.794940,
      0,
      2,
      NULL,
      1,
      1.648648,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.606939,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.195289,
      0.249949,
      NULL,
      0.539244,
      0.115695,
      0,
      0.225877,
      1,
      1.616336,
      NULL,
      0,
      1,
      1.993411,
      0.249414,
      1.209567,
      1,
      1,
      0.939863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.038753,
      0,
      0.263197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.543760,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.250213,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.205900,
      1.061907,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.619520,
      1,
      3.951279,
      NULL,
      2.170839,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.190449,
      3.476428,
      NULL,
      2.602507,
      NULL,
      NULL,
      NULL,
      3.540529,
      NULL,
      3,
      NULL,
      2.600375,
      NULL,
      3.464055,
      1.345467,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      3,
      3.307979,
      0.693019,
      1,
      1,
      6.758844,
      2,
      NULL,
      0.661042,
      0,
      0.869501,
      NULL,
      1,
      0.409944,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.984035,
      NULL,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.250402,
      NULL,
      1,
      1.743058,
      NULL,
      3,
      1,
      0.059262,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999604,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.508661,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      5,
      0.017141,
      NULL,
      NULL,
      59,
      51.498458,
      2,
      0,
      1.566706,
      '30123',
      NULL,
      '4213',
      3,
      '2111',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


