set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9018757';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-09 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      NULL,
      0.618912,
      3,
      3,
      '4131',
      1,
      0,
      NULL,
      NULL,
      NULL,
      15,
      NULL,
      NULL,
      2,
      0,
      ' 0-14-1993',
      6.024962,
      NULL,
      177,
      144,
      1,
      ' 4-14-1976',
      ' 2-14-1975',
      ' 6-29-1996',
      NULL,
      NULL,
      NULL,
      0.710971,
      0,
      0,
      1,
      1.064125,
      NULL,
      2,
      0,
      0.531447,
      2,
      10.793260,
      NULL,
      0,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      2,
      5,
      NULL,
      0,
      2,
      2,
      1,
      4,
      1,
      3,
      NULL,
      0,
      1,
      3.101404,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0.876750,
      1.280458,
      NULL,
      3,
      3.817700,
      0.662302,
      0.175134,
      1,
      0,
      2.416673,
      NULL,
      0,
      3.050434,
      0,
      3,
      3.139071,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.848357,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1.004406,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      0,
      1,
      3,
      0,
      0,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      4,
      NULL,
      3,
      3,
      0,
      0,
      2,
      4,
      3,
      5,
      2.901703,
      NULL,
      ' 4-29-1995',
      64,
      ' 9-16-1987',
      4,
      1.081137,
      0,
      NULL,
      3,
      3,
      2,
      NULL,
      0,
      1,
      0,
      0,
      0,
      2,
      0,
      3,
      1,
      3,
      1,
      2.564002,
      0.987442,
      1.361843,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.942451,
      0.788030,
      3,
      1.742718,
      5,
      1,
      1,
      1,
      1.543785,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.509610,
      NULL,
      0.263144,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.634390,
      1.091454,
      3.069681,
      3.186047,
      0.907142,
      1,
      0.642493,
      20.999423,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2,
      2,
      0,
      2,
      2,
      2,
      3,
      NULL,
      3,
      2,
      4.282107,
      NULL,
      5.385331,
      NULL,
      0.762707,
      0,
      5,
      1.712076,
      NULL,
      0.196530,
      0,
      1.050937,
      0.116982,
      0.849296,
      0.461218,
      0,
      NULL,
      NULL,
      0.155708,
      5,
      3,
      4,
      1.107388,
      1,
      1,
      5.339715,
      2,
      0,
      3.573088,
      2.453045,
      1.218411,
      46,
      0,
      3,
      NULL,
      55,
      10,
      NULL,
      5,
      1.699823,
      NULL,
      '40101',
      NULL,
      '',
      1,
      '',
      NULL,
      '',
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      61,
      41.561003,
      3.416207,
      26.230814,
      NULL,
      5.756340,
      NULL,
      1,
      3.891875,
      0.691199,
      1,
      NULL,
      NULL,
      1.438088,
      NULL,
      NULL,
      NULL,
      2.675426,
      0.815773,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.577038,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2.065534,
      0,
      1,
      1,
      NULL,
      NULL,
      0.573644,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.889749,
      8.097800,
      1.690776,
      0,
      0.214528,
      0,
      1.550246,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1.564097,
      0,
      0.187442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.227292,
      3.647831,
      3.918815,
      3.457737,
      3,
      0.668798,
      1,
      3,
      NULL,
      1,
      2.860166,
      NULL,
      2,
      3,
      1,
      NULL,
      NULL,
      0.704616,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.376501,
      1.673737,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.034591,
      NULL,
      NULL,
      NULL,
      0.355288,
      NULL,
      NULL,
      1.311109,
      1.672839,
      1,
      1,
      0.345959,
      1,
      0.747328,
      NULL,
      NULL,
      2.432164,
      1,
      1,
      1,
      3,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      0.106686,
      1.428979,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.780330,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.481257,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.647941,
      NULL,
      NULL,
      4,
      0,
      0,
      5.724631,
      0.699523,
      NULL,
      2,
      0.208249,
      NULL,
      3.271377,
      3,
      1,
      1,
      NULL,
      NULL,
      1,
      2.398947,
      5.758689,
      NULL,
      NULL,
      NULL,
      1.667279,
      NULL,
      NULL,
      2.608394,
      1,
      NULL,
      0.684705,
      2,
      2.413091,
      NULL,
      2.266963,
      0.974329,
      0.340301,
      0.246953,
      1.867711,
      3.459091,
      2,
      1,
      2,
      NULL,
      1.758907,
      1.834941,
      1,
      3.883277,
      NULL,
      5,
      1.378788,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.029839,
      NULL,
      2,
      1,
      NULL,
      1,
      0,
      NULL,
      0.109944,
      1.421276,
      NULL,
      1,
      0.663210,
      NULL,
      1,
      0,
      NULL,
      8.405011,
      3,
      NULL,
      4,
      0,
      1.604389,
      1.088885,
      0,
      0,
      3,
      3.132698,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.021198,
      1.266885,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.961638,
      NULL,
      NULL,
      1.820212,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.688177,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.881739,
      1.419533,
      NULL,
      NULL,
      3,
      1,
      NULL,
      NULL,
      1.936827,
      NULL,
      NULL,
      NULL,
      0.465420,
      0.306298,
      NULL,
      NULL,
      2,
      0.046485,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      10.544161,
      0,
      NULL,
      NULL,
      NULL,
      1.351398,
      1,
      0,
      NULL,
      NULL,
      11,
      3,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      2,
      2,
      1,
      86,
      11,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      311,
      0,
      NULL,
      0.606804,
      1.581070,
      1,
      1,
      NULL,
      0.746221,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      1.011641,
      1,
      NULL,
      1,
      0,
      NULL,
      3.049521,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.149097,
      29,
      NULL,
      0.086689,
      1.395068,
      NULL,
      NULL,
      1.606114,
      NULL,
      0.101734,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.503533,
      NULL,
      0,
      NULL,
      1.677725,
      NULL,
      1,
      NULL,
      0.713675,
      NULL,
      1.561392,
      NULL,
      1.673575,
      NULL,
      1.112788,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.164135,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.184874,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.643909,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.646071,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.821289,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.933046,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.293920,
      1,
      0,
      1,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      3,
      3.965108,
      NULL,
      2,
      7,
      1,
      2.540909,
      3,
      0.091898,
      0,
      1,
      1.961408,
      0,
      1.089359,
      0,
      2.710917,
      NULL,
      0,
      0.110988,
      1.102422,
      2,
      1.251638,
      2,
      0.044980,
      0,
      NULL,
      2.072435,
      3.649364,
      2,
      1,
      0,
      0.788849,
      1,
      NULL,
      1,
      NULL,
      0,
      3.563668,
      1,
      NULL,
      0,
      NULL,
      1.492549,
      0.403944,
      0,
      NULL,
      NULL,
      0.528873,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.937164,
      NULL,
      0.524085,
      NULL,
      0,
      NULL,
      1.558979,
      30.241777,
      0,
      NULL,
      1.403356,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.320077,
      1,
      1.750612,
      0,
      1,
      5,
      0,
      0,
      NULL,
      NULL,
      28,
      3.511173,
      NULL,
      NULL,
      2.226389,
      '04312',
      NULL,
      '',
      0,
      '',
      '',
      NULL,
      0.120058,
      '',
      '',
      '');
commit;
end;
/


