set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9825488';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-11-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0.629481,
      0,
      0.064810,
      0.353933,
      1,
      0.208497,
      3.961969,
      0.238593,
      '041',
      '02223402',
      NULL,
      NULL,
      '3123102',
      1,
      NULL,
      4,
      0,
      '3003',
      3.947950,
      1.343103,
      NULL,
      NULL,
      NULL,
      90,
      42,
      NULL,
      2,
      0.665715,
      ' 7-16-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 9- 8-1980',
      ' 0-14-1998',
      ' 0-27-1995',
      1.521180,
      1,
      NULL,
      2.540919,
      3,
      2,
      NULL,
      1,
      NULL,
      80.410950,
      NULL,
      6.151746,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.038338,
      0,
      1,
      NULL,
      0,
      0.341142,
      1.725612,
      1,
      0,
      1,
      1,
      2,
      5,
      1,
      3.893090,
      NULL,
      NULL,
      1,
      2,
      0,
      4,
      0,
      0,
      4,
      4,
      1,
      NULL,
      7.575445,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.672046,
      1,
      1.337396,
      3.603567,
      1.116554,
      1.460746,
      0.752429,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      2.989488,
      2.190550,
      5,
      0,
      5,
      6.520179,
      0,
      0,
      2.077082,
      0,
      NULL,
      NULL,
      1.117894,
      NULL,
      NULL,
      0,
      1,
      3,
      0,
      0,
      2,
      0,
      0,
      0,
      NULL,
      5,
      0,
      1,
      2.509390,
      0,
      1,
      0,
      NULL,
      0.708734,
      1.062482,
      NULL,
      1,
      1,
      1,
      0,
      5,
      1,
      5,
      0,
      0,
      5,
      NULL,
      1,
      3,
      1,
      NULL,
      5,
      4,
      3,
      1,
      5,
      5,
      5,
      2,
      NULL,
      NULL,
      3,
      0,
      ' 6-12-2003',
      248,
      ' 5-13-1992',
      726,
      3,
      0,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      0,
      5,
      0,
      0.020336,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      24.868788,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.974634,
      3,
      1.043974,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.082796,
      0,
      0.238579,
      NULL,
      NULL,
      4.816229,
      0,
      NULL,
      NULL,
      NULL,
      1.739422,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      1.337808,
      1,
      1.099735,
      0,
      0.097285,
      66.364566,
      0,
      2.787567,
      0.228604,
      40.787144,
      NULL,
      3,
      0.827007,
      3,
      3,
      3,
      0,
      3,
      0,
      2,
      0,
      0,
      NULL,
      3,
      3,
      0.044155,
      3,
      1,
      1,
      1,
      NULL,
      0.387852,
      1,
      1,
      1,
      0.800692,
      0,
      NULL,
      0,
      0,
      NULL,
      1.517019,
      NULL,
      1,
      NULL,
      4,
      11,
      4,
      NULL,
      0,
      1.638911,
      6.345585,
      1.614370,
      3.815785,
      1,
      60.734090,
      3,
      2,
      16,
      NULL,
      24,
      10,
      5,
      1,
      0,
      '43032',
      '',
      '',
      1.609296,
      '',
      '',
      NULL,
      NULL,
      '4024',
      NULL,
      '',
      1.411314,
      NULL,
      219,
      27,
      NULL,
      5,
      1,
      NULL,
      NULL,
      1,
      1.538554,
      0.492916,
      1.837490,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.960005,
      1,
      0.427864,
      NULL,
      NULL,
      0,
      0.143819,
      1,
      NULL,
      NULL,
      3.921130,
      2.299701,
      1.374049,
      2,
      0,
      1,
      3,
      NULL,
      0,
      3.601751,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.488783,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.773284,
      NULL,
      NULL,
      NULL,
      2.675905,
      1,
      1.965703,
      0,
      NULL,
      NULL,
      2.768591,
      NULL,
      0.375396,
      0.865681,
      1.479337,
      0,
      NULL,
      NULL,
      0.062161,
      NULL,
      1,
      0.966579,
      2,
      0,
      NULL,
      0.209640,
      0,
      NULL,
      3,
      3.760497,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.772166,
      0.861840,
      1,
      0.897860,
      3.883791,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.982360,
      NULL,
      NULL,
      NULL,
      0.989504,
      NULL,
      NULL,
      NULL,
      3.451274,
      3,
      3,
      0.748609,
      2.940013,
      0,
      NULL,
      NULL,
      8,
      0.485989,
      2.273251,
      NULL,
      0.175627,
      0,
      0,
      1.296702,
      1.124237,
      2,
      1.679964,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.415850,
      NULL,
      NULL,
      1.168029,
      NULL,
      NULL,
      1.176380,
      1,
      1.743092,
      8.401999,
      3,
      9.841805,
      2.944786,
      1,
      3.931806,
      1.238839,
      1,
      1.027645,
      NULL,
      NULL,
      3,
      1,
      0.341212,
      5.650843,
      NULL,
      NULL,
      NULL,
      1,
      0.717159,
      3.613600,
      3,
      0,
      3,
      0,
      1,
      0,
      NULL,
      NULL,
      5.375446,
      0.763989,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0.922569,
      3.652477,
      NULL,
      1,
      2,
      2,
      5,
      4.615569,
      NULL,
      6.709961,
      6,
      4.112537,
      NULL,
      NULL,
      NULL,
      0.135530,
      1.866707,
      NULL,
      1.277593,
      0,
      0.956909,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.704606,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.805211,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.653235,
      NULL,
      NULL,
      1.018608,
      0,
      1,
      1.859923,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.638650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.044414,
      NULL,
      NULL,
      NULL,
      0.287597,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.196329,
      NULL,
      NULL,
      NULL,
      1.552585,
      NULL,
      NULL,
      NULL,
      0.407880,
      141.714997,
      12.049762,
      1.129659,
      NULL,
      NULL,
      1.155564,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      24,
      43.534415,
      1.479859,
      NULL,
      NULL,
      1,
      NULL,
      0.746493,
      73.876761,
      0.355432,
      0,
      1,
      1,
      1.446747,
      0,
      0,
      1,
      1,
      1.049762,
      0.956844,
      1,
      0.504014,
      1,
      1.648541,
      0.211763,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.675309,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      6,
      2.945500,
      0,
      6.505599,
      2.599585,
      NULL,
      0.619441,
      NULL,
      2,
      NULL,
      1.684601,
      0.001052,
      NULL,
      1,
      0.025879,
      NULL,
      0.151477,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.524343,
      NULL,
      NULL,
      0.474920,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      2,
      0.061636,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.563830,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6,
      7,
      NULL,
      1.176443,
      3.837341,
      NULL,
      24.153508,
      4,
      NULL,
      3,
      '21210',
      '',
      NULL,
      0.931954,
      '',
      '',
      '',
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


