set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7732277';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-2-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      2.771381,
      1,
      5.396327,
      0.578104,
      1,
      1.095605,
      '130',
      NULL,
      41.431286,
      38.704084,
      '2404143',
      0.219369,
      0,
      NULL,
      1,
      '1104',
      3,
      1.688078,
      NULL,
      NULL,
      ' 1-14-1975',
      178,
      81,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      '11- 5-1988',
      ' 2- 1-1985',
      1.442759,
      3,
      1,
      0,
      1.898659,
      0,
      2,
      1.594256,
      NULL,
      NULL,
      NULL,
      8.660792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.654301,
      0,
      NULL,
      1,
      1,
      0,
      0.789649,
      1,
      1.442396,
      1.966279,
      0,
      2,
      3,
      3,
      0.688530,
      2,
      0,
      0,
      1,
      0,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      1,
      9,
      0,
      1,
      0,
      1,
      0.258853,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.560537,
      0.224128,
      0.916087,
      0.182017,
      0,
      1.582754,
      NULL,
      1,
      1.464061,
      2.496086,
      1,
      0,
      0,
      3.955858,
      0,
      3,
      0,
      1,
      3,
      8.327940,
      1,
      0,
      0,
      1.107669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      4,
      0,
      3,
      4,
      NULL,
      0,
      0,
      1,
      1,
      0,
      1,
      4,
      0,
      0,
      1,
      0,
      0.616255,
      NULL,
      NULL,
      0,
      0,
      4,
      3,
      NULL,
      0,
      NULL,
      0,
      5,
      1,
      1,
      5,
      4,
      1,
      NULL,
      1,
      3,
      0,
      1,
      0,
      4,
      4,
      0,
      4,
      3,
      NULL,
      1,
      ' 2- 9-2000',
      46,
      ' 2-18-1988',
      669,
      3.739590,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      2,
      0.798440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.978353,
      NULL,
      3.001283,
      3.325463,
      NULL,
      0,
      0,
      1.714577,
      0.420933,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.022116,
      2.673036,
      7,
      3,
      0,
      1.176883,
      NULL,
      2.189209,
      NULL,
      1,
      2,
      1.480596,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.152133,
      1.248077,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1.141129,
      0.033439,
      NULL,
      NULL,
      NULL,
      NULL,
      0.909779,
      1.629855,
      1,
      0,
      0,
      0,
      0,
      1,
      NULL,
      3,
      0,
      0,
      3,
      NULL,
      1,
      1,
      0.228483,
      NULL,
      1.674607,
      NULL,
      0,
      1,
      NULL,
      1.057921,
      1,
      0.903368,
      1,
      1,
      1.965739,
      1,
      1,
      11.696259,
      NULL,
      4.929124,
      NULL,
      4.391101,
      5,
      0.382115,
      1.447183,
      4,
      0.491172,
      2,
      0.005341,
      2,
      1,
      1,
      37,
      NULL,
      51,
      16.930670,
      NULL,
      3.937690,
      NULL,
      '40322',
      '',
      '',
      1.643314,
      '',
      '',
      '',
      1.409949,
      '3334',
      '',
      NULL,
      0.109340,
      0.789922,
      NULL,
      26,
      1,
      36.196541,
      6,
      0,
      NULL,
      NULL,
      1.129313,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.329144,
      0.184554,
      NULL,
      NULL,
      3.934691,
      1.991905,
      1.111738,
      NULL,
      0,
      NULL,
      0.496214,
      0.608822,
      0.043244,
      0.273679,
      NULL,
      0.074355,
      3,
      1.702922,
      1.626247,
      2,
      1.958329,
      1,
      0,
      NULL,
      1.997292,
      NULL,
      0.388653,
      6,
      3,
      0.909225,
      NULL,
      NULL,
      NULL,
      0.899812,
      NULL,
      NULL,
      NULL,
      3,
      1.958848,
      2.844211,
      NULL,
      0,
      NULL,
      1,
      NULL,
      2,
      NULL,
      0.080907,
      1.899504,
      2.058442,
      NULL,
      0,
      NULL,
      NULL,
      1.330619,
      0.764042,
      0,
      NULL,
      0,
      2.068137,
      0,
      0.416938,
      1,
      NULL,
      NULL,
      1.024851,
      NULL,
      NULL,
      NULL,
      0.418309,
      1,
      0,
      NULL,
      4,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.313651,
      0,
      0,
      0,
      NULL,
      NULL,
      3.330763,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      6.460582,
      NULL,
      1,
      1,
      1.971405,
      1.256980,
      3,
      1.866182,
      0,
      6,
      1.772543,
      NULL,
      0,
      NULL,
      NULL,
      0.302533,
      NULL,
      NULL,
      0.269524,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.820179,
      NULL,
      2.862107,
      1.874865,
      5.977584,
      NULL,
      5,
      3,
      1.455628,
      3.856394,
      0.027120,
      NULL,
      NULL,
      2.356627,
      NULL,
      1,
      0,
      0,
      3,
      2,
      3.215612,
      0.197874,
      1.559532,
      6,
      1.194489,
      0.806985,
      NULL,
      2,
      3,
      NULL,
      3,
      1.814085,
      NULL,
      2,
      2.726318,
      0.939166,
      NULL,
      NULL,
      4.213678,
      7,
      3.846881,
      5.635817,
      5.084883,
      0.458390,
      2,
      2,
      NULL,
      NULL,
      1,
      0,
      1.404701,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.974047,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.494624,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      5.037200,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.432723,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.451786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.881132,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.336447,
      NULL,
      NULL,
      NULL,
      2.384148,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.581847,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      6,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      3,
      0.622306,
      101,
      13.469087,
      NULL,
      0,
      2,
      0.419519,
      NULL,
      NULL,
      1,
      24,
      7.813970,
      NULL,
      NULL,
      NULL,
      1.011619,
      NULL,
      NULL,
      1.601854,
      NULL,
      0,
      65,
      NULL,
      0.031953,
      NULL,
      1.696072,
      NULL,
      NULL,
      NULL,
      2.603719,
      2.425658,
      0,
      1,
      0.722521,
      0.398902,
      0,
      1,
      NULL,
      0.137447,
      2.666334,
      1.127678,
      NULL,
      NULL,
      1.633983,
      NULL,
      1.731313,
      0,
      1,
      1,
      0,
      0,
      NULL,
      9,
      0,
      3.321942,
      27,
      28,
      2.659239,
      NULL,
      8.963856,
      1,
      0,
      1.243229,
      0,
      NULL,
      0,
      0.381318,
      1.669642,
      1.199936,
      0.340169,
      NULL,
      NULL,
      1,
      NULL,
      0.693544,
      0.062542,
      1.823369,
      0,
      1.880197,
      NULL,
      1.933416,
      1.907670,
      0,
      1,
      1.224538,
      0.660301,
      NULL,
      NULL,
      3,
      1.344973,
      0.492008,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.228435,
      1.727599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.902232,
      1.193596,
      3.146475,
      NULL,
      3.892336,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.861653,
      NULL,
      0,
      NULL,
      1.979973,
      1.609121,
      3.009700,
      NULL,
      1,
      NULL,
      1.756675,
      NULL,
      NULL,
      NULL,
      0.825736,
      NULL,
      NULL,
      NULL,
      1.590083,
      NULL,
      0.406860,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1,
      0,
      3.645700,
      0,
      1.125921,
      NULL,
      338.191320,
      0,
      NULL,
      0.829682,
      0,
      NULL,
      1,
      NULL,
      1.668390,
      11,
      10,
      2.535130,
      3,
      3.757781,
      2.024477,
      NULL,
      NULL,
      3,
      2,
      2.073244,
      3,
      2,
      2,
      5,
      0,
      0.821896,
      0,
      NULL,
      0.847339,
      NULL,
      NULL,
      NULL,
      NULL,
      1.638514,
      2,
      NULL,
      NULL,
      0.749185,
      NULL,
      0.208936,
      0,
      NULL,
      0,
      1,
      NULL,
      3,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.780197,
      1,
      NULL,
      0.093400,
      3,
      NULL,
      3,
      1.499893,
      1.846126,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.305906,
      NULL,
      0,
      NULL,
      1.091984,
      NULL,
      4,
      NULL,
      0,
      0,
      NULL,
      NULL,
      23.585675,
      NULL,
      NULL,
      0,
      0.163399,
      '33100',
      '2102',
      '10330',
      NULL,
      '',
      '',
      '',
      1,
      '32000',
      NULL,
      '1413');
commit;
end;
/


