set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9022953';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-8-01 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '0',
      NULL,
      NULL,
      '2410222',
      0,
      1.485652,
      2,
      3,
      '2022',
      0.535179,
      0.312303,
      NULL,
      NULL,
      ' 4-24-1991',
      85.675717,
      NULL,
      2,
      NULL,
      NULL,
      '10-26-1993',
      102.927506,
      3,
      125,
      NULL,
      3,
      ' 7-21-1975',
      NULL,
      NULL,
      3.935510,
      1,
      3,
      0.274053,
      1.649701,
      NULL,
      NULL,
      0.520389,
      0.544718,
      NULL,
      0,
      NULL,
      4.376446,
      NULL,
      0.895660,
      3,
      14.583244,
      2,
      1,
      4,
      0.505526,
      1,
      NULL,
      0,
      0.676631,
      1,
      0.646017,
      0.399182,
      1.029262,
      0.812708,
      10,
      8,
      6,
      NULL,
      1.954604,
      0,
      1,
      1,
      1,
      NULL,
      0,
      2,
      3,
      5,
      4,
      NULL,
      3,
      3.284565,
      1,
      0,
      0,
      1,
      0.607275,
      NULL,
      NULL,
      1.699166,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1.582652,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      3,
      1,
      4,
      1,
      1,
      4,
      1,
      1,
      NULL,
      5.232334,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4,
      0,
      4,
      0,
      5,
      4,
      4,
      2,
      5,
      NULL,
      0,
      5,
      2,
      0,
      3,
      3,
      5,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      0,
      NULL,
      NULL,
      ' 4-28-2001',
      NULL,
      0.880717,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      0,
      4,
      2,
      3.981300,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.795951,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.307221,
      0.121757,
      NULL,
      NULL,
      0.705972,
      0.952656,
      2,
      16626.710272,
      1.557985,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.512217,
      3,
      NULL,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      2,
      0,
      1,
      2.810906,
      5.517081,
      NULL,
      0.295438,
      0.524963,
      5.601219,
      0.828648,
      0,
      1,
      1.317220,
      NULL,
      1.149605,
      1.909434,
      0,
      0,
      0.436471,
      2.353668,
      0,
      10.421140,
      9,
      7.738869,
      NULL,
      0.423245,
      NULL,
      NULL,
      1.928111,
      4,
      2,
      2,
      1,
      NULL,
      0,
      0,
      NULL,
      48,
      26,
      39.888409,
      2,
      NULL,
      1,
      '20133',
      '31123',
      NULL,
      NULL,
      '',
      '',
      '',
      NULL,
      '23421',
      '34443',
      '302',
      3,
      0,
      766,
      1.404766,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.232520,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.926526,
      0.458985,
      1,
      4,
      NULL,
      1.393997,
      15.347061,
      NULL,
      0,
      2.684683,
      3.965765,
      0.320338,
      NULL,
      NULL,
      NULL,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      8.875444,
      NULL,
      0,
      0.087408,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.066706,
      3,
      1.129775,
      19,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      2.366655,
      0.880945,
      NULL,
      0,
      0.631535,
      1.171921,
      0,
      1.628617,
      0,
      1.304466,
      0.733173,
      0.436996,
      1,
      NULL,
      NULL,
      NULL,
      1.318790,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.442420,
      NULL,
      NULL,
      6.610252,
      6.607557,
      2,
      0,
      0.809882,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.764737,
      NULL,
      NULL,
      0.610542,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      2.473872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      10.124161,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      16,
      NULL,
      NULL,
      0.763585,
      NULL,
      NULL,
      0,
      3.587980,
      0,
      0,
      NULL,
      NULL,
      2,
      NULL,
      2,
      0.757847,
      2,
      0.389457,
      5,
      2,
      7.663155,
      8.485657,
      0.368042,
      4.175387,
      1,
      3,
      1.257848,
      0,
      NULL,
      NULL,
      0,
      3,
      1.180404,
      NULL,
      2.397667,
      1.398761,
      NULL,
      1,
      4.426640,
      2.227658,
      3.173291,
      0,
      NULL,
      1.489299,
      0.319538,
      NULL,
      2,
      0.251783,
      2.586213,
      1,
      NULL,
      3.039640,
      NULL,
      NULL,
      NULL,
      3.162417,
      0.345827,
      0,
      1,
      0,
      NULL,
      0,
      1.290324,
      1.637309,
      1.304224,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.841428,
      NULL,
      NULL,
      1,
      1,
      0,
      1.097057,
      0.482244,
      1,
      0.979185,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.411375,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.111885,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.863375,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3.463361,
      NULL,
      NULL,
      NULL,
      0.204366,
      NULL,
      NULL,
      NULL,
      1,
      787.017192,
      184,
      NULL,
      NULL,
      NULL,
      0.318462,
      NULL,
      NULL,
      1,
      NULL,
      1620,
      NULL,
      NULL,
      NULL,
      1.301325,
      NULL,
      NULL,
      2,
      NULL,
      3.425443,
      NULL,
      1417.785127,
      1,
      0.213196,
      0.539853,
      1.731704,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.505733,
      0.619131,
      1,
      NULL,
      0.712026,
      0,
      0,
      NULL,
      1.649123,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      3,
      1.121509,
      0,
      3.292709,
      NULL,
      NULL,
      1.473744,
      1,
      0.004243,
      NULL,
      1,
      3.491457,
      NULL,
      1.153465,
      NULL,
      NULL,
      1,
      0,
      NULL,
      2.680896,
      NULL,
      NULL,
      1.924627,
      NULL,
      NULL,
      1.309572,
      1,
      NULL,
      3.481815,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.901371,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.497213,
      NULL,
      NULL,
      NULL,
      1.176341,
      NULL,
      0,
      4,
      5,
      1,
      1.766750,
      0.969663,
      11.301475,
      67,
      0,
      0.865262,
      NULL,
      '20022',
      '33123',
      '12201',
      NULL,
      NULL,
      NULL,
      '',
      1.293904,
      '34121',
      '43220',
      '122');
commit;
end;
/


