set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9647114';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2002-11-07 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      3.176228,
      3,
      5.533737,
      2.945017,
      NULL,
      1,
      0.513225,
      1.670764,
      '220',
      '30440043',
      21.837635,
      3,
      NULL,
      0.931477,
      1.234060,
      5,
      2,
      '3314',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 4-12-1979',
      32,
      12,
      NULL,
      0,
      NULL,
      ' 8-20-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      '10-21-1986',
      '11-13-1977',
      NULL,
      2.829367,
      0,
      2.433149,
      1,
      0.236134,
      NULL,
      1.879639,
      0,
      10.059879,
      1,
      16,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      1,
      1,
      1,
      0.334014,
      1,
      1.491456,
      0,
      0,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0.370541,
      1,
      1,
      NULL,
      5,
      1,
      NULL,
      4,
      1,
      0,
      1,
      1,
      1,
      5.750421,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      NULL,
      1,
      0.144278,
      2,
      2,
      1.021324,
      NULL,
      NULL,
      NULL,
      0.345739,
      NULL,
      3.855084,
      0.601738,
      0.694123,
      1.799038,
      1.571626,
      0,
      NULL,
      4,
      5.995738,
      1,
      0,
      0.278122,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      3,
      1,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.988210,
      1,
      0,
      0,
      NULL,
      1,
      NULL,
      1.014693,
      1,
      NULL,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      1,
      3,
      3,
      0,
      4,
      NULL,
      0,
      0,
      1,
      0.425329,
      1.083705,
      ' 5- 6-1985',
      395.646390,
      NULL,
      102.266257,
      3,
      1,
      2,
      NULL,
      1,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      0.794406,
      NULL,
      NULL,
      NULL,
      3.995932,
      0.951269,
      0.593896,
      3.304088,
      1,
      5.857085,
      0,
      NULL,
      NULL,
      NULL,
      0.816846,
      0.079575,
      1.737314,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.885682,
      1,
      NULL,
      3.435182,
      0.190246,
      0,
      1.147289,
      3.994917,
      NULL,
      3,
      1.148469,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      2,
      1,
      NULL,
      3,
      0,
      2,
      1,
      3,
      3,
      1,
      NULL,
      4.045878,
      3.021479,
      1,
      NULL,
      NULL,
      5.472234,
      0.705856,
      1.887583,
      1,
      NULL,
      1.201534,
      1,
      0.820502,
      1,
      0,
      2.192021,
      NULL,
      0.353616,
      1.372875,
      NULL,
      7,
      NULL,
      NULL,
      6.713629,
      3.755199,
      3.663451,
      3.515164,
      NULL,
      0.521678,
      0,
      NULL,
      2,
      3,
      16,
      NULL,
      NULL,
      49,
      NULL,
      5,
      0,
      NULL,
      '',
      NULL,
      NULL,
      '14122',
      '',
      NULL,
      1,
      NULL,
      '',
      NULL,
      2,
      14.096554,
      43,
      26.788521,
      0.832123,
      NULL,
      NULL,
      NULL,
      NULL,
      0.223111,
      0,
      2.706583,
      1.986853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.639078,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.240387,
      1.393002,
      1,
      0.560825,
      NULL,
      NULL,
      0.834181,
      2,
      2.249469,
      1.532575,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      7,
      2.779035,
      0.814687,
      1,
      0.136959,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1.779559,
      NULL,
      NULL,
      0,
      NULL,
      3.556270,
      2.830394,
      0,
      0.601535,
      1.131768,
      1,
      1.290185,
      1,
      1,
      2.261605,
      NULL,
      NULL,
      1.836669,
      1.415539,
      NULL,
      0.691147,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      2.425554,
      0,
      10,
      1,
      0.233700,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.193539,
      NULL,
      NULL,
      NULL,
      0,
      0.504994,
      NULL,
      2,
      2,
      1.175156,
      1,
      1.979740,
      NULL,
      5.204315,
      1.990475,
      NULL,
      NULL,
      NULL,
      1.626960,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.895843,
      NULL,
      NULL,
      0.591101,
      NULL,
      NULL,
      0.459136,
      NULL,
      NULL,
      1.483631,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.812080,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      3.405876,
      0.552200,
      1.016649,
      3,
      0,
      0,
      0.645376,
      0.024683,
      3.728655,
      3.618500,
      NULL,
      0.905127,
      NULL,
      NULL,
      1,
      NULL,
      0,
      3.154582,
      2.376783,
      3,
      1,
      NULL,
      NULL,
      1.838558,
      5,
      1.740797,
      1,
      NULL,
      NULL,
      3.247453,
      3,
      NULL,
      0.458428,
      0.199735,
      0,
      0.393909,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.856701,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1.825585,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.183721,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.498496,
      0,
      NULL,
      0,
      1.978316,
      NULL,
      NULL,
      NULL,
      1.906049,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.770430,
      NULL,
      NULL,
      NULL,
      0.353554,
      NULL,
      NULL,
      NULL,
      0.354266,
      NULL,
      NULL,
      NULL,
      0.973069,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.637280,
      NULL,
      NULL,
      NULL,
      3.084159,
      NULL,
      NULL,
      NULL,
      0.959522,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.128740,
      3,
      NULL,
      NULL,
      2,
      NULL,
      0.368800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.768920,
      0,
      1.519255,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.038386,
      597,
      20.637848,
      1.618672,
      1,
      0,
      1,
      0,
      1.578661,
      NULL,
      1.372323,
      1,
      1.720991,
      0,
      0,
      1.884346,
      0.977885,
      1.757992,
      1.726176,
      NULL,
      1.494650,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      0.564976,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.566725,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.552489,
      1.210884,
      NULL,
      0.981669,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.214924,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.521111,
      1,
      0,
      NULL,
      1.859576,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.749285,
      NULL,
      NULL,
      NULL,
      1,
      0.277727,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      7.000715,
      NULL,
      0.002456,
      0.782336,
      3,
      NULL,
      2,
      0.677296,
      1,
      3,
      2.119100,
      NULL,
      3,
      1,
      NULL,
      1,
      1,
      NULL,
      0,
      0.865646,
      NULL,
      3.895917,
      1.768682,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1.293902,
      NULL,
      0.187853,
      0.250289,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1.648007,
      NULL,
      0.461912,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.751536,
      NULL,
      1,
      1,
      NULL,
      0.332894,
      NULL,
      NULL,
      64.960827,
      73,
      2,
      NULL,
      0,
      '42102',
      '',
      '',
      1.097299,
      '33303',
      '',
      '',
      NULL,
      '3434',
      '33342',
      NULL);
commit;
end;
/


