set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9530492';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1995-10-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      '0',
      NULL,
      NULL,
      '0033230',
      NULL,
      0,
      4,
      0,
      '2410',
      3,
      1.666495,
      NULL,
      NULL,
      ' 5-12-1991',
      52.433008,
      NULL,
      NULL,
      3.036608,
      1.529065,
      ' 7-28-1992',
      36.768258,
      0,
      55.209373,
      74.989249,
      2,
      NULL,
      ' 6-18-1982',
      NULL,
      0,
      3,
      NULL,
      0,
      1.527592,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      9,
      12.623005,
      5,
      11,
      NULL,
      5,
      3,
      NULL,
      0,
      0,
      1,
      1.720202,
      0.417206,
      0.907257,
      0.346077,
      1,
      2.688116,
      0,
      0,
      3,
      4,
      NULL,
      1,
      0,
      1,
      1,
      1,
      3,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1,
      1.991921,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      0,
      0,
      NULL,
      5,
      0,
      0,
      3,
      0,
      0,
      1,
      0,
      1,
      NULL,
      0.292969,
      NULL,
      3,
      1,
      3,
      1,
      5,
      3,
      1,
      1,
      3,
      1,
      5,
      5,
      0,
      1,
      5,
      0,
      0,
      5,
      0,
      0,
      1,
      1,
      3,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5,
      2,
      1,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      2.018042,
      0,
      1.134997,
      0.177827,
      3.857120,
      3.263682,
      3.194763,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      NULL,
      6,
      5.416489,
      NULL,
      3,
      NULL,
      2.249915,
      0.495888,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.554755,
      NULL,
      0.943224,
      0,
      1,
      NULL,
      1,
      3.669189,
      4.552293,
      0.227967,
      0.161228,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.120801,
      1,
      1,
      NULL,
      NULL,
      0,
      0,
      0,
      1,
      3,
      3,
      0,
      2.461938,
      3.479199,
      6,
      1,
      0,
      11,
      1.482850,
      NULL,
      0.743227,
      1.490654,
      0,
      NULL,
      0.335206,
      0,
      1,
      16.041333,
      2,
      0,
      10.175273,
      7.871852,
      0.046280,
      9,
      NULL,
      6.691478,
      3,
      3,
      6,
      3.582330,
      2.684599,
      2.618044,
      16,
      0,
      2.214176,
      NULL,
      61,
      36,
      90.205117,
      5,
      5.376350,
      0.872025,
      '00212',
      '4220',
      '',
      0.451797,
      '',
      '',
      '',
      1,
      '',
      NULL,
      '',
      3,
      13.688149,
      31.985609,
      0.544060,
      1,
      24.329788,
      NULL,
      0.738057,
      NULL,
      3,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.974753,
      1,
      1,
      NULL,
      NULL,
      1.467835,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.641931,
      NULL,
      NULL,
      1.656264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.922319,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      3,
      NULL,
      2,
      1,
      0,
      1,
      NULL,
      NULL,
      3,
      1.169506,
      0,
      1.693882,
      NULL,
      NULL,
      1.162630,
      NULL,
      0,
      NULL,
      NULL,
      2.138700,
      3.927724,
      0.614618,
      0,
      0,
      0,
      NULL,
      NULL,
      1.902779,
      NULL,
      NULL,
      0.424707,
      NULL,
      NULL,
      1.710881,
      0.869907,
      1.365445,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      1,
      NULL,
      NULL,
      0.943631,
      NULL,
      0.037044,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.189666,
      3,
      0.367643,
      1.230561,
      NULL,
      NULL,
      4,
      3,
      1,
      NULL,
      NULL,
      NULL,
      1.516451,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.047095,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.513795,
      NULL,
      1,
      2,
      3.993983,
      0,
      NULL,
      4,
      NULL,
      3,
      4.012330,
      0,
      2.916060,
      NULL,
      NULL,
      1,
      3,
      2.175905,
      2.317750,
      0.833339,
      0,
      1.740524,
      2,
      0.909298,
      6.628783,
      2.804421,
      1.229440,
      1.832402,
      0.650723,
      NULL,
      NULL,
      3.091382,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.775884,
      0,
      8,
      3.211527,
      5.537507,
      3,
      4,
      2.615025,
      NULL,
      1,
      0,
      1,
      1,
      1,
      1,
      1.641336,
      2.074255,
      NULL,
      NULL,
      1.484054,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.851324,
      NULL,
      NULL,
      1.119845,
      NULL,
      NULL,
      1.369725,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      0.854131,
      0.396329,
      0,
      1.146819,
      3.351912,
      NULL,
      NULL,
      0.545742,
      2.653096,
      NULL,
      NULL,
      11,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0.212650,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.121232,
      3,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      1,
      1.364738,
      NULL,
      NULL,
      0,
      0.211035,
      NULL,
      NULL,
      2,
      2,
      NULL,
      NULL,
      2.089700,
      0.809355,
      NULL,
      NULL,
      0,
      1.349557,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      2.530380,
      1,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      NULL,
      NULL,
      1,
      0,
      2.021207,
      0,
      NULL,
      NULL,
      1.976252,
      NULL,
      NULL,
      0.927522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      0,
      1.127755,
      NULL,
      0,
      NULL,
      0,
      1.856973,
      NULL,
      1.624479,
      0,
      NULL,
      0,
      0.104437,
      1.703765,
      1,
      0.336367,
      0.222872,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      2,
      15.040942,
      3.614798,
      NULL,
      1.002087,
      0,
      4,
      3,
      NULL,
      2.352191,
      1,
      0.596137,
      1.712593,
      1.132742,
      1,
      1,
      1,
      2.553538,
      2.667336,
      1,
      0.182079,
      NULL,
      1,
      2.607155,
      1.526979,
      NULL,
      NULL,
      3.014940,
      0,
      0.212362,
      0.094724,
      2,
      3.526549,
      NULL,
      0.465707,
      1,
      0,
      2,
      3,
      2.404128,
      1,
      0.856224,
      0.645191,
      0,
      1.956317,
      1.053248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.198052,
      3,
      0.349703,
      NULL,
      1.208818,
      0,
      1.474243,
      0.290799,
      3.684526,
      NULL,
      1.483710,
      1,
      2,
      NULL,
      2,
      1,
      NULL,
      2,
      3,
      2,
      1,
      1,
      NULL,
      3.914711,
      1.466296,
      19,
      NULL,
      NULL,
      0,
      1.965947,
      0,
      1.150295,
      1,
      0.633407,
      3,
      3,
      0,
      NULL,
      NULL,
      NULL,
      101,
      94,
      1,
      4,
      6,
      '02144',
      NULL,
      '04330',
      1,
      '',
      '',
      '',
      0.993106,
      '',
      '',
      '');
commit;
end;
/


