set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7616981';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-8-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '3',
      '4',
      NULL,
      NULL,
      NULL,
      3,
      1.600368,
      2,
      NULL,
      '3104',
      2.155002,
      0.477085,
      NULL,
      NULL,
      ' 9-19-1977',
      51.252623,
      NULL,
      1,
      2,
      NULL,
      ' 0-20-2003',
      20,
      3,
      81.015537,
      11.960008,
      3,
      ' 1-20-1979',
      ' 2-20-1976',
      '10- 7-1976',
      2,
      0.948944,
      3,
      1,
      1.425042,
      3.740870,
      0,
      0,
      NULL,
      176,
      3,
      0.890486,
      1.865040,
      NULL,
      19.186703,
      4,
      NULL,
      3,
      1,
      4.557424,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1,
      1.115445,
      0.252450,
      NULL,
      90.983772,
      NULL,
      2,
      0,
      NULL,
      0,
      1,
      1,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      0,
      0,
      NULL,
      2,
      0.893313,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0,
      0,
      NULL,
      1,
      0,
      0,
      0.225412,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      5,
      0,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      7.230928,
      1,
      1,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      2,
      2,
      2,
      0,
      0,
      1,
      1,
      1,
      NULL,
      2,
      0,
      1,
      1,
      4,
      NULL,
      5,
      1,
      1,
      5,
      0,
      NULL,
      2,
      5,
      1,
      4.068472,
      3.369924,
      ' 8- 0-1980',
      984,
      ' 1-19-1990',
      1177.438532,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.758927,
      0.887602,
      1,
      0.213306,
      0.088421,
      0.567688,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.104902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      1.584711,
      1.411792,
      3,
      339.288466,
      3.419258,
      0.086936,
      NULL,
      NULL,
      NULL,
      2,
      0.421793,
      0,
      NULL,
      2,
      1,
      2,
      NULL,
      0,
      3,
      2,
      2,
      3,
      3,
      3.539811,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1.323179,
      1.086688,
      1.033764,
      NULL,
      1,
      1.089227,
      0,
      0,
      1,
      NULL,
      0.190549,
      5.520442,
      8,
      1,
      4,
      11,
      3,
      NULL,
      0,
      2.397675,
      3.884888,
      3,
      NULL,
      63.248440,
      1,
      3.407034,
      NULL,
      25,
      4,
      47.466255,
      5,
      NULL,
      NULL,
      '40121',
      '00002',
      NULL,
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      3.417660,
      5.750428,
      125,
      9,
      NULL,
      26.878714,
      NULL,
      145,
      0,
      1.643626,
      2,
      2,
      0.135199,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      2.344661,
      3.268954,
      1.458756,
      1.401904,
      2.111747,
      0.799189,
      NULL,
      NULL,
      0,
      0.099659,
      3,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.235966,
      NULL,
      NULL,
      10.451258,
      6.569715,
      9.734479,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.081836,
      0.340017,
      0.971828,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      1.094173,
      0,
      2.669270,
      0,
      0,
      2,
      1.847660,
      NULL,
      0,
      1,
      0.049565,
      1.547422,
      3.558159,
      0.889613,
      NULL,
      3.513318,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7.777422,
      NULL,
      NULL,
      0,
      1.697276,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.734908,
      NULL,
      NULL,
      1,
      NULL,
      1.193878,
      0.164245,
      NULL,
      0,
      0,
      NULL,
      NULL,
      11.745816,
      NULL,
      4.553276,
      2.795684,
      NULL,
      0.480140,
      1.811924,
      NULL,
      NULL,
      NULL,
      1.676763,
      3.178532,
      1.556443,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.740200,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.264709,
      NULL,
      NULL,
      0.469766,
      NULL,
      NULL,
      2,
      3.018822,
      1,
      2.042702,
      NULL,
      3,
      0,
      0.413417,
      1.579786,
      2,
      3,
      1,
      NULL,
      NULL,
      NULL,
      0.514290,
      1.253029,
      1,
      1.448518,
      NULL,
      0.311009,
      1.640870,
      0.525331,
      NULL,
      8,
      4.928239,
      NULL,
      3.344604,
      3.060058,
      1,
      0,
      NULL,
      NULL,
      0.427472,
      0,
      2.908666,
      0,
      2,
      2.142246,
      4,
      2.035266,
      NULL,
      2,
      4,
      4.940110,
      2,
      3,
      0,
      1.460892,
      1,
      0,
      0.889392,
      0,
      0.243297,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.599389,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.914599,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.139108,
      NULL,
      NULL,
      1.878397,
      1,
      0.000506,
      1.251205,
      1.726734,
      1.734212,
      1.111324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.747108,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.298080,
      NULL,
      NULL,
      NULL,
      2.431910,
      NULL,
      NULL,
      NULL,
      0.071132,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.907131,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      1.900474,
      NULL,
      NULL,
      NULL,
      NULL,
      392,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.866812,
      0,
      NULL,
      NULL,
      1.107348,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      5.443087,
      39,
      NULL,
      0.237151,
      1,
      NULL,
      0,
      NULL,
      0.736369,
      1.181626,
      NULL,
      NULL,
      NULL,
      0.687082,
      1,
      0,
      0,
      NULL,
      NULL,
      1.663647,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.862122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0,
      NULL,
      0.116301,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.826174,
      NULL,
      NULL,
      NULL,
      1.032886,
      1,
      1.969122,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.855842,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      550,
      NULL,
      3.439716,
      NULL,
      0,
      NULL,
      0,
      0.214725,
      NULL,
      30,
      31,
      0.395832,
      NULL,
      NULL,
      NULL,
      0,
      1,
      3,
      3,
      NULL,
      NULL,
      NULL,
      0,
      17,
      1.407210,
      1.673045,
      NULL,
      0.503108,
      0.881605,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.134183,
      NULL,
      1.426540,
      0.486378,
      NULL,
      1.550737,
      NULL,
      NULL,
      1.975325,
      0,
      NULL,
      2,
      2.739291,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1.894024,
      NULL,
      NULL,
      0,
      NULL,
      3.103039,
      0.096013,
      NULL,
      1.858649,
      0,
      0.641361,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.133252,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      4,
      NULL,
      0.988314,
      0.428841,
      3.163717,
      NULL,
      9,
      4,
      0,
      NULL,
      '10440',
      NULL,
      '',
      0.326364,
      '',
      '',
      '',
      0,
      NULL,
      '',
      '');
commit;
end;
/


