set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9849772';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-9-25 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.338343,
      NULL,
      5,
      1.384150,
      NULL,
      3,
      NULL,
      6.182245,
      '031',
      '04043142',
      59.613207,
      47,
      '0143123',
      1,
      NULL,
      NULL,
      1,
      '3414',
      NULL,
      0.119027,
      NULL,
      NULL,
      NULL,
      90,
      4,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 7-12-1995',
      ' 1-18-1977',
      ' 6-22-2003',
      3.151959,
      NULL,
      2,
      1.479702,
      1,
      1,
      3,
      0.481365,
      NULL,
      3.255163,
      1,
      5,
      6.674412,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0.519601,
      NULL,
      1,
      1.050751,
      NULL,
      0.151026,
      1.154595,
      1.114192,
      0.011427,
      NULL,
      0,
      NULL,
      NULL,
      4,
      NULL,
      2,
      0,
      0,
      2,
      0,
      0,
      3,
      0,
      5,
      0,
      0,
      0,
      2,
      NULL,
      2,
      2,
      NULL,
      1.651522,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      6.918284,
      1.786126,
      0.271931,
      0.595579,
      1.417070,
      0.450647,
      0.847241,
      2.810282,
      0,
      2.117825,
      2,
      1,
      NULL,
      0.700109,
      1,
      3.539406,
      NULL,
      0,
      1,
      2,
      0,
      0,
      2,
      1,
      0.787119,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      0,
      1,
      0,
      0,
      1,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.419829,
      NULL,
      0,
      1,
      0,
      1,
      5,
      1,
      1,
      1,
      5,
      NULL,
      1,
      0,
      5,
      NULL,
      4,
      0,
      1,
      5,
      NULL,
      4,
      NULL,
      0,
      NULL,
      1,
      0.594588,
      2.263747,
      NULL,
      12.385199,
      ' 3-22-1991',
      53,
      2,
      1,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      0,
      1,
      1,
      2,
      0.825745,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.791690,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.912340,
      5,
      1.605526,
      0.877677,
      0.344397,
      0,
      NULL,
      NULL,
      NULL,
      0.753310,
      4.308182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      NULL,
      0,
      NULL,
      1,
      1.955119,
      NULL,
      18,
      2.096728,
      1.533316,
      NULL,
      NULL,
      NULL,
      0,
      1.643184,
      0.493869,
      0,
      1,
      1,
      2,
      2,
      0,
      2,
      1,
      NULL,
      0,
      7.995931,
      3,
      NULL,
      3,
      1,
      0.889503,
      0.768910,
      0.256435,
      1,
      1.561457,
      0,
      0.392852,
      0,
      0.380652,
      0.014144,
      2,
      3,
      4.703917,
      0,
      1,
      NULL,
      7.631813,
      NULL,
      11.005687,
      7.014301,
      3,
      1,
      NULL,
      0,
      2.585470,
      0.950780,
      NULL,
      0,
      NULL,
      57,
      NULL,
      NULL,
      40,
      2,
      5,
      3,
      NULL,
      '44321',
      '',
      0,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      27.699379,
      20.186076,
      18,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0.166374,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3.409324,
      1.537182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.694024,
      NULL,
      NULL,
      4.765997,
      4,
      5,
      0,
      0.118709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.413574,
      NULL,
      NULL,
      1.984525,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.438315,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.428169,
      NULL,
      NULL,
      1.627682,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.814484,
      NULL,
      NULL,
      1.413115,
      NULL,
      NULL,
      0.595860,
      NULL,
      NULL,
      1.954140,
      NULL,
      NULL,
      0.564749,
      NULL,
      NULL,
      1.341826,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.621716,
      NULL,
      NULL,
      0.576548,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.159777,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.824253,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.704589,
      NULL,
      NULL,
      1.364607,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      1,
      1,
      0,
      5,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.271857,
      1.392687,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144714,
      NULL,
      0.655185,
      NULL,
      1.262854,
      1.340305,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      1.058523,
      8,
      NULL,
      NULL,
      NULL,
      NULL,
      1.022172,
      NULL,
      NULL,
      0.653071,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.949305,
      NULL,
      0.798864,
      29,
      4,
      0.904772,
      1.655383,
      0.043939,
      NULL,
      1.623324,
      0.335439,
      1,
      NULL,
      NULL,
      3.935894,
      1.585890,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.435670,
      NULL,
      NULL,
      0.077340,
      NULL,
      1,
      NULL,
      1.339659,
      NULL,
      0.421063,
      NULL,
      0.506138,
      NULL,
      6.826194,
      NULL,
      0.811549,
      26.277177,
      1,
      2,
      1,
      0.077452,
      NULL,
      1.058155,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.763983,
      NULL,
      1.229713,
      NULL,
      NULL,
      NULL,
      1.658218,
      NULL,
      1.531148,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.634905,
      NULL,
      0.392583,
      NULL,
      0,
      NULL,
      0,
      2.574204,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.435124,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.444932,
      1.102965,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.246294,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3.073833,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.336796,
      1.169767,
      0.554668,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      0.157999,
      0,
      1,
      0,
      0.632804,
      1,
      0.452225,
      0.645966,
      1,
      1,
      NULL,
      0,
      1.601386,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.060829,
      NULL,
      1.996636,
      NULL,
      NULL,
      0.450992,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0.137110,
      NULL,
      0,
      0,
      NULL,
      NULL,
      1.199900,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      NULL,
      44,
      NULL,
      0,
      3,
      4,
      NULL,
      '33134',
      '',
      0,
      NULL,
      '',
      '',
      0.108525,
      '',
      '',
      '');
commit;
end;
/


