set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9817670';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.808654,
      NULL,
      0,
      2.065070,
      2,
      NULL,
      3,
      2.114876,
      '042',
      '42121013',
      2,
      15,
      '3320343',
      3.061976,
      1,
      3,
      3,
      '1224',
      5.487316,
      1.991691,
      NULL,
      NULL,
      ' 2-26-1993',
      15,
      133,
      NULL,
      NULL,
      1.385109,
      ' 9- 5-1989',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 0-23-2001',
      '11-23-1986',
      '10-13-1980',
      1,
      NULL,
      NULL,
      3.084390,
      NULL,
      1,
      2,
      3,
      NULL,
      NULL,
      NULL,
      2.374423,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1.139876,
      0,
      0,
      1,
      NULL,
      1,
      1.080507,
      0.642570,
      1.574079,
      0.802556,
      2.249105,
      1,
      5,
      NULL,
      NULL,
      5,
      0,
      NULL,
      1,
      2,
      NULL,
      5,
      0,
      1,
      1,
      1,
      1,
      NULL,
      0,
      2,
      2,
      1,
      0.681544,
      NULL,
      NULL,
      NULL,
      2,
      1,
      5,
      0,
      1.868320,
      NULL,
      NULL,
      1.534689,
      NULL,
      0,
      1.636101,
      0.288967,
      0,
      NULL,
      1.648050,
      1.975159,
      1.178084,
      3.469147,
      0,
      2.698274,
      2.942198,
      NULL,
      0,
      1,
      3,
      2,
      0,
      1,
      0.102987,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      4,
      0,
      2,
      3,
      NULL,
      1,
      NULL,
      3,
      5,
      NULL,
      0,
      8.221014,
      1,
      1,
      0,
      0,
      0.810312,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      2,
      2,
      1,
      1,
      NULL,
      0,
      1,
      1,
      NULL,
      4,
      NULL,
      1,
      4,
      2,
      0,
      5,
      2,
      NULL,
      1,
      0,
      NULL,
      5.090508,
      2.514642,
      ' 7- 6-1998',
      14,
      ' 4-20-1976',
      2,
      0.117758,
      0,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      5,
      0,
      4,
      3,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      7,
      0,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      0.876686,
      NULL,
      0.027610,
      NULL,
      0,
      3.546739,
      1.599354,
      6.037031,
      0,
      NULL,
      6,
      1.223712,
      1,
      NULL,
      NULL,
      1.099068,
      9,
      2.470835,
      1,
      5,
      3,
      3,
      ' 3-15-1982',
      21,
      NULL,
      7,
      0.181604,
      0,
      1,
      1.269469,
      0.314107,
      1.619276,
      0,
      0.410065,
      0,
      0,
      NULL,
      13.135295,
      3.975599,
      0,
      NULL,
      NULL,
      NULL,
      2,
      2.887282,
      1,
      NULL,
      0,
      1,
      NULL,
      1,
      1,
      3,
      1,
      2,
      3,
      2,
      NULL,
      2,
      0,
      0,
      1.251127,
      0,
      NULL,
      0.872439,
      0.366296,
      0,
      1.311681,
      NULL,
      1,
      1,
      0,
      1.661880,
      2,
      0.844722,
      9,
      6.399225,
      1,
      11.254084,
      3.610494,
      NULL,
      2,
      2.149324,
      5,
      NULL,
      0.205714,
      3.014109,
      11.408024,
      NULL,
      NULL,
      0,
      NULL,
      32,
      37.735995,
      2,
      2.603898,
      0.782149,
      '30324',
      '',
      '',
      1,
      '',
      '',
      NULL,
      0,
      '2134',
      '3442',
      NULL,
      NULL,
      30,
      25.826493,
      29,
      1,
      NULL,
      0.446900,
      0.084542,
      3,
      1.248234,
      1.152663,
      NULL,
      1.187953,
      1,
      1,
      1,
      NULL,
      1.832536,
      1.699956,
      1.813090,
      NULL,
      0,
      0.249151,
      0.712275,
      NULL,
      0.227344,
      0.577906,
      2,
      1.765907,
      0.770662,
      0,
      0,
      1,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.432632,
      1,
      1.319819,
      1,
      1.062729,
      0.684738,
      1.312874,
      0.616093,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.594250,
      NULL,
      NULL,
      1.992393,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.907415,
      NULL,
      0,
      NULL,
      NULL,
      0.180976,
      NULL,
      NULL,
      2.743717,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.934093,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.264808,
      3,
      1.342712,
      1.199689,
      NULL,
      NULL,
      3.225878,
      2,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      3,
      2.199831,
      1.072937,
      0.205800,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.127719,
      NULL,
      NULL,
      1.180573,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.701185,
      0.005653,
      0.139292,
      3.466263,
      0.291538,
      2.785649,
      1.754341,
      2,
      NULL,
      4.746587,
      0.963446,
      NULL,
      NULL,
      NULL,
      0.247637,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      4,
      1.474889,
      1.551730,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.672035,
      1.546369,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      13.405279,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0.792155,
      NULL,
      NULL,
      NULL,
      0.904775,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.291379,
      NULL,
      NULL,
      NULL,
      0.957455,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.060248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.751531,
      1,
      0.893529,
      NULL,
      2.687879,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.778661,
      0,
      0,
      1.453493,
      0,
      0,
      1,
      0,
      1,
      0.060053,
      0,
      0.937761,
      NULL,
      NULL,
      NULL,
      0.598131,
      0,
      1,
      1,
      0.509287,
      1.420493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      0.945085,
      1,
      2.820751,
      3,
      2,
      3,
      1,
      NULL,
      0.709103,
      0,
      0,
      2.024963,
      0.285604,
      1,
      NULL,
      NULL,
      0.892090,
      1.493828,
      0,
      3,
      1,
      0,
      0.190104,
      NULL,
      0,
      1,
      NULL,
      0.985209,
      0,
      0.580682,
      0,
      NULL,
      NULL,
      0,
      2.859395,
      2.297730,
      0,
      0.449763,
      1.239753,
      3,
      2.538748,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      1.323623,
      1.008062,
      1.538820,
      3,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      17,
      NULL,
      NULL,
      5,
      '00420',
      '41221',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '2402',
      '0134',
      '');
commit;
end;
/


