set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9005932';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-3-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.841651,
      0.851137,
      0,
      0,
      '0410',
      1,
      NULL,
      NULL,
      NULL,
      ' 7-28-1996',
      25,
      NULL,
      0,
      1,
      NULL,
      ' 5- 2-1991',
      17,
      2,
      NULL,
      87.232290,
      NULL,
      ' 3- 0-1995',
      ' 2-28-2003',
      ' 8-27-1983',
      0,
      0.759677,
      0.093477,
      0.983360,
      1,
      1.400143,
      NULL,
      1.474487,
      0,
      25.452110,
      8,
      10,
      NULL,
      12,
      3,
      NULL,
      NULL,
      0,
      1,
      6,
      1,
      1,
      1,
      0.204314,
      1,
      1,
      0.488504,
      0.208912,
      0,
      0.628127,
      61.527715,
      9,
      6,
      1,
      3.494721,
      5,
      1,
      3,
      2,
      2,
      0,
      1,
      3,
      0,
      3,
      3,
      3,
      4,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      4,
      0,
      NULL,
      3.056690,
      1.690924,
      NULL,
      0,
      1.073569,
      0.443971,
      2.673787,
      1,
      NULL,
      NULL,
      3,
      0.926130,
      NULL,
      3,
      0,
      1,
      4,
      5,
      NULL,
      7.978481,
      1,
      0,
      3.725892,
      1.730850,
      NULL,
      NULL,
      1.248599,
      NULL,
      NULL,
      2,
      NULL,
      5,
      0,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      0.974250,
      1,
      1,
      NULL,
      0,
      NULL,
      3,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      2,
      4,
      0,
      2,
      1,
      0,
      3,
      1,
      4,
      7,
      0,
      ' 7-23-1982',
      201.220088,
      ' 8- 0-1998',
      39,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      4,
      4,
      1,
      0,
      NULL,
      0.543429,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      21,
      0.779013,
      2.620772,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      2.905042,
      NULL,
      NULL,
      1.521751,
      0,
      2,
      7.488364,
      NULL,
      2,
      6,
      0,
      NULL,
      1,
      NULL,
      1.036812,
      2.273933,
      0.783818,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.605145,
      1,
      0,
      3,
      3,
      55,
      2.207989,
      0.596101,
      NULL,
      NULL,
      NULL,
      3,
      1.072222,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2,
      2,
      1,
      3,
      3,
      1,
      1,
      NULL,
      0,
      1.607369,
      1.578611,
      0,
      NULL,
      1.557163,
      0,
      1,
      0.616595,
      NULL,
      0,
      1,
      1,
      0,
      0,
      0,
      1,
      6.461887,
      3,
      1,
      0.825636,
      6.842209,
      NULL,
      5.189014,
      NULL,
      0,
      2.144406,
      2,
      2.453871,
      7,
      2,
      3,
      NULL,
      NULL,
      36,
      64,
      1,
      1.554501,
      NULL,
      '33231',
      NULL,
      '',
      1,
      '',
      '',
      '',
      1,
      '',
      '',
      '',
      1,
      31,
      NULL,
      22,
      1,
      20.962240,
      8,
      3,
      3,
      1,
      1.739088,
      3.177779,
      1,
      NULL,
      NULL,
      0,
      0.803920,
      NULL,
      0,
      2,
      1.801425,
      0.893631,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      2.423401,
      1.527481,
      NULL,
      0,
      NULL,
      2.189122,
      0.817162,
      1,
      1,
      3.973319,
      1,
      3.345310,
      3,
      3,
      NULL,
      0.648402,
      1.645985,
      5.811491,
      5.395725,
      2,
      1,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2,
      3,
      NULL,
      2.821516,
      3.662549,
      NULL,
      2,
      1.192428,
      0.480614,
      2.260865,
      1,
      0.101564,
      1,
      3,
      3,
      1.801047,
      0.507954,
      0,
      0.340478,
      1,
      0,
      NULL,
      3.124806,
      2,
      2,
      3,
      0,
      1.437342,
      2,
      NULL,
      NULL,
      0,
      1,
      1,
      0.155034,
      5.784801,
      3.861902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.172400,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.217233,
      2,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      0.464076,
      NULL,
      3.408962,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.451705,
      NULL,
      NULL,
      1.492488,
      NULL,
      NULL,
      1.958176,
      NULL,
      NULL,
      0.427549,
      NULL,
      NULL,
      0.716884,
      NULL,
      NULL,
      1.551064,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5.846652,
      1.989883,
      5.037931,
      NULL,
      NULL,
      NULL,
      0.123066,
      NULL,
      NULL,
      0,
      0,
      NULL,
      2,
      3,
      3.550993,
      2.613048,
      2,
      NULL,
      3.917708,
      3.283325,
      NULL,
      NULL,
      2,
      3.695496,
      3,
      0.067858,
      1.856516,
      NULL,
      3.566085,
      3.962083,
      8.628864,
      4,
      4,
      0.438419,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.904811,
      NULL,
      1.413243,
      0.650418,
      NULL,
      2,
      NULL,
      NULL,
      0.677365,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.258815,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.859521,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.770533,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.403468,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.249356,
      2,
      NULL,
      1,
      0.140029,
      2.268907,
      1,
      NULL,
      8,
      3.828720,
      NULL,
      NULL,
      11,
      300,
      NULL,
      NULL,
      0.838345,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.996789,
      1.272078,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.458529,
      3.724973,
      NULL,
      NULL,
      1.080226,
      3,
      NULL,
      NULL,
      2.805493,
      NULL,
      NULL,
      NULL,
      2.059823,
      0.877450,
      NULL,
      NULL,
      0.864325,
      0.354923,
      NULL,
      NULL,
      NULL,
      2.158786,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.384363,
      3.003890,
      NULL,
      NULL,
      1.372043,
      3,
      NULL,
      NULL,
      8,
      14.269477,
      NULL,
      NULL,
      2,
      1.564804,
      3.488056,
      6,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      50,
      2.644942,
      1.728049,
      NULL,
      NULL,
      0.352253,
      NULL,
      NULL,
      1.750168,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.992191,
      2.747560,
      1,
      109.508217,
      2.350650,
      1,
      NULL,
      1,
      0.271212,
      0,
      1.311218,
      NULL,
      0.357775,
      1,
      1,
      0.139182,
      NULL,
      0.239175,
      3.209471,
      NULL,
      0.692167,
      1,
      1.486684,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.635840,
      NULL,
      1,
      NULL,
      0.392584,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.952539,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.193943,
      0.677041,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.683853,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.382481,
      0,
      NULL,
      2.306961,
      NULL,
      1,
      NULL,
      2,
      NULL,
      1.939964,
      NULL,
      1.722371,
      NULL,
      NULL,
      NULL,
      0.733680,
      0,
      1.390915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.666004,
      0.480344,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.992581,
      NULL,
      NULL,
      3.810623,
      NULL,
      3.253862,
      NULL,
      162.135452,
      NULL,
      0.321496,
      NULL,
      0,
      NULL,
      0.495089,
      0,
      0.191043,
      19.551119,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      6.755201,
      1,
      NULL,
      1,
      0,
      1,
      3,
      0,
      0.585926,
      0,
      0,
      NULL,
      1,
      1.239934,
      NULL,
      NULL,
      NULL,
      NULL,
      3.461228,
      1,
      NULL,
      NULL,
      2,
      NULL,
      3.595265,
      1.338610,
      NULL,
      0,
      NULL,
      NULL,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      2,
      NULL,
      NULL,
      1.108546,
      0.077678,
      NULL,
      0.526648,
      1.870841,
      0,
      1.978279,
      NULL,
      0.091412,
      NULL,
      1,
      NULL,
      0,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1.403378,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.460943,
      NULL,
      NULL,
      NULL,
      0.335987,
      NULL,
      23.695000,
      NULL,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.706326,
      NULL,
      3.196277,
      NULL,
      1.305116,
      NULL,
      2.082499,
      NULL,
      0.091156,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.536608,
      NULL,
      2,
      3,
      NULL,
      0.671294,
      NULL,
      3,
      NULL,
      1,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      '11104',
      '23240',
      '20234',
      1.913376,
      '',
      '',
      NULL,
      0.205717,
      '',
      '',
      NULL);
commit;
end;
/


