set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9797944';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-8-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      2.068886,
      2,
      1,
      NULL,
      2,
      0,
      2.767430,
      1,
      '433',
      '11004131',
      53.519182,
      37,
      NULL,
      NULL,
      0.027982,
      NULL,
      1,
      '2323',
      3,
      NULL,
      NULL,
      NULL,
      ' 3- 7-1990',
      NULL,
      0,
      NULL,
      NULL,
      1.590607,
      ' 9-18-1974',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      ' 3-26-1977',
      1,
      NULL,
      NULL,
      1.489770,
      NULL,
      0,
      6,
      0.740385,
      1.461547,
      NULL,
      8,
      15,
      2.516956,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      1,
      0,
      0,
      4,
      1,
      0,
      3,
      0,
      NULL,
      4,
      0,
      1,
      1,
      0,
      0,
      5.010404,
      1,
      1,
      1,
      1,
      0.102036,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      1,
      0.882857,
      2,
      1,
      2,
      0,
      3.358971,
      NULL,
      1,
      NULL,
      1,
      3,
      1,
      0.616426,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      0.202979,
      1.753181,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      0,
      NULL,
      1,
      1,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      1,
      0,
      NULL,
      0.945641,
      5,
      0,
      1,
      NULL,
      0,
      2,
      1,
      1,
      0,
      1,
      0,
      2,
      NULL,
      1,
      0,
      3,
      3,
      1,
      3,
      5,
      5,
      2,
      NULL,
      1,
      1,
      NULL,
      1.105509,
      ' 9-25-2003',
      1060,
      NULL,
      701.758298,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0,
      1,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.641026,
      0,
      1,
      3,
      1.023608,
      1.750040,
      1,
      NULL,
      NULL,
      NULL,
      0.989068,
      0.271492,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.894292,
      2.505849,
      NULL,
      0,
      1,
      NULL,
      NULL,
      2.303094,
      0.050203,
      NULL,
      NULL,
      NULL,
      2,
      0,
      1.280268,
      1,
      1,
      NULL,
      NULL,
      2,
      1,
      3,
      3,
      2,
      NULL,
      2.951724,
      2,
      0.137258,
      1.491600,
      0.687177,
      1,
      1.572556,
      NULL,
      0.565760,
      0,
      2.537103,
      1,
      NULL,
      NULL,
      0.468139,
      1,
      1,
      2.035837,
      1,
      6,
      5,
      NULL,
      9,
      NULL,
      4,
      1.483102,
      3,
      6,
      0.425548,
      1.223776,
      0,
      20.947724,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      5.552389,
      1.396190,
      NULL,
      NULL,
      '',
      NULL,
      NULL,
      '',
      '',
      0,
      NULL,
      '',
      '',
      3,
      40,
      75,
      44.488561,
      1.380102,
      NULL,
      7,
      5.362203,
      3,
      2.935237,
      1,
      3.587542,
      0,
      NULL,
      NULL,
      1.880037,
      NULL,
      NULL,
      3.268762,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.476763,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.615717,
      0,
      1.248368,
      1,
      1.165903,
      1.512621,
      1,
      0,
      1.505233,
      3.205760,
      NULL,
      0.766366,
      3.193999,
      0,
      0.987187,
      8.035617,
      0,
      5.911284,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.684598,
      NULL,
      NULL,
      NULL,
      1.854327,
      0,
      3,
      NULL,
      0.318440,
      0.459601,
      0.231722,
      1.366320,
      NULL,
      2.826469,
      1.823312,
      0.052438,
      2,
      NULL,
      1.141695,
      2.371197,
      1.565005,
      NULL,
      1,
      0.508671,
      NULL,
      3.146442,
      NULL,
      0.287307,
      1,
      0.799991,
      NULL,
      NULL,
      0.503135,
      1.621916,
      1,
      2.959823,
      NULL,
      NULL,
      NULL,
      0,
      5.790888,
      NULL,
      0.918562,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.793062,
      NULL,
      NULL,
      NULL,
      1.795683,
      1.676329,
      0,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.023091,
      NULL,
      1,
      NULL,
      NULL,
      0.540353,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.557816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.555634,
      1,
      NULL,
      NULL,
      2.086708,
      0.947427,
      1.569758,
      5,
      NULL,
      3.814949,
      0,
      NULL,
      NULL,
      3,
      3,
      1,
      0,
      2.834520,
      2,
      NULL,
      3,
      NULL,
      4.082278,
      1.239537,
      7,
      0,
      1.635879,
      0,
      NULL,
      1,
      0,
      1.304166,
      1.409969,
      3,
      1.715239,
      0,
      3.489072,
      11,
      4.126186,
      1.993779,
      0,
      NULL,
      NULL,
      NULL,
      3,
      4,
      1,
      0,
      1.748193,
      NULL,
      0,
      3,
      NULL,
      NULL,
      1.890149,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.210659,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2.807583,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.103686,
      NULL,
      NULL,
      1.699771,
      NULL,
      NULL,
      0.318036,
      NULL,
      NULL,
      1.976155,
      NULL,
      NULL,
      NULL,
      1.544300,
      1.493336,
      0,
      NULL,
      3.656029,
      0.340213,
      NULL,
      NULL,
      3.107784,
      NULL,
      NULL,
      NULL,
      32.962765,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0.708310,
      NULL,
      NULL,
      NULL,
      0.961463,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.126460,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.721738,
      NULL,
      NULL,
      NULL,
      0.344868,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.187642,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.475862,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.000446,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.865549,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      2,
      2.075611,
      132,
      NULL,
      0.963644,
      4.286702,
      0.461320,
      0.591185,
      NULL,
      NULL,
      0.600347,
      2,
      43,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      213.237626,
      4.818537,
      NULL,
      NULL,
      1,
      1.095234,
      0,
      0.427271,
      0.310414,
      NULL,
      1.007680,
      0,
      0,
      NULL,
      0,
      1.788406,
      0.121783,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.908599,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      3,
      NULL,
      3,
      3,
      4.352136,
      2,
      0.430450,
      0.187458,
      NULL,
      1,
      NULL,
      1.165357,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.304848,
      NULL,
      0.677505,
      1.184600,
      NULL,
      1,
      3,
      NULL,
      0,
      0.768665,
      NULL,
      1,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      4,
      6,
      1,
      NULL,
      NULL,
      NULL,
      74,
      3,
      NULL,
      NULL,
      '14411',
      '',
      '',
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '',
      '');
commit;
end;
/


