set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9133648';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-12-12 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '4',
      NULL,
      NULL,
      NULL,
      3.377484,
      1.108265,
      2,
      3,
      '0321',
      3,
      NULL,
      NULL,
      NULL,
      '11- 2-1991',
      69,
      NULL,
      1,
      3.946293,
      1.331655,
      ' 6- 3-1991',
      105.554049,
      2.095588,
      63.545705,
      59.410587,
      2,
      NULL,
      NULL,
      ' 2-19-1993',
      NULL,
      0.326820,
      NULL,
      1,
      1,
      3.199680,
      2,
      1.733465,
      0,
      3.918889,
      5,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      3,
      1,
      8.502104,
      1.230810,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.482081,
      1,
      NULL,
      NULL,
      198,
      2,
      5,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      0,
      1,
      1,
      1,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      1.371331,
      1.078400,
      1,
      1,
      0,
      2.691309,
      3,
      1.202918,
      0.310787,
      2,
      0,
      1.962612,
      0.533591,
      NULL,
      0,
      0.131752,
      1,
      0,
      1,
      0,
      7.297044,
      NULL,
      0,
      NULL,
      1.897951,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      1,
      0,
      2,
      1,
      NULL,
      4,
      5,
      NULL,
      5,
      2,
      4,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      0,
      3,
      1,
      1,
      0,
      3,
      NULL,
      5,
      4,
      2,
      4,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      1,
      NULL,
      1,
      2,
      0.896991,
      NULL,
      NULL,
      NULL,
      ' 1- 3-1979',
      1223.866492,
      1.314016,
      2,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.207695,
      0,
      0,
      1,
      NULL,
      0.158930,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.850156,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.611436,
      NULL,
      0,
      1,
      NULL,
      0.221310,
      0,
      0.073657,
      NULL,
      0,
      0.186929,
      NULL,
      NULL,
      NULL,
      1,
      1.054088,
      3.579731,
      0,
      0,
      NULL,
      0,
      3,
      3,
      0,
      2,
      NULL,
      1,
      3,
      NULL,
      3.384995,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2.663394,
      0.994789,
      NULL,
      NULL,
      0.000730,
      1,
      3,
      1,
      1.802284,
      0.987204,
      3,
      9,
      2,
      1,
      4,
      NULL,
      5.613690,
      1.588760,
      4,
      NULL,
      0,
      NULL,
      7.463509,
      2,
      1,
      58,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '',
      '',
      '',
      1.980820,
      34,
      361,
      37,
      2.861590,
      23.531007,
      5.550887,
      17.086265,
      4,
      1.956210,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0,
      0.254709,
      0.074154,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.255482,
      0,
      0,
      1.265935,
      NULL,
      NULL,
      1.718918,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.717763,
      2,
      2.009731,
      3.040750,
      2,
      2.958478,
      3,
      3,
      NULL,
      1.382371,
      NULL,
      1.661302,
      0,
      0.857378,
      1,
      0.131626,
      2.270605,
      1.514216,
      0.614954,
      0.424915,
      0.400974,
      0,
      0,
      1.673763,
      0.949017,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      7.597189,
      0,
      3.665570,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.290584,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.327898,
      6.240823,
      1.898954,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.981352,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.380346,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.518729,
      7,
      2,
      1,
      1,
      NULL,
      3.947605,
      1,
      1,
      0.862615,
      2,
      1,
      1,
      2,
      NULL,
      3,
      2.514762,
      1.878576,
      0,
      NULL,
      NULL,
      1.206392,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.057568,
      NULL,
      NULL,
      2,
      6,
      2.727463,
      0.916205,
      3,
      NULL,
      0.628689,
      1.101713,
      0.540780,
      0.986399,
      1.661633,
      0.214407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.314403,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.408765,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.497026,
      NULL,
      NULL,
      1.742910,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1.665019,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.276819,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.955868,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      254,
      NULL,
      1.578197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.701865,
      NULL,
      876,
      1,
      NULL,
      NULL,
      1.199151,
      NULL,
      NULL,
      2,
      602.684233,
      0,
      1.044079,
      1.731060,
      1.817003,
      1,
      0.908333,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1.678523,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.867803,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      4,
      NULL,
      NULL,
      2.304366,
      0,
      NULL,
      2,
      1,
      0,
      0,
      1,
      NULL,
      1.552185,
      1.801844,
      NULL,
      0,
      NULL,
      NULL,
      1.679837,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.838875,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      NULL,
      1.825660,
      1.489444,
      NULL,
      NULL,
      0.482743,
      NULL,
      NULL,
      1.219907,
      NULL,
      3.547875,
      1.323075,
      1.911950,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.279186,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.919547,
      NULL,
      0.932240,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1.778750,
      NULL,
      NULL,
      63,
      50.475135,
      0,
      NULL,
      NULL,
      '02113',
      '',
      NULL,
      1.922591,
      '',
      '',
      NULL,
      1,
      '',
      '',
      NULL);
commit;
end;
/


