set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9604470';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-2-26 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      '1',
      NULL,
      NULL,
      '1342340',
      2.356295,
      1.654175,
      3,
      2,
      '0403',
      2,
      0,
      NULL,
      NULL,
      '10- 8-1992',
      56,
      NULL,
      2,
      NULL,
      1.997648,
      ' 6-10-1991',
      5.308655,
      2.478401,
      41.127479,
      NULL,
      1,
      NULL,
      ' 1-15-1986',
      ' 9-18-1981',
      3.370199,
      0,
      1.000851,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      7.600009,
      2,
      18,
      3.344716,
      NULL,
      25.522162,
      5,
      22.104186,
      3,
      NULL,
      3,
      0.797359,
      0,
      1,
      NULL,
      0.961586,
      0,
      1.525211,
      0,
      0.913295,
      0,
      1.028942,
      0,
      3,
      3,
      2,
      2,
      0,
      0,
      1,
      NULL,
      5,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      2,
      0,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      0,
      1,
      NULL,
      4,
      2,
      1,
      0,
      3,
      4,
      NULL,
      0,
      0.214172,
      0,
      0,
      0,
      1,
      1,
      NULL,
      1.573832,
      1,
      NULL,
      1,
      1,
      0,
      2,
      1,
      0,
      1,
      1,
      0,
      0,
      1,
      1,
      1,
      1,
      0,
      4,
      0,
      3,
      4,
      0,
      5,
      1,
      2,
      1.678385,
      2,
      NULL,
      878,
      ' 9-25-1980',
      NULL,
      2,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      1.368652,
      3.966269,
      NULL,
      0.574146,
      NULL,
      1,
      NULL,
      2.243926,
      0.844182,
      2.997432,
      0,
      NULL,
      NULL,
      NULL,
      0.779986,
      3,
      0.815085,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.947365,
      NULL,
      1.052516,
      1.403267,
      0.524361,
      1,
      1.228028,
      NULL,
      6,
      2.979756,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      2,
      NULL,
      3,
      2,
      0,
      0,
      1,
      0,
      1,
      0,
      3,
      0,
      NULL,
      NULL,
      1,
      1,
      0,
      1.853284,
      0.063958,
      0.441093,
      0.507130,
      NULL,
      1,
      1.636358,
      NULL,
      NULL,
      0.405702,
      1.111191,
      0.687339,
      NULL,
      0.589998,
      NULL,
      7,
      7.848474,
      6,
      NULL,
      1,
      5,
      2.973108,
      1,
      3.140262,
      71.853318,
      1,
      2.597146,
      NULL,
      19,
      70,
      60,
      5,
      2.305185,
      1.837401,
      '00230',
      '',
      '',
      1,
      '',
      NULL,
      '',
      0.727117,
      NULL,
      NULL,
      NULL,
      NULL,
      47,
      212.939273,
      2,
      0.257970,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.413654,
      3.274743,
      1,
      NULL,
      NULL,
      0.343189,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      0,
      2,
      NULL,
      1,
      NULL,
      0.298474,
      NULL,
      NULL,
      0.360755,
      NULL,
      NULL,
      0.334934,
      NULL,
      NULL,
      0.939141,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      11,
      1.316345,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.342588,
      NULL,
      0.232256,
      1,
      NULL,
      NULL,
      0.220439,
      NULL,
      NULL,
      2,
      0,
      1.189109,
      1,
      2,
      0,
      NULL,
      1.353525,
      1.941932,
      1.550081,
      2,
      NULL,
      0,
      NULL,
      0,
      0.547923,
      1,
      NULL,
      NULL,
      0.551309,
      NULL,
      NULL,
      NULL,
      1.483613,
      1.722654,
      2,
      NULL,
      NULL,
      1,
      0.314886,
      NULL,
      NULL,
      NULL,
      0.417066,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.681670,
      NULL,
      NULL,
      2.954515,
      0,
      3,
      NULL,
      NULL,
      NULL,
      1.243493,
      0,
      3.521525,
      NULL,
      0.005264,
      NULL,
      NULL,
      NULL,
      NULL,
      7.899513,
      0,
      3.182608,
      0,
      NULL,
      NULL,
      1.220841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.650753,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.028072,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      5.821835,
      3.346454,
      2,
      NULL,
      1.682495,
      NULL,
      NULL,
      2,
      1.628875,
      2.076535,
      2,
      2.186618,
      2.092474,
      4.185517,
      5,
      4.206735,
      3.930245,
      NULL,
      NULL,
      0.539189,
      3,
      2,
      NULL,
      0.964063,
      1.150950,
      1,
      0,
      1.410335,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.967442,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.795345,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.830894,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      0.853424,
      1.128226,
      0,
      NULL,
      1,
      0.969740,
      1,
      NULL,
      NULL,
      2.588099,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.071277,
      NULL,
      NULL,
      NULL,
      1.535709,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.564711,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.036625,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      1.163350,
      1.200940,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.823313,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      467,
      9.133672,
      NULL,
      3.815291,
      1.331036,
      3.991405,
      0.553420,
      0,
      0,
      0,
      NULL,
      2.807806,
      0,
      3.976082,
      0,
      1,
      NULL,
      0,
      0.152874,
      3,
      NULL,
      0,
      NULL,
      3.551772,
      NULL,
      1.648790,
      NULL,
      0,
      NULL,
      1.654384,
      NULL,
      390,
      NULL,
      2,
      5.937331,
      63.027344,
      2,
      0.724895,
      NULL,
      NULL,
      2.332350,
      NULL,
      2,
      NULL,
      0.111609,
      NULL,
      1,
      NULL,
      3,
      NULL,
      0.084615,
      NULL,
      3.910800,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.391931,
      NULL,
      0.930695,
      NULL,
      0.956548,
      NULL,
      0,
      1.954694,
      0.560834,
      3,
      NULL,
      1,
      NULL,
      0.257433,
      NULL,
      NULL,
      NULL,
      0.389598,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0.248915,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.403656,
      NULL,
      NULL,
      NULL,
      1.359197,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.249266,
      NULL,
      0,
      NULL,
      NULL,
      0.734331,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.689067,
      1.497587,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      1.370964,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.670103,
      NULL,
      0.985530,
      NULL,
      0,
      3,
      NULL,
      60.039029,
      NULL,
      3,
      NULL,
      3.029685,
      1.198975,
      0.447757,
      1.430405,
      NULL,
      10.303918,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      NULL,
      1.583262,
      0.641839,
      3,
      0,
      NULL,
      2,
      2.749040,
      NULL,
      1,
      1,
      NULL,
      3,
      0.102119,
      NULL,
      2,
      1.417985,
      NULL,
      NULL,
      0.787981,
      NULL,
      0,
      1.320504,
      NULL,
      0,
      0.982959,
      NULL,
      0,
      0,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1.370704,
      1.508006,
      NULL,
      2.187324,
      NULL,
      1.775669,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.268440,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.834525,
      NULL,
      0,
      1,
      0,
      1.070174,
      NULL,
      NULL,
      25.639263,
      71.124714,
      5,
      1,
      5,
      '20131',
      '12124',
      NULL,
      0.110001,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


