set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8514545';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1991-5-28 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '1',
      NULL,
      NULL,
      NULL,
      1.271006,
      1.395510,
      1,
      1,
      NULL,
      1.722162,
      0,
      NULL,
      NULL,
      ' 8- 5-2001',
      6,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 9- 8-1984',
      48,
      3,
      317.108391,
      70,
      NULL,
      ' 8-26-2000',
      ' 3-23-1980',
      ' 7-20-1989',
      1,
      1.297884,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9,
      1,
      23.579981,
      NULL,
      NULL,
      12.238166,
      NULL,
      5,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2,
      1,
      NULL,
      3,
      NULL,
      1,
      0,
      1,
      NULL,
      5,
      0,
      NULL,
      1,
      1,
      NULL,
      2.002315,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1.502131,
      NULL,
      1,
      NULL,
      0.827261,
      2.201548,
      0.265518,
      1.821127,
      NULL,
      1,
      0.074525,
      1,
      0.972923,
      0.537666,
      0,
      1.264088,
      2.717670,
      NULL,
      0,
      NULL,
      1.641688,
      0,
      0,
      0.476459,
      1,
      NULL,
      NULL,
      0.217927,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      0,
      5,
      5,
      0,
      1,
      2,
      0,
      0,
      1,
      6.148248,
      0,
      1,
      0,
      1,
      0,
      NULL,
      1,
      1,
      1,
      0,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      2,
      2,
      1,
      ' 2-10-1994',
      NULL,
      ' 6- 3-1990',
      606.304971,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      1,
      NULL,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.271362,
      1,
      0,
      0.367647,
      0.530798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0,
      NULL,
      1.947879,
      0,
      1,
      0.470192,
      48,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.392777,
      2,
      0,
      3,
      2,
      3,
      NULL,
      1,
      NULL,
      NULL,
      3,
      0,
      NULL,
      3,
      0.012622,
      2.208582,
      0.666717,
      1.038106,
      2.705348,
      1.650683,
      0.354932,
      1,
      0.624471,
      1,
      0.607956,
      0,
      1,
      1,
      1.249517,
      1.555240,
      1.213463,
      NULL,
      11,
      1,
      NULL,
      7.061394,
      1.432802,
      2.411848,
      1.763454,
      4.636629,
      0,
      3,
      0,
      3.518379,
      2,
      2,
      NULL,
      16,
      6,
      NULL,
      3,
      NULL,
      4,
      NULL,
      '11220',
      NULL,
      3.539196,
      '33131',
      '',
      '',
      0.364437,
      '',
      NULL,
      NULL,
      NULL,
      45.625849,
      NULL,
      NULL,
      1.591280,
      4,
      1,
      2,
      1,
      2.109023,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      NULL,
      NULL,
      3.403228,
      NULL,
      NULL,
      0.496846,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.571219,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      4,
      NULL,
      0.826391,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.953275,
      NULL,
      NULL,
      2,
      1.958244,
      1.402387,
      1.388709,
      3,
      0,
      1,
      0,
      1,
      NULL,
      1,
      1,
      0.236672,
      0,
      1,
      0,
      1.739399,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      0.908567,
      1,
      3.560197,
      NULL,
      1.308137,
      NULL,
      1.264326,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.076373,
      NULL,
      NULL,
      0,
      0,
      0.452237,
      NULL,
      1.834622,
      NULL,
      0,
      NULL,
      NULL,
      4.011968,
      NULL,
      0,
      2.925491,
      0.229712,
      1,
      2,
      NULL,
      NULL,
      1.422420,
      NULL,
      1.909023,
      1.981517,
      NULL,
      NULL,
      1.535211,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.227551,
      NULL,
      NULL,
      1.440866,
      NULL,
      NULL,
      3.775143,
      1.868547,
      1.610082,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      5,
      0.726758,
      0.038513,
      1.960936,
      NULL,
      NULL,
      1.037287,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      0,
      2.955024,
      1.349685,
      1,
      1,
      3.134625,
      0,
      6,
      0.800830,
      4,
      4.504658,
      3,
      0.224934,
      1,
      1,
      3,
      0,
      1,
      NULL,
      0.733338,
      NULL,
      1.037792,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.391832,
      NULL,
      NULL,
      1.255842,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.219903,
      0.951535,
      1,
      0,
      NULL,
      NULL,
      NULL,
      4.560900,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.604663,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.738898,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.923035,
      NULL,
      NULL,
      NULL,
      1.769343,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.431751,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      2.744461,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1.845290,
      0,
      NULL,
      0,
      9.076596,
      5.873009,
      3.018899,
      41,
      5,
      1.737187,
      NULL,
      NULL,
      0,
      5.988885,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      0.226115,
      1724.361035,
      NULL,
      0,
      0,
      0,
      NULL,
      0.505313,
      NULL,
      0.985148,
      NULL,
      0.614666,
      0.314903,
      0.671455,
      1.000155,
      0.249324,
      1.073625,
      NULL,
      1.259639,
      NULL,
      2,
      NULL,
      1.149141,
      NULL,
      0.699659,
      NULL,
      1.938866,
      NULL,
      3.632877,
      NULL,
      1.102953,
      NULL,
      25,
      NULL,
      3.649838,
      13.900003,
      15.012901,
      1.092154,
      0.977877,
      NULL,
      NULL,
      1,
      NULL,
      1.243416,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.604218,
      NULL,
      0.336841,
      NULL,
      0.451378,
      NULL,
      1,
      0.856178,
      0,
      3.812485,
      NULL,
      0.818854,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.344903,
      NULL,
      0,
      NULL,
      1.839369,
      NULL,
      1,
      0.566864,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0,
      NULL,
      0.364261,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.349249,
      1.564919,
      NULL,
      NULL,
      0,
      NULL,
      0.170942,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.122577,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819980,
      3.092089,
      NULL,
      0.456598,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.497693,
      NULL,
      0.771802,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      4,
      3.253700,
      0.824144,
      NULL,
      2,
      13.167404,
      1,
      2.536110,
      1.469155,
      3.814837,
      1,
      NULL,
      0,
      2.871601,
      NULL,
      NULL,
      1,
      NULL,
      1.050896,
      NULL,
      NULL,
      0.553878,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      0,
      NULL,
      2,
      3.729514,
      NULL,
      NULL,
      NULL,
      NULL,
      0.863765,
      0,
      NULL,
      1.686920,
      1.798641,
      NULL,
      NULL,
      NULL,
      1.436379,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.999480,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.080322,
      NULL,
      NULL,
      0,
      0,
      1.607658,
      0,
      NULL,
      49.775009,
      26,
      NULL,
      1.435941,
      2.029440,
      '30401',
      '20103',
      NULL,
      3.176708,
      '02443',
      '',
      NULL,
      0.290317,
      '',
      NULL,
      '');
commit;
end;
/


