set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '7942292';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-5-23 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      5,
      0,
      5,
      7,
      9,
      0.211079,
      1.783636,
      2.957811,
      '014',
      '34414042',
      38,
      NULL,
      '3322300',
      NULL,
      0.922435,
      6,
      NULL,
      '1423',
      NULL,
      1.156009,
      NULL,
      NULL,
      '11-25-1991',
      56.637831,
      5.640505,
      NULL,
      2.664051,
      0.711534,
      ' 9-28-1996',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      '11-18-1987',
      ' 4-10-1976',
      0,
      2.850349,
      1.348634,
      2.684636,
      2.342643,
      1,
      NULL,
      NULL,
      1.704961,
      7.407748,
      2,
      18,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      0,
      1,
      1.480394,
      0.938045,
      0,
      1.718606,
      1,
      0,
      1,
      NULL,
      2,
      1,
      0,
      3,
      0,
      0,
      0,
      1,
      NULL,
      3,
      4,
      1,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.112822,
      NULL,
      NULL,
      1.002421,
      NULL,
      NULL,
      1,
      1,
      0.583711,
      1,
      1.968864,
      1.992234,
      NULL,
      2,
      NULL,
      NULL,
      1.432838,
      1.720565,
      0,
      0.565030,
      0.432374,
      NULL,
      0.790129,
      3.465420,
      NULL,
      NULL,
      0,
      1,
      2,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      0.121745,
      NULL,
      NULL,
      0,
      NULL,
      5,
      NULL,
      2,
      NULL,
      3,
      1,
      0,
      NULL,
      NULL,
      2,
      0,
      1,
      0,
      0,
      1,
      2,
      0.289967,
      NULL,
      NULL,
      1,
      1,
      NULL,
      0,
      0,
      0,
      1,
      0,
      0,
      2,
      0,
      0,
      1,
      0,
      1,
      4,
      1,
      3,
      5,
      5,
      0,
      2,
      4,
      0,
      NULL,
      1.003804,
      2.322421,
      ' 8-22-1996',
      NULL,
      '10-27-1981',
      50,
      1,
      1,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      4,
      2,
      5,
      2,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3.428302,
      3,
      NULL,
      0,
      1,
      NULL,
      2.578863,
      0.827189,
      1.934703,
      NULL,
      1,
      1,
      NULL,
      0,
      1.060553,
      NULL,
      NULL,
      NULL,
      NULL,
      0.079344,
      6.587315,
      1.435047,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0.943845,
      NULL,
      1.726673,
      1.361664,
      0.784941,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      2,
      2,
      3,
      0,
      3,
      1,
      0,
      1,
      2,
      0.274976,
      0.531828,
      NULL,
      0.881172,
      1,
      NULL,
      0,
      0,
      1.459557,
      0.585341,
      0,
      0.156428,
      1,
      1.701093,
      NULL,
      NULL,
      3.073805,
      11.350281,
      2.330691,
      0,
      6,
      7,
      0.131943,
      1,
      NULL,
      3.122400,
      NULL,
      1.908037,
      47.527568,
      0,
      NULL,
      24,
      NULL,
      60,
      NULL,
      3,
      NULL,
      3,
      '02210',
      '',
      '',
      0.160624,
      '',
      '',
      NULL,
      NULL,
      '',
      '',
      '',
      3.279170,
      45,
      9.005285,
      32.091605,
      NULL,
      NULL,
      0.027241,
      1,
      2,
      2.320188,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3.926210,
      1.481485,
      1,
      2,
      1.710266,
      2.579944,
      NULL,
      NULL,
      3.572852,
      0.807714,
      0.896551,
      1.089246,
      NULL,
      NULL,
      0.051642,
      NULL,
      NULL,
      0.775670,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      0,
      4,
      1,
      0.100074,
      NULL,
      NULL,
      NULL,
      0.060811,
      NULL,
      NULL,
      NULL,
      0.821659,
      0.535700,
      1,
      0,
      NULL,
      NULL,
      0.472255,
      NULL,
      NULL,
      1,
      0.134203,
      0.958349,
      NULL,
      1.964509,
      1,
      1.864282,
      0,
      0,
      1.506065,
      0.508095,
      NULL,
      NULL,
      1,
      0,
      0.576275,
      0,
      NULL,
      NULL,
      1.134601,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1.754559,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.269487,
      0,
      0.699289,
      3,
      0.796667,
      NULL,
      1,
      0,
      2,
      1,
      NULL,
      NULL,
      7.042836,
      5,
      3,
      3.221866,
      0.312792,
      1.144054,
      3,
      0.767448,
      1,
      2.561259,
      2,
      0.115661,
      0.458410,
      NULL,
      NULL,
      1.294821,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.872190,
      NULL,
      NULL,
      0.728022,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.775939,
      NULL,
      NULL,
      3.365647,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.243091,
      1.742055,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.580974,
      NULL,
      0,
      1.094211,
      0.791798,
      0,
      1.814203,
      3.568351,
      0.223694,
      NULL,
      3,
      NULL,
      NULL,
      2.822251,
      11.189964,
      4.184466,
      7,
      0,
      NULL,
      NULL,
      3.072272,
      0,
      4,
      1.782753,
      0,
      0,
      NULL,
      1.280942,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.400787,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.515083,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.444866,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.522151,
      0,
      NULL,
      NULL,
      2.366743,
      NULL,
      NULL,
      NULL,
      145,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.835015,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.648667,
      NULL,
      NULL,
      NULL,
      1.835493,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.253456,
      NULL,
      NULL,
      NULL,
      1.373887,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.324695,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      3,
      NULL,
      1.468467,
      1,
      3,
      23.325893,
      1,
      1.429315,
      NULL,
      NULL,
      2,
      13,
      4.401776,
      0.945582,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0.164004,
      1.179952,
      0,
      0.724662,
      0,
      0.706570,
      0.912141,
      1,
      1.883290,
      1.629589,
      NULL,
      NULL,
      NULL,
      NULL,
      0.113023,
      0.360542,
      1.499372,
      0,
      0.178236,
      1.644585,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      1,
      2.271948,
      0,
      2.469548,
      0.294163,
      NULL,
      4,
      0.988887,
      1,
      NULL,
      0.544553,
      1,
      NULL,
      1,
      1.888481,
      NULL,
      1.473947,
      NULL,
      NULL,
      0.120283,
      1.552303,
      NULL,
      NULL,
      1,
      NULL,
      1.903204,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1.680365,
      NULL,
      1,
      0,
      NULL,
      1.665697,
      NULL,
      NULL,
      0,
      1.476646,
      NULL,
      1.721610,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      1.267522,
      NULL,
      2,
      1,
      6,
      1.959353,
      NULL,
      NULL,
      116.917066,
      NULL,
      3,
      3,
      3.176063,
      '01213',
      NULL,
      '',
      1,
      '',
      '',
      '',
      0.246416,
      '',
      '',
      NULL);
commit;
end;
/


