set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9672960';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1998-1-13 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '22',
      '20',
      5.138667,
      33.075839,
      '0433323',
      1.424372,
      1,
      NULL,
      2,
      '4420',
      4.654135,
      0.643049,
      NULL,
      NULL,
      ' 7-16-1987',
      38.597077,
      37,
      NULL,
      0.752766,
      5,
      '10-28-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      ' 7-17-1980',
      NULL,
      ' 2- 3-1976',
      0.502809,
      3,
      1,
      3.430329,
      0,
      0,
      NULL,
      0.420577,
      0.033246,
      23,
      5,
      13,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      2,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0.836375,
      NULL,
      1.290371,
      1.170571,
      NULL,
      1.468778,
      2,
      NULL,
      1,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      3,
      3,
      0,
      1,
      9.937059,
      0,
      2,
      1,
      1,
      0.021402,
      NULL,
      NULL,
      0.667287,
      NULL,
      NULL,
      NULL,
      2,
      3,
      1.334827,
      3.931413,
      1,
      NULL,
      1,
      0,
      0,
      0.205754,
      1.196842,
      2.074360,
      NULL,
      2,
      NULL,
      NULL,
      1,
      0.864929,
      1,
      1,
      3,
      6,
      0,
      0,
      NULL,
      0.417716,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      1,
      1,
      1,
      2,
      0,
      0,
      0,
      0,
      1,
      NULL,
      1,
      2.927727,
      0,
      NULL,
      1,
      1,
      1.569322,
      NULL,
      1.104682,
      NULL,
      3,
      1,
      1,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      0,
      3,
      2,
      NULL,
      3,
      4,
      1,
      NULL,
      3,
      1,
      3,
      3,
      3,
      0.870676,
      3.727102,
      ' 5-11-1974',
      139,
      ' 7-22-1977',
      20.681816,
      NULL,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      2,
      1,
      NULL,
      0,
      1.481251,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.515407,
      0.417699,
      0.237057,
      1,
      0,
      3.718888,
      NULL,
      NULL,
      NULL,
      NULL,
      0.782439,
      1.815057,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.364013,
      0,
      1.238761,
      NULL,
      1,
      1,
      1,
      3,
      2,
      1.978102,
      NULL,
      NULL,
      NULL,
      0,
      1.708281,
      2.101692,
      1,
      2,
      1,
      3,
      2,
      1,
      1,
      0,
      NULL,
      3,
      1,
      2,
      NULL,
      1.631344,
      0,
      1,
      2.334024,
      NULL,
      1,
      0,
      NULL,
      0.099482,
      0.609719,
      1.183568,
      NULL,
      0,
      0.195185,
      0.051054,
      0.276086,
      1,
      9,
      2,
      NULL,
      11,
      2.510286,
      2,
      2,
      NULL,
      3.561971,
      1.324586,
      NULL,
      NULL,
      1,
      2.540359,
      9,
      NULL,
      NULL,
      32,
      3,
      0,
      2,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      1.612384,
      NULL,
      '',
      '',
      3.479347,
      30,
      1.872219,
      NULL,
      0.099463,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      2.431055,
      1.662060,
      1.479044,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      NULL,
      1,
      1,
      NULL,
      NULL,
      1,
      2.821404,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      1.147915,
      NULL,
      NULL,
      1.913994,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6,
      2.299630,
      1.348354,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.571461,
      1.656096,
      NULL,
      3.707157,
      0.802499,
      1.052133,
      1,
      2.652034,
      0.084165,
      0,
      3,
      3.058546,
      NULL,
      0,
      2,
      0.008226,
      NULL,
      2.472714,
      3,
      1.770470,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1.939733,
      NULL,
      NULL,
      0,
      1.503009,
      1.016869,
      3.285535,
      6,
      NULL,
      2,
      1.220507,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.937393,
      NULL,
      NULL,
      3,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.614237,
      0.261635,
      1.977525,
      1.932640,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.754983,
      NULL,
      NULL,
      0.424484,
      NULL,
      NULL,
      0.924072,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      1,
      3.041286,
      2.070876,
      1.552964,
      NULL,
      3.382677,
      2,
      NULL,
      NULL,
      2,
      0.491538,
      NULL,
      1,
      0,
      NULL,
      1.895261,
      0,
      2.999855,
      2,
      3.132798,
      0,
      0,
      0.465987,
      NULL,
      NULL,
      3,
      1.763113,
      0.460226,
      1,
      0.135541,
      1,
      NULL,
      NULL,
      3,
      1,
      0,
      3.781558,
      5,
      2.200844,
      1.383244,
      5,
      2.338036,
      NULL,
      NULL,
      3,
      0,
      1,
      NULL,
      1,
      1.505013,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0.647273,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      1,
      1,
      0,
      0.123898,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0.430994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.268063,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.417609,
      NULL,
      NULL,
      NULL,
      1.256437,
      NULL,
      NULL,
      NULL,
      0.190204,
      NULL,
      NULL,
      NULL,
      0.137946,
      NULL,
      NULL,
      NULL,
      0.256702,
      NULL,
      NULL,
      NULL,
      3.925296,
      NULL,
      NULL,
      NULL,
      1.976837,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.887948,
      NULL,
      NULL,
      0.637013,
      NULL,
      NULL,
      0.272248,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      282.380001,
      1,
      1.090157,
      1,
      NULL,
      0.070144,
      0.171901,
      1,
      0,
      NULL,
      0.744700,
      NULL,
      1.454686,
      0.074383,
      1.143702,
      0.209586,
      0,
      0.959482,
      0.750699,
      1,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.879780,
      NULL,
      NULL,
      NULL,
      2.573642,
      18.752330,
      11,
      0.644325,
      2,
      0.986184,
      NULL,
      0.012149,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.586422,
      NULL,
      0.701910,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.094436,
      NULL,
      1.529786,
      NULL,
      0.396522,
      NULL,
      0.114888,
      NULL,
      0.308114,
      NULL,
      1,
      NULL,
      0.683498,
      3,
      1.950278,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.830816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.613016,
      NULL,
      135,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.468653,
      NULL,
      1.364026,
      0.543660,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.450654,
      2,
      NULL,
      NULL,
      NULL,
      1.486692,
      NULL,
      52.684570,
      NULL,
      3,
      1,
      3.248081,
      NULL,
      0.153787,
      NULL,
      2.300680,
      NULL,
      74,
      NULL,
      2,
      NULL,
      1.043005,
      NULL,
      1,
      1,
      0,
      0.451840,
      24,
      0.731476,
      0.112185,
      0.204035,
      0,
      0,
      4,
      0,
      NULL,
      NULL,
      4.436535,
      2,
      NULL,
      7.099730,
      NULL,
      NULL,
      0,
      0.644725,
      1,
      NULL,
      0.649176,
      1.539081,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1.552966,
      0.461930,
      NULL,
      1,
      NULL,
      NULL,
      0,
      1.287379,
      NULL,
      1,
      NULL,
      NULL,
      0.615498,
      0.262100,
      NULL,
      NULL,
      3,
      NULL,
      1,
      3.751257,
      NULL,
      2,
      0,
      0.119608,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      1,
      NULL,
      NULL,
      NULL,
      95.518759,
      0,
      4,
      NULL,
      NULL,
      '31330',
      '',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


