set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '8008059';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1989-11-15 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '4220420',
      3,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      ' 3-14-1977',
      0,
      NULL,
      NULL,
      3,
      1,
      ' 8-16-1993',
      15.275569,
      2.361273,
      197,
      138.803100,
      1,
      NULL,
      NULL,
      ' 3- 1-1981',
      0.873459,
      NULL,
      2,
      NULL,
      0,
      3.086444,
      1,
      0.218098,
      0.715583,
      7.542540,
      5,
      9,
      NULL,
      NULL,
      190.534503,
      4,
      3,
      0,
      2,
      2.185696,
      NULL,
      1,
      1,
      0,
      0.303377,
      0.207523,
      1.834063,
      0.755762,
      NULL,
      1,
      79,
      8,
      5,
      2,
      3.878353,
      NULL,
      0,
      0,
      1,
      1,
      1,
      3,
      1,
      2,
      0,
      0,
      1,
      6,
      1,
      1,
      1,
      0,
      1.383111,
      NULL,
      NULL,
      0.583917,
      NULL,
      NULL,
      3,
      1,
      NULL,
      1.534514,
      NULL,
      0,
      0,
      0.816729,
      3,
      1.007245,
      1,
      0.828972,
      1,
      0,
      1.469002,
      1.865786,
      1,
      NULL,
      1.970652,
      NULL,
      1,
      NULL,
      6,
      1,
      0,
      0.513191,
      1.045602,
      NULL,
      NULL,
      0.975035,
      NULL,
      NULL,
      0,
      2,
      3,
      1,
      NULL,
      1,
      0,
      NULL,
      0,
      4,
      0,
      NULL,
      0,
      2,
      1,
      0,
      NULL,
      0,
      0.823222,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1,
      2,
      2,
      0,
      1,
      3,
      4,
      1,
      0,
      3,
      4,
      0,
      4,
      2,
      NULL,
      NULL,
      2,
      1,
      3,
      '10- 7-1978',
      645.041399,
      NULL,
      823,
      3,
      0,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      4,
      NULL,
      1,
      0.506918,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.591246,
      0,
      NULL,
      3.439367,
      0.051703,
      2,
      0.762083,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.276102,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.192454,
      1.040451,
      3.282988,
      1.032751,
      2.395953,
      1.069034,
      1.315396,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      2,
      0,
      3,
      0,
      2,
      NULL,
      NULL,
      7.551582,
      NULL,
      1,
      0.084619,
      1.533330,
      NULL,
      1.699793,
      1,
      1,
      NULL,
      NULL,
      0.966953,
      1,
      0,
      1,
      0.607338,
      3.658874,
      NULL,
      8.201875,
      0.027129,
      6.881185,
      NULL,
      6,
      4,
      0.047425,
      NULL,
      4,
      NULL,
      3,
      0,
      45.391859,
      NULL,
      NULL,
      NULL,
      29,
      16,
      33.646240,
      2,
      NULL,
      NULL,
      '11223',
      '',
      '',
      1,
      '',
      '',
      '',
      NULL,
      '42123',
      '',
      NULL,
      2,
      35,
      NULL,
      15,
      0,
      25,
      7.472676,
      8.775623,
      NULL,
      NULL,
      1.851965,
      2,
      0.784600,
      NULL,
      NULL,
      0.747936,
      1,
      1.518676,
      3.484769,
      0,
      1,
      1.882727,
      1.561660,
      0,
      3,
      NULL,
      1,
      2.467793,
      3.476997,
      3,
      0,
      NULL,
      NULL,
      NULL,
      1.582808,
      0.401662,
      1,
      0,
      3,
      2,
      0.612019,
      0.467668,
      0.582965,
      NULL,
      NULL,
      1.519832,
      7,
      0.208062,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      2,
      0.471070,
      2,
      1.579414,
      2.022462,
      1.359320,
      1.742301,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.819004,
      1,
      2,
      NULL,
      0,
      NULL,
      0.072261,
      0,
      NULL,
      NULL,
      1.952644,
      1,
      0.954639,
      0.905636,
      1,
      2.211493,
      NULL,
      1,
      1,
      NULL,
      NULL,
      3,
      0.444815,
      1.692632,
      8,
      3.482841,
      5,
      0,
      1,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      2,
      1.438038,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      3.306694,
      1,
      3,
      1.128838,
      3.382641,
      1.769431,
      6.226430,
      1,
      1,
      0.115583,
      0.571387,
      3.796840,
      0.722659,
      NULL,
      NULL,
      6,
      1,
      3.298484,
      1.861439,
      NULL,
      NULL,
      1.619227,
      NULL,
      NULL,
      0.556353,
      NULL,
      NULL,
      0.245620,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.953856,
      NULL,
      NULL,
      3.474924,
      1.316279,
      1.568982,
      1,
      0,
      3.103971,
      6.101622,
      5.085666,
      4.154547,
      0.113086,
      NULL,
      2,
      6.298790,
      0,
      5.547692,
      3.535441,
      2.316666,
      NULL,
      1,
      0,
      3.137386,
      NULL,
      3.771456,
      NULL,
      7.596359,
      0,
      2,
      3,
      NULL,
      0.185390,
      3,
      3,
      2,
      2.525229,
      0,
      0,
      1,
      3,
      3.870184,
      5.376997,
      0.511091,
      4,
      NULL,
      3,
      5,
      1.263577,
      1,
      NULL,
      0.643641,
      0,
      0.306716,
      0.149344,
      1,
      NULL,
      NULL,
      NULL,
      0.609814,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.499634,
      NULL,
      NULL,
      0.201873,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.896406,
      1,
      0.970264,
      1,
      NULL,
      NULL,
      NULL,
      5.088047,
      NULL,
      NULL,
      NULL,
      66.172453,
      NULL,
      NULL,
      NULL,
      1.050609,
      NULL,
      NULL,
      NULL,
      1.244611,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.998134,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.878215,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.378931,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.639713,
      3.204270,
      5,
      0,
      NULL,
      39,
      NULL,
      1.434798,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.732110,
      0,
      NULL,
      NULL,
      44.807377,
      23,
      0,
      10,
      3.206599,
      1,
      NULL,
      1,
      139.890464,
      31.414135,
      1.503143,
      0.154031,
      0,
      NULL,
      1,
      1.558216,
      1,
      1,
      0,
      0.043533,
      0.623846,
      0,
      0,
      0,
      1,
      NULL,
      0,
      0.241216,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.036710,
      0.265283,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.962441,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.929448,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.703112,
      0.310233,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.289499,
      1,
      NULL,
      NULL,
      NULL,
      0.233985,
      NULL,
      NULL,
      NULL,
      1.987193,
      NULL,
      NULL,
      NULL,
      0.927596,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      6.799752,
      5.386865,
      NULL,
      4,
      NULL,
      5,
      3.369102,
      2.761298,
      0.629909,
      0,
      0,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.212937,
      NULL,
      0,
      1,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.569250,
      NULL,
      NULL,
      NULL,
      1.203874,
      NULL,
      1,
      0.505915,
      NULL,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      1.182454,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.302676,
      3,
      NULL,
      1.725242,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      2.164113,
      NULL,
      1.367111,
      NULL,
      3,
      NULL,
      0,
      NULL,
      1.270392,
      NULL,
      1.448345,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      0.150736,
      NULL,
      NULL,
      1,
      NULL,
      0.257868,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1,
      NULL,
      1,
      NULL,
      3.197307,
      NULL,
      64,
      33.158657,
      0,
      1,
      4,
      '43104',
      '03231',
      '01040',
      0.869006,
      NULL,
      NULL,
      '',
      1.985587,
      '03104',
      '',
      '');
commit;
end;
/


