set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9710248';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2005-1-06 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1.145603,
      0.372164,
      NULL,
      NULL,
      NULL,
      0.667080,
      1.577945,
      1.261194,
      '142',
      '1',
      51,
      46,
      '4222002',
      NULL,
      1.640619,
      2,
      3,
      '4032',
      3.826228,
      0,
      NULL,
      NULL,
      ' 0- 5-1980',
      9.224836,
      56,
      NULL,
      2,
      1,
      ' 1-29-1975',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      '11- 3-1997',
      ' 3-22-1998',
      ' 1-18-1980',
      1,
      NULL,
      2.937435,
      3.771937,
      0,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      9,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      2.450841,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      3,
      2.318273,
      5,
      0,
      0,
      3,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      1.008749,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      0,
      2.823253,
      1,
      NULL,
      1,
      1.800362,
      0.814732,
      1.706229,
      1,
      1.003995,
      0.551594,
      1.276323,
      2,
      0.575596,
      0,
      0.081109,
      NULL,
      1,
      4,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.233300,
      1,
      NULL,
      NULL,
      0.080870,
      NULL,
      NULL,
      1,
      3,
      3,
      0,
      NULL,
      NULL,
      0,
      1,
      NULL,
      1,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      NULL,
      0,
      NULL,
      NULL,
      1.181691,
      1,
      0,
      0,
      5,
      1,
      NULL,
      5,
      NULL,
      3,
      2,
      NULL,
      0,
      3,
      3,
      0,
      3,
      2,
      3,
      4,
      0,
      2,
      0,
      2,
      0,
      1,
      NULL,
      NULL,
      ' 0-26-2000',
      117.980675,
      ' 5-17-1981',
      343,
      0,
      0,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      3,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      6,
      1,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      NULL,
      NULL,
      NULL,
      0,
      3.687660,
      11.339702,
      3,
      3.245632,
      6.952834,
      1.396625,
      NULL,
      NULL,
      NULL,
      1,
      11.827496,
      1.888733,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      1,
      1,
      1,
      2.256501,
      18.121409,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.240236,
      0,
      2,
      1,
      NULL,
      3,
      0,
      2,
      2,
      0,
      NULL,
      NULL,
      1,
      3,
      NULL,
      1.887714,
      0.444823,
      1,
      0.786827,
      0,
      0.877722,
      0.530378,
      NULL,
      NULL,
      1,
      1,
      1,
      0,
      0.543776,
      NULL,
      7,
      0.745389,
      2.383997,
      NULL,
      2,
      NULL,
      3.211844,
      1,
      1,
      0.544333,
      2,
      3,
      40,
      3,
      2,
      58,
      NULL,
      63,
      66,
      1,
      NULL,
      3,
      NULL,
      '',
      NULL,
      0.856274,
      '',
      '',
      '',
      0,
      '04423',
      NULL,
      NULL,
      2.484409,
      NULL,
      38,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.160919,
      0,
      3.946858,
      1.090240,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      3,
      1,
      0,
      NULL,
      NULL,
      1.957786,
      NULL,
      NULL,
      1,
      0,
      3.608412,
      NULL,
      NULL,
      NULL,
      1.633054,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.443436,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      2,
      5,
      5.790154,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.940092,
      1.602990,
      3,
      2.121810,
      NULL,
      NULL,
      2.056151,
      0.094347,
      3,
      0,
      NULL,
      2,
      1.236608,
      1.385728,
      3,
      1,
      1,
      0.642905,
      1,
      0.672892,
      3.623286,
      1.787151,
      1,
      1,
      2.059492,
      1.309806,
      3,
      0.566152,
      NULL,
      NULL,
      1,
      1,
      1.817812,
      3,
      NULL,
      3.770913,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.850532,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      1.225159,
      0.408544,
      0,
      2,
      3.267891,
      NULL,
      NULL,
      NULL,
      7,
      6,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.120730,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.940407,
      NULL,
      NULL,
      0.016561,
      0,
      0.601594,
      1.099809,
      NULL,
      NULL,
      0,
      1.291889,
      6.121031,
      8.715154,
      1.895625,
      2,
      NULL,
      4.894023,
      2,
      0,
      2.980324,
      2.723716,
      1,
      3.457666,
      2.566391,
      1.540046,
      NULL,
      0.361860,
      2,
      7,
      NULL,
      0,
      1,
      1,
      2.020616,
      1.607498,
      3.812746,
      3,
      0,
      NULL,
      3,
      3,
      NULL,
      10,
      6.275147,
      NULL,
      0,
      4.432482,
      NULL,
      3,
      NULL,
      3,
      0.717166,
      NULL,
      NULL,
      0.830562,
      1.389651,
      2,
      NULL,
      NULL,
      1.085698,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.150244,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.842434,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.884670,
      0.372182,
      0.995419,
      1,
      NULL,
      3,
      0,
      NULL,
      NULL,
      6.382888,
      NULL,
      NULL,
      NULL,
      2.161846,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.078314,
      NULL,
      NULL,
      NULL,
      3.607385,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      12,
      NULL,
      NULL,
      NULL,
      NULL,
      2.231737,
      2,
      3,
      0.276713,
      NULL,
      0.714656,
      0,
      NULL,
      NULL,
      1.719283,
      NULL,
      NULL,
      1.838107,
      NULL,
      NULL,
      0.268025,
      NULL,
      NULL,
      0.178232,
      NULL,
      NULL,
      0,
      NULL,
      1,
      463,
      1.403352,
      1.478022,
      3.502369,
      0.514273,
      1,
      1.430740,
      1,
      0.108496,
      1,
      NULL,
      0.987009,
      1,
      0.963632,
      0.254669,
      0.753368,
      1,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      10,
      NULL,
      NULL,
      NULL,
      20.020593,
      NULL,
      3,
      0.973731,
      NULL,
      NULL,
      NULL,
      1.112686,
      NULL,
      0.783752,
      NULL,
      1,
      NULL,
      1.471897,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      NULL,
      1.761239,
      NULL,
      NULL,
      NULL,
      1.342475,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.711522,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1,
      1.930638,
      NULL,
      NULL,
      2,
      0,
      NULL,
      2,
      1,
      1.096245,
      1.036900,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.133358,
      1.993868,
      NULL,
      1.487425,
      0.171698,
      NULL,
      2.862252,
      0.048541,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.866328,
      0.092975,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      0,
      1.614074,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.986169,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      2,
      3,
      0,
      2.286013,
      45.221972,
      27,
      5,
      1.839916,
      NULL,
      '21114',
      '01043',
      '',
      0,
      '',
      '',
      NULL,
      NULL,
      '43133',
      '',
      '');
commit;
end;
/


