set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '6703486';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2003-8-22 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '2', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      1,
      2,
      3.202789,
      0,
      NULL,
      1,
      NULL,
      0,
      NULL,
      '40014024',
      77.598727,
      42.231724,
      '4023200',
      0,
      0.231171,
      2,
      2,
      '1211',
      2.475687,
      1.415555,
      NULL,
      NULL,
      ' 3-26-2000',
      26,
      173.976900,
      NULL,
      2,
      0,
      ' 7-20-1990',
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      NULL,
      NULL,
      ' 4-18-2001',
      3,
      0,
      NULL,
      0,
      3,
      0.902141,
      2,
      1,
      0.281777,
      0.576165,
      7,
      NULL,
      9.548633,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.633795,
      0,
      1,
      1.548524,
      1,
      0.453718,
      1.549411,
      0.693155,
      NULL,
      0,
      1.317878,
      1,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      1,
      1,
      0,
      NULL,
      NULL,
      0,
      0,
      1,
      1,
      2,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0.126768,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      NULL,
      NULL,
      NULL,
      2,
      1,
      1,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      0,
      1,
      NULL,
      NULL,
      1,
      0,
      1,
      NULL,
      1,
      NULL,
      0,
      3,
      0,
      NULL,
      NULL,
      3,
      4,
      1,
      0,
      0,
      NULL,
      NULL,
      3,
      4,
      5,
      4,
      3,
      1,
      0,
      1,
      0.963464,
      ' 6-25-1981',
      446.850752,
      ' 3- 2-1992',
      1248.583028,
      3.353690,
      0,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      0,
      NULL,
      0.580954,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.793935,
      1.329155,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.985898,
      NULL,
      1.187506,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.604223,
      1,
      0,
      NULL,
      1.047817,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.646993,
      NULL,
      NULL,
      NULL,
      3,
      0.572779,
      2,
      NULL,
      2,
      0,
      2,
      2,
      3,
      0,
      2,
      NULL,
      NULL,
      1.761940,
      3.261759,
      2.076678,
      NULL,
      0.118890,
      0,
      1.435696,
      NULL,
      0,
      0.207156,
      1,
      NULL,
      0.132676,
      1.981551,
      0,
      0,
      1,
      4,
      1,
      NULL,
      8,
      3,
      5.077356,
      5.721091,
      4.186205,
      4,
      1,
      7.744871,
      0,
      3,
      2,
      11.308721,
      1,
      0,
      53,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      3.229365,
      '41441',
      '',
      '',
      1,
      '',
      '',
      NULL,
      1,
      '',
      '',
      '',
      NULL,
      51,
      183,
      9,
      0,
      NULL,
      8.214338,
      NULL,
      3,
      1,
      3.400845,
      2.224542,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2,
      2,
      NULL,
      1,
      NULL,
      NULL,
      0.837907,
      NULL,
      NULL,
      2.509383,
      3.581941,
      1,
      NULL,
      2,
      0,
      1.592844,
      NULL,
      1.388638,
      NULL,
      NULL,
      NULL,
      1.607002,
      0.246481,
      NULL,
      1.571517,
      NULL,
      NULL,
      9,
      5.801788,
      5,
      3,
      0.888699,
      NULL,
      NULL,
      NULL,
      3.798147,
      0.967259,
      1,
      3,
      1,
      0.604924,
      NULL,
      0.429476,
      NULL,
      NULL,
      1.297081,
      NULL,
      NULL,
      NULL,
      0.361669,
      1,
      2,
      0.595477,
      0.744542,
      NULL,
      NULL,
      NULL,
      1,
      1.010610,
      NULL,
      1,
      0.500453,
      1.019970,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      4.111487,
      1.628152,
      0.381465,
      0,
      0,
      NULL,
      NULL,
      NULL,
      1.266316,
      NULL,
      NULL,
      NULL,
      1,
      2.789239,
      NULL,
      1.008981,
      NULL,
      NULL,
      1.342288,
      3,
      NULL,
      1,
      NULL,
      NULL,
      2.735828,
      7,
      NULL,
      1,
      0,
      0.910724,
      2,
      0,
      0.067791,
      4,
      1,
      1.360160,
      1.135487,
      NULL,
      NULL,
      0.888904,
      NULL,
      NULL,
      1.127675,
      NULL,
      NULL,
      1.966710,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.054069,
      NULL,
      NULL,
      3,
      2,
      1.081505,
      0.849169,
      3,
      NULL,
      NULL,
      2,
      5.623315,
      7.225542,
      7,
      1,
      3.282839,
      NULL,
      NULL,
      1.194229,
      0.541852,
      1,
      0,
      1.589869,
      0,
      0.417727,
      NULL,
      3.674368,
      NULL,
      0.895101,
      3.484887,
      NULL,
      NULL,
      3,
      0.919707,
      NULL,
      NULL,
      2.369699,
      0,
      0,
      0,
      1.262471,
      3.866968,
      NULL,
      8,
      0,
      0,
      NULL,
      NULL,
      NULL,
      3,
      3,
      NULL,
      0,
      0,
      NULL,
      0.522017,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.745380,
      NULL,
      NULL,
      1.720494,
      NULL,
      NULL,
      0.224890,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      2.481108,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      2.663213,
      NULL,
      NULL,
      1.841890,
      NULL,
      NULL,
      6.555342,
      NULL,
      NULL,
      0.049365,
      0,
      1.668131,
      0.588509,
      0.266838,
      3.707936,
      0,
      NULL,
      1,
      0.428568,
      NULL,
      NULL,
      1,
      6,
      NULL,
      NULL,
      0,
      1.773848,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      0.166815,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.251998,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      2.060102,
      NULL,
      NULL,
      0,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      0,
      NULL,
      NULL,
      1.600993,
      0.896433,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      1,
      3.365793,
      0,
      8,
      NULL,
      2,
      549,
      NULL,
      NULL,
      83.528830,
      2.299490,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0.572573,
      NULL,
      NULL,
      1,
      NULL,
      0.493626,
      151,
      17,
      NULL,
      2.403467,
      NULL,
      0,
      0.426373,
      0,
      NULL,
      0.165107,
      0,
      1.835611,
      NULL,
      0,
      NULL,
      0.453496,
      0.410754,
      1,
      1.273790,
      0.869570,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.537014,
      NULL,
      NULL,
      NULL,
      1.803676,
      NULL,
      0,
      NULL,
      2.293941,
      6.024981,
      NULL,
      1.754851,
      1.223648,
      NULL,
      NULL,
      0.796192,
      NULL,
      1.756996,
      NULL,
      NULL,
      NULL,
      1.975045,
      NULL,
      0.138603,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.143298,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0.338186,
      NULL,
      0,
      2.758001,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.334101,
      2,
      NULL,
      0.600052,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.706951,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1.852951,
      NULL,
      1.114381,
      NULL,
      0,
      NULL,
      0.357307,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0.705103,
      NULL,
      1.915972,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3,
      NULL,
      1.855725,
      NULL,
      20.566839,
      NULL,
      1,
      NULL,
      0.692050,
      NULL,
      0.246897,
      1.490037,
      3,
      NULL,
      NULL,
      0.995976,
      NULL,
      NULL,
      NULL,
      2,
      0,
      2,
      0.939909,
      NULL,
      2.102793,
      1.467514,
      NULL,
      15,
      2,
      NULL,
      0,
      NULL,
      0.286577,
      1.969994,
      0.626659,
      1,
      1,
      1,
      3.734212,
      3,
      NULL,
      1,
      0,
      1.371146,
      0,
      1.563076,
      0,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      1.486327,
      NULL,
      NULL,
      0.053177,
      1.388288,
      3.281986,
      2,
      1.201401,
      0.002939,
      1.984693,
      0,
      0.670079,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.294136,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      1,
      NULL,
      0.059888,
      NULL,
      1,
      NULL,
      3,
      1.993428,
      NULL,
      NULL,
      12.525223,
      60,
      2,
      2,
      4,
      '24211',
      '02233',
      '30220',
      1,
      '',
      '',
      '',
      0,
      '',
      '',
      '');
commit;
end;
/


