set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9611946';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1996-6-14 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '0',
      NULL,
      NULL,
      NULL,
      '1344144',
      1,
      0.740977,
      2,
      0,
      '4132',
      NULL,
      NULL,
      NULL,
      NULL,
      ' 3-27-1994',
      NULL,
      NULL,
      5,
      0.822078,
      1,
      ' 7- 1-1981',
      24.762657,
      2,
      306,
      37,
      2,
      ' 5-12-2003',
      ' 8-18-2000',
      ' 7-26-1975',
      2.404437,
      0,
      0.560292,
      1.910840,
      NULL,
      1.990808,
      0,
      1.167975,
      1.077991,
      186.576116,
      7,
      7,
      NULL,
      NULL,
      NULL,
      5,
      28,
      NULL,
      3,
      NULL,
      0.380990,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      3,
      7,
      2,
      0,
      1,
      3,
      1,
      NULL,
      2,
      0,
      5,
      3,
      NULL,
      0,
      1,
      8.348097,
      1,
      0,
      0,
      0,
      1.248888,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      5,
      3,
      9,
      NULL,
      NULL,
      2.758348,
      3.944302,
      3.934162,
      3,
      3,
      1.531241,
      NULL,
      1.223464,
      1,
      0.198950,
      2,
      NULL,
      1.565582,
      1,
      2,
      3,
      1,
      0.263980,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      1.706964,
      NULL,
      NULL,
      1,
      5,
      1,
      NULL,
      3,
      1,
      5,
      NULL,
      0,
      0,
      5,
      2,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      1,
      NULL,
      0,
      2,
      NULL,
      0,
      4,
      5,
      NULL,
      NULL,
      1,
      0,
      2,
      2,
      NULL,
      1,
      1,
      0,
      2,
      NULL,
      2,
      4,
      2,
      3,
      2,
      3,
      NULL,
      2.298578,
      ' 6-17-1989',
      1781.614587,
      ' 4-29-1977',
      NULL,
      0,
      1,
      1,
      2,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      0.183343,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.379419,
      2.133819,
      1.502997,
      NULL,
      5.404206,
      3,
      NULL,
      NULL,
      3,
      NULL,
      3.304553,
      3,
      NULL,
      8,
      5.938106,
      2.976573,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824340,
      5.791161,
      0.058116,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      2.553187,
      0,
      0.864952,
      1,
      0,
      28,
      3.099690,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      0.770634,
      2,
      3,
      1,
      0,
      3,
      3,
      1,
      1,
      1,
      3,
      0,
      1,
      NULL,
      NULL,
      NULL,
      1,
      1,
      4,
      NULL,
      0.599322,
      NULL,
      0,
      NULL,
      0.102962,
      0.967928,
      1,
      1,
      NULL,
      NULL,
      1,
      8.822307,
      10,
      7.512613,
      NULL,
      10,
      2.074508,
      0,
      NULL,
      NULL,
      3,
      1.461193,
      0.507632,
      42.779981,
      2,
      0,
      NULL,
      NULL,
      49,
      74.716816,
      5,
      NULL,
      NULL,
      NULL,
      '',
      NULL,
      0,
      '',
      '',
      NULL,
      4.630300,
      NULL,
      '34412',
      '',
      NULL,
      11.233632,
      298.820021,
      NULL,
      2,
      29,
      NULL,
      20.099241,
      2,
      3.209787,
      3,
      NULL,
      1.245469,
      NULL,
      NULL,
      1.338797,
      NULL,
      NULL,
      1,
      1.054097,
      NULL,
      1.994419,
      2,
      1,
      1.417873,
      1,
      0.295327,
      NULL,
      3.357923,
      NULL,
      NULL,
      0.180104,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3.809656,
      3.913914,
      1.244795,
      3,
      2,
      1.820396,
      NULL,
      8.121873,
      3.039327,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      1.465723,
      NULL,
      NULL,
      NULL,
      2.546125,
      0.494438,
      NULL,
      2.876549,
      3.692301,
      NULL,
      0,
      NULL,
      1,
      3.982103,
      NULL,
      1.250708,
      3,
      0.401409,
      NULL,
      0,
      1.353334,
      1.563093,
      2.365202,
      0.406241,
      1,
      NULL,
      1.173799,
      0,
      1.493743,
      3.165961,
      1.107517,
      1,
      2.332793,
      0,
      0,
      3,
      3.888689,
      NULL,
      2.890301,
      9.489968,
      5,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.954215,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      0,
      1,
      NULL,
      NULL,
      7.037804,
      4,
      1.707107,
      1,
      3,
      2,
      2,
      0,
      0.010820,
      7,
      3,
      NULL,
      1,
      NULL,
      NULL,
      1.877335,
      NULL,
      NULL,
      1.067896,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      0,
      0,
      1,
      0,
      5,
      1,
      1.785095,
      0,
      NULL,
      3,
      5.611531,
      NULL,
      1,
      NULL,
      1,
      0.462451,
      1.340616,
      NULL,
      0.436740,
      2,
      0.559253,
      NULL,
      NULL,
      7.286965,
      NULL,
      1,
      NULL,
      2.127495,
      3.417915,
      2.793770,
      1,
      0.531906,
      3.330762,
      NULL,
      1.184891,
      2,
      1.918695,
      6.366732,
      5.176222,
      0.076024,
      NULL,
      7.224209,
      1,
      0.494346,
      3,
      0,
      0,
      0.527669,
      0,
      0.031516,
      NULL,
      0.941957,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.441929,
      NULL,
      NULL,
      3.272096,
      NULL,
      NULL,
      1.167453,
      NULL,
      NULL,
      0.600182,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      11.731332,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.733693,
      0.201728,
      1.263312,
      NULL,
      NULL,
      8,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.109270,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.539493,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1.631278,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.787166,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0,
      6,
      NULL,
      NULL,
      417.012126,
      3.030425,
      215.487085,
      16.949242,
      1.802912,
      NULL,
      NULL,
      2,
      64.721002,
      0,
      1,
      NULL,
      NULL,
      2.164232,
      65.182151,
      20.592331,
      0,
      NULL,
      1,
      NULL,
      0.291443,
      NULL,
      0.009196,
      NULL,
      1.340514,
      0,
      1,
      0,
      NULL,
      1.095325,
      0.521024,
      1.293166,
      1,
      1,
      0.593045,
      1.683350,
      0,
      NULL,
      0.950328,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.807501,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      0,
      NULL,
      2.922153,
      2,
      NULL,
      NULL,
      2,
      1,
      NULL,
      1,
      NULL,
      1.685028,
      0.498568,
      NULL,
      0,
      0.342647,
      NULL,
      0.729275,
      1,
      NULL,
      1,
      0.832912,
      NULL,
      1.428132,
      0.608326,
      NULL,
      1.973131,
      1,
      NULL,
      1.910134,
      NULL,
      NULL,
      0.494186,
      0.942028,
      NULL,
      0,
      1,
      NULL,
      1.117446,
      0,
      NULL,
      1,
      0,
      0.039816,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.355755,
      NULL,
      0.976797,
      NULL,
      0,
      NULL,
      4,
      NULL,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      44,
      2,
      3.764628,
      0,
      NULL,
      '',
      '',
      1,
      '',
      '',
      '',
      0.497800,
      '11211',
      '00110',
      '');
commit;
end;
/


