set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9703726';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1999-9-27 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      0,
      NULL,
      2.873527,
      2,
      3.145890,
      3,
      0.459002,
      1,
      '10',
      '03224230',
      2,
      39.052409,
      '1023231',
      0,
      0.714738,
      5,
      NULL,
      NULL,
      2,
      0.836618,
      NULL,
      NULL,
      NULL,
      3.336785,
      57.698534,
      NULL,
      NULL,
      15.231045,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      '11-24-1991',
      ' 2- 7-1993',
      ' 0- 2-1989',
      1.500892,
      3.375965,
      2.972788,
      2,
      1,
      NULL,
      NULL,
      0.673011,
      0,
      19,
      5,
      17.537433,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      4,
      NULL,
      0,
      0,
      0,
      1.458134,
      1,
      1.189803,
      0,
      1.445197,
      0.115336,
      1.854906,
      0,
      2,
      2,
      2,
      3.603749,
      4,
      1,
      1,
      1,
      1,
      5,
      NULL,
      NULL,
      0,
      0,
      NULL,
      0,
      6.717323,
      1,
      NULL,
      0,
      1,
      0,
      NULL,
      NULL,
      1.360516,
      NULL,
      NULL,
      5,
      0,
      3.819333,
      3.126689,
      1.803845,
      1.292732,
      1,
      3,
      2.213370,
      NULL,
      0,
      1.951119,
      NULL,
      1.036638,
      0,
      2.058186,
      2,
      NULL,
      3.592116,
      1,
      1,
      0,
      6.633175,
      0,
      NULL,
      1,
      0.750765,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      2,
      3,
      3,
      NULL,
      1,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      5,
      2,
      1,
      NULL,
      2,
      NULL,
      3,
      5.290351,
      2,
      ' 8- 5-1980',
      90,
      ' 2-28-1982',
      61.542576,
      0,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0,
      1.186097,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      0.729289,
      NULL,
      3.989617,
      0,
      2.277239,
      1.553166,
      2.918031,
      4.633014,
      4.287941,
      0,
      NULL,
      1.449313,
      NULL,
      NULL,
      NULL,
      1.993781,
      6,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0.209600,
      2,
      1.278413,
      1,
      NULL,
      0,
      3,
      1,
      0,
      NULL,
      NULL,
      NULL,
      3,
      0.310062,
      0,
      2,
      NULL,
      NULL,
      3,
      NULL,
      3,
      2,
      2,
      0,
      0,
      NULL,
      0,
      0.659551,
      1,
      0,
      1.990153,
      1,
      0.881319,
      NULL,
      1,
      1.358565,
      0,
      NULL,
      0.348332,
      1.238051,
      1,
      NULL,
      1,
      1.863174,
      5.482039,
      6.263810,
      7.330030,
      8,
      7.907132,
      NULL,
      NULL,
      0.509732,
      1.738061,
      NULL,
      2,
      0,
      46,
      NULL,
      NULL,
      NULL,
      NULL,
      60,
      NULL,
      NULL,
      0,
      3.482043,
      '21141',
      '',
      '',
      1.681500,
      '',
      NULL,
      '',
      1.577350,
      '',
      '',
      '',
      1,
      26.950082,
      NULL,
      38.633954,
      0.301464,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      3.375910,
      0.325284,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.718516,
      NULL,
      NULL,
      NULL,
      0,
      1.575373,
      NULL,
      NULL,
      1.744179,
      3,
      1,
      3,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.432230,
      NULL,
      NULL,
      0.232610,
      NULL,
      NULL,
      1,
      3,
      2.756139,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      1.579204,
      2,
      3.470019,
      2.546845,
      1.881923,
      1,
      3.846351,
      1,
      1,
      NULL,
      0.053974,
      1.814628,
      2,
      1,
      NULL,
      0,
      2,
      1,
      NULL,
      NULL,
      3.133022,
      3,
      2.826522,
      2.865149,
      0,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      10,
      0.324808,
      4,
      1,
      1,
      NULL,
      NULL,
      NULL,
      1.071782,
      NULL,
      NULL,
      NULL,
      1.041866,
      NULL,
      NULL,
      0.855215,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.760836,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.535853,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.205248,
      NULL,
      NULL,
      0.487306,
      NULL,
      NULL,
      0.581755,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.638407,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      2,
      5,
      1,
      NULL,
      NULL,
      1.196398,
      NULL,
      3,
      NULL,
      1,
      1.144506,
      3.604799,
      NULL,
      3.370559,
      0,
      6.355531,
      4,
      2.886496,
      1,
      1,
      2,
      0.576144,
      NULL,
      1.980618,
      2,
      0,
      0,
      0,
      1,
      0,
      9.874926,
      NULL,
      3,
      NULL,
      1,
      2,
      NULL,
      4,
      NULL,
      1,
      0,
      1.273978,
      1,
      2.429331,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.086502,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.854618,
      NULL,
      NULL,
      1.607175,
      NULL,
      NULL,
      0.529667,
      1,
      1,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.468395,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.904241,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      2.610065,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.272972,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      4.875235,
      NULL,
      NULL,
      NULL,
      0.914119,
      NULL,
      NULL,
      NULL,
      1,
      24.327230,
      1,
      1.676514,
      NULL,
      2,
      0,
      NULL,
      NULL,
      2.384690,
      1.509013,
      0,
      0.026302,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      0.776530,
      469,
      2,
      1,
      NULL,
      1,
      0.577138,
      0,
      1,
      1.231671,
      0,
      0.232074,
      NULL,
      0.677072,
      NULL,
      1,
      1.749045,
      0.500198,
      0.653139,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.130539,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.335728,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.059994,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.636806,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      1,
      NULL,
      2,
      NULL,
      NULL,
      1.364745,
      1,
      NULL,
      0.283328,
      NULL,
      NULL,
      NULL,
      38.251178,
      NULL,
      1,
      NULL,
      0.793673,
      NULL,
      0,
      1,
      1.136009,
      NULL,
      11.517018,
      NULL,
      1.547635,
      NULL,
      0.810339,
      0,
      2,
      2,
      NULL,
      1,
      1.710014,
      3,
      0,
      4.804167,
      3.404682,
      3,
      0.780292,
      0,
      NULL,
      NULL,
      0,
      0.008517,
      NULL,
      1,
      0,
      NULL,
      1,
      NULL,
      NULL,
      1.318148,
      0,
      NULL,
      0,
      0.573845,
      NULL,
      1.561182,
      NULL,
      NULL,
      1,
      0.742666,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0.872654,
      NULL,
      1.700497,
      1.068927,
      NULL,
      1.061771,
      0.371274,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.519872,
      NULL,
      0,
      NULL,
      1.945609,
      NULL,
      2,
      5,
      6,
      1,
      NULL,
      NULL,
      68,
      96,
      3,
      3.159370,
      5,
      NULL,
      '31124',
      '',
      NULL,
      '',
      '',
      '',
      3,
      '1231',
      '',
      '');
commit;
end;
/


