set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9423680';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2000-3-17 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      5.331258,
      NULL,
      3,
      0,
      0,
      2,
      1,
      '301',
      '20031013',
      43,
      NULL,
      '0114103',
      0.478055,
      0,
      NULL,
      1,
      '1400',
      3,
      0.625148,
      NULL,
      NULL,
      NULL,
      69.477013,
      0.779797,
      NULL,
      1,
      3,
      ' 2- 0-1999',
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.941250,
      0,
      3.904552,
      NULL,
      NULL,
      0,
      1.899249,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      1,
      1,
      0.547197,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.733178,
      1,
      3,
      2,
      NULL,
      NULL,
      1,
      0,
      1,
      5,
      0,
      1,
      1,
      1,
      3,
      1,
      1,
      8.881808,
      1,
      1,
      1,
      1,
      0.305103,
      NULL,
      NULL,
      0.045020,
      NULL,
      NULL,
      2,
      1,
      NULL,
      2.145558,
      1.969573,
      1.774006,
      1,
      NULL,
      1.258206,
      1.724437,
      2,
      3,
      0.004628,
      3,
      NULL,
      NULL,
      0,
      1.429476,
      1,
      0,
      0,
      NULL,
      3,
      NULL,
      2,
      1,
      NULL,
      NULL,
      NULL,
      1.128917,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      0,
      3,
      5,
      NULL,
      NULL,
      0,
      1,
      0,
      1,
      1.235875,
      0,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0,
      2,
      1,
      0,
      NULL,
      4,
      1,
      1,
      1,
      NULL,
      1,
      3,
      0,
      NULL,
      NULL,
      5,
      1,
      5,
      5,
      2,
      1,
      3,
      1,
      1,
      1.384382,
      0.010141,
      ' 4-18-1988',
      7.880675,
      ' 3-11-2003',
      NULL,
      2.047710,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      1,
      0,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      3,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1,
      2,
      NULL,
      1.375746,
      NULL,
      0,
      0,
      0,
      1,
      0,
      3.471910,
      1.411307,
      NULL,
      NULL,
      NULL,
      0,
      3,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2.933101,
      0.389670,
      1.201505,
      0.435356,
      1.590484,
      1.583568,
      1.546123,
      1,
      NULL,
      1.087454,
      0,
      NULL,
      NULL,
      NULL,
      0,
      1,
      2,
      2,
      2,
      3,
      3,
      3,
      0,
      1,
      0,
      3,
      1,
      NULL,
      2.304125,
      1.385841,
      3,
      NULL,
      1.095602,
      0,
      NULL,
      NULL,
      1,
      1.201580,
      0,
      1,
      0,
      0.399807,
      NULL,
      1.016267,
      NULL,
      0,
      1,
      NULL,
      7,
      4.354372,
      11.390729,
      3.905879,
      1.680164,
      3,
      2.018371,
      0.776876,
      3.837355,
      2,
      53,
      2,
      1,
      45,
      NULL,
      NULL,
      NULL,
      5,
      1,
      3.957204,
      NULL,
      NULL,
      '',
      1,
      NULL,
      '',
      '',
      NULL,
      '',
      '',
      '',
      0,
      34,
      51,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      2,
      1.462753,
      1,
      NULL,
      NULL,
      3.572506,
      NULL,
      NULL,
      1.224840,
      NULL,
      NULL,
      NULL,
      1,
      0.004317,
      1.083027,
      NULL,
      NULL,
      3,
      2.593704,
      1,
      1.857150,
      NULL,
      2.919617,
      1.811029,
      0,
      0.407354,
      1,
      1.218263,
      NULL,
      0,
      3,
      3,
      1.329590,
      3,
      1,
      5.010561,
      0,
      3.240044,
      NULL,
      0.005238,
      NULL,
      NULL,
      NULL,
      0.792492,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3.302522,
      2,
      3.322581,
      1.526466,
      0.169638,
      NULL,
      1,
      2,
      3.762747,
      1,
      2.983998,
      NULL,
      3,
      1.748863,
      3,
      NULL,
      0,
      0,
      0.815994,
      NULL,
      NULL,
      0,
      0.050142,
      0.426425,
      NULL,
      NULL,
      1.726548,
      NULL,
      NULL,
      3,
      0,
      0.067811,
      NULL,
      5,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.429191,
      NULL,
      NULL,
      1.416835,
      NULL,
      NULL,
      NULL,
      0.580676,
      0,
      NULL,
      NULL,
      1,
      2,
      NULL,
      NULL,
      1.412121,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.256556,
      NULL,
      NULL,
      0.143656,
      NULL,
      NULL,
      1.708902,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      2,
      1.393731,
      0,
      1,
      NULL,
      0.526536,
      NULL,
      NULL,
      NULL,
      0.097122,
      1,
      0,
      NULL,
      NULL,
      NULL,
      1,
      1,
      1,
      NULL,
      3,
      2,
      2,
      1.673231,
      2,
      1,
      1,
      NULL,
      2,
      0.471288,
      2.598351,
      0,
      2,
      NULL,
      0,
      2.413979,
      2.640538,
      2,
      0.603435,
      0.017862,
      6.508282,
      4.190321,
      1,
      NULL,
      NULL,
      1.831658,
      NULL,
      1,
      0,
      0,
      1.912008,
      NULL,
      1.078892,
      2,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.572775,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.833685,
      2,
      1.198798,
      0.660654,
      0,
      1.958671,
      0.195260,
      NULL,
      NULL,
      3,
      NULL,
      NULL,
      NULL,
      113,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1.109109,
      NULL,
      NULL,
      NULL,
      3.220877,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.206263,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      7,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      3,
      0.018143,
      0.125146,
      0.208635,
      NULL,
      NULL,
      0.739901,
      NULL,
      NULL,
      1.622649,
      NULL,
      NULL,
      1.682778,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      NULL,
      1,
      1,
      1,
      NULL,
      1,
      1.035894,
      1,
      0,
      1.992045,
      NULL,
      1.770686,
      0,
      NULL,
      1,
      0.205130,
      0.889662,
      0.836240,
      NULL,
      0,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      0,
      1.174101,
      0,
      0,
      1.546790,
      NULL,
      1,
      3.405108,
      0,
      1,
      NULL,
      0.585271,
      NULL,
      0.795765,
      0,
      NULL,
      0.586948,
      1,
      NULL,
      1,
      0.908541,
      NULL,
      0,
      0.171618,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      NULL,
      1,
      1.739020,
      NULL,
      0.146571,
      0.015706,
      NULL,
      0,
      0.501200,
      NULL,
      1,
      1,
      NULL,
      2.177603,
      1.291833,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.297722,
      NULL,
      0.269100,
      NULL,
      1.865971,
      NULL,
      NULL,
      2,
      3,
      NULL,
      NULL,
      NULL,
      61,
      13,
      4,
      1.511002,
      2,
      '43214',
      '',
      '',
      0,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL);
commit;
end;
/


