set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9826038';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '2001-4-04 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      2,
      2,
      NULL,
      2.703761,
      1.443911,
      3,
      1.344082,
      '021',
      '03042111',
      47,
      35.653323,
      '4241201',
      0,
      0,
      6,
      0,
      '1234',
      4,
      1.446395,
      NULL,
      NULL,
      ' 7- 1-1986',
      NULL,
      57.487124,
      NULL,
      2.827983,
      3.015416,
      ' 6- 5-1980',
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      ' 3-13-1974',
      NULL,
      ' 9-12-1997',
      2.656155,
      1.204987,
      NULL,
      3.528387,
      0,
      3.490264,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.402423,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      4,
      3,
      NULL,
      1,
      1,
      1,
      NULL,
      0,
      0,
      1,
      0,
      0.021443,
      0.841986,
      0,
      NULL,
      0,
      5,
      NULL,
      5,
      1,
      0,
      1,
      0,
      5,
      2,
      2,
      5,
      NULL,
      NULL,
      NULL,
      4,
      2,
      1,
      0,
      NULL,
      0,
      NULL,
      NULL,
      0.898551,
      NULL,
      NULL,
      0,
      3,
      NULL,
      3.814816,
      1.870624,
      3,
      2,
      2,
      1.471461,
      1,
      1.207690,
      1,
      NULL,
      2.470543,
      0.409742,
      NULL,
      1,
      1.246484,
      0.421320,
      4,
      NULL,
      0,
      10,
      0,
      1,
      0,
      0,
      NULL,
      NULL,
      0.735438,
      NULL,
      NULL,
      0,
      5,
      1,
      1,
      2,
      1,
      2,
      0,
      0,
      1,
      1,
      2,
      1,
      0,
      2,
      NULL,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      0,
      0,
      0,
      3,
      2,
      NULL,
      1,
      0,
      5,
      1,
      1,
      1,
      3,
      4,
      0,
      0,
      0,
      1,
      4,
      1,
      3,
      NULL,
      5,
      2.916494,
      3.299243,
      ' 1-21-1984',
      7,
      ' 8-24-1981',
      144,
      2.568290,
      NULL,
      NULL,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      0,
      4,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.303011,
      NULL,
      1.110460,
      3.951378,
      4,
      0,
      NULL,
      NULL,
      NULL,
      1.819649,
      5,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      3.115118,
      1.174416,
      0,
      0,
      NULL,
      1.822112,
      0,
      8.377265,
      0.979690,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      1.044675,
      NULL,
      1,
      1,
      3,
      3,
      1,
      0,
      2,
      0,
      1,
      1,
      2.814404,
      3,
      2,
      1,
      NULL,
      1.753007,
      NULL,
      0.785222,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      1,
      1,
      NULL,
      2,
      1,
      NULL,
      4,
      2,
      1,
      9,
      3.669739,
      NULL,
      2,
      7,
      3.581119,
      NULL,
      3,
      46.836850,
      3,
      3.557314,
      NULL,
      NULL,
      2,
      8.114625,
      3,
      2,
      4.128874,
      NULL,
      '24333',
      '',
      1,
      '',
      '',
      '',
      3,
      '44242',
      '',
      NULL,
      0.213397,
      18,
      12,
      7,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0.012536,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.251238,
      NULL,
      NULL,
      1.852671,
      NULL,
      NULL,
      0.389620,
      NULL,
      NULL,
      1.095746,
      NULL,
      NULL,
      1.821237,
      NULL,
      NULL,
      1.429608,
      NULL,
      NULL,
      1.608086,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.242295,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.140040,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.769043,
      NULL,
      NULL,
      1.700306,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.199755,
      NULL,
      NULL,
      1.731818,
      3,
      NULL,
      2,
      2.160249,
      1.775065,
      0,
      NULL,
      NULL,
      2,
      3,
      1.656729,
      1,
      NULL,
      NULL,
      0.909976,
      NULL,
      NULL,
      1.391991,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.224113,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.295348,
      NULL,
      NULL,
      2,
      0.297358,
      1.123178,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      4,
      NULL,
      NULL,
      NULL,
      NULL,
      0.131491,
      NULL,
      NULL,
      2.897998,
      0.345002,
      0.835243,
      3.166210,
      3,
      1.881770,
      5.514899,
      1.895216,
      0.842857,
      3.479662,
      1,
      3.340018,
      1.322167,
      NULL,
      NULL,
      2.825799,
      0.369584,
      0,
      2.429848,
      0,
      0.794484,
      2.200670,
      2.582052,
      0.224014,
      NULL,
      5,
      5.513558,
      NULL,
      NULL,
      NULL,
      1.829882,
      0.236757,
      1,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.449441,
      0.531794,
      0.546006,
      0,
      0.969081,
      1.736719,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      3,
      1,
      3,
      NULL,
      2.102161,
      1,
      0.651547,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.376678,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.318573,
      NULL,
      0.923107,
      8,
      2,
      2.007545,
      1.517917,
      0.765951,
      1,
      0.016553,
      1.772723,
      0.080951,
      1.111816,
      0,
      1.056954,
      2,
      0.016270,
      0.099680,
      0,
      1,
      NULL,
      2.177694,
      1,
      1.282835,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0.701860,
      NULL,
      2.192863,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      18.502902,
      NULL,
      1.139616,
      NULL,
      3,
      NULL,
      NULL,
      1.647361,
      NULL,
      0.240396,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.883123,
      NULL,
      1.683788,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.270367,
      NULL,
      1.696086,
      NULL,
      1.619064,
      NULL,
      NULL,
      NULL,
      1.791633,
      NULL,
      0.962693,
      1.377469,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      NULL,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      1,
      NULL,
      0.570178,
      NULL,
      NULL,
      3.357114,
      1.312991,
      2.734955,
      NULL,
      0,
      NULL,
      192,
      NULL,
      3,
      NULL,
      0.930732,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      0.352721,
      NULL,
      NULL,
      NULL,
      0.749137,
      2,
      NULL,
      2,
      NULL,
      0,
      NULL,
      377.532112,
      NULL,
      NULL,
      NULL,
      1.396851,
      NULL,
      0,
      NULL,
      1,
      0.300908,
      0,
      NULL,
      0.946150,
      1.986367,
      NULL,
      3,
      1,
      1,
      1,
      0.157424,
      0,
      1,
      1,
      1,
      0.980521,
      2,
      0.480442,
      1.541574,
      1.862294,
      NULL,
      NULL,
      0.045615,
      1,
      NULL,
      NULL,
      0,
      NULL,
      1.544798,
      1,
      NULL,
      0.156431,
      1,
      NULL,
      1.024000,
      1,
      NULL,
      1.583846,
      NULL,
      NULL,
      1,
      1.169237,
      NULL,
      0.866531,
      0.919281,
      NULL,
      0.207453,
      0,
      NULL,
      1.504298,
      0,
      NULL,
      2,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      0,
      1,
      2,
      NULL,
      NULL,
      NULL,
      59,
      43.206128,
      2,
      0.259268,
      5,
      '44303',
      '24233',
      '22210',
      0,
      '',
      NULL,
      '',
      NULL,
      '10001',
      '',
      NULL);
commit;
end;
/


