set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9678720';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1997-10-16 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '30',
      NULL,
      24,
      18.872992,
      '3322211',
      NULL,
      0.820285,
      1,
      NULL,
      '1304',
      NULL,
      1.557056,
      NULL,
      NULL,
      ' 0-14-1990',
      3,
      2,
      NULL,
      1.314851,
      3.764340,
      '11- 9-1976',
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      ' 1-26-1983',
      ' 4-24-1981',
      ' 5- 3-1986',
      1.207189,
      NULL,
      0.207299,
      3,
      0.069406,
      NULL,
      2,
      NULL,
      1,
      1,
      5,
      17.945872,
      7,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      0.965292,
      0,
      0,
      3.875243,
      NULL,
      NULL,
      0,
      1,
      1.441614,
      1,
      NULL,
      3,
      0,
      1,
      3.116105,
      5,
      3,
      1,
      1,
      0,
      5,
      2,
      0,
      3,
      1,
      0,
      0,
      4.667789,
      3,
      1,
      0,
      2,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      3.946595,
      0,
      0.102395,
      0.015889,
      0.110607,
      1,
      0,
      0.739187,
      NULL,
      NULL,
      1,
      1.225393,
      1,
      3,
      NULL,
      1.149171,
      4,
      NULL,
      5,
      4.593300,
      1,
      NULL,
      5,
      1,
      NULL,
      NULL,
      2,
      0,
      0,
      0,
      3,
      1,
      NULL,
      3,
      0,
      NULL,
      0,
      0,
      0,
      NULL,
      NULL,
      1,
      0.355085,
      1,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      1.708480,
      NULL,
      NULL,
      5,
      1,
      0,
      2,
      5,
      0,
      2,
      1,
      NULL,
      0,
      NULL,
      0,
      3,
      3,
      4,
      2,
      NULL,
      2,
      5,
      NULL,
      2,
      3,
      0,
      NULL,
      3,
      ' 1-22-1975',
      10.836815,
      ' 3-21-1983',
      5.164007,
      NULL,
      0,
      1,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1,
      0,
      3,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      9.389403,
      3,
      0,
      2,
      NULL,
      0.446783,
      2.872233,
      NULL,
      5,
      5,
      2,
      0,
      NULL,
      NULL,
      NULL,
      0.157279,
      0.305895,
      3,
      3,
      0.633873,
      0,
      6.400147,
      NULL,
      NULL,
      NULL,
      0.548396,
      5.162566,
      NULL,
      0,
      NULL,
      2,
      3,
      ' 8-13-1996',
      20,
      ' 4- 5-1991',
      NULL,
      1.227302,
      0,
      4,
      NULL,
      0,
      0,
      0,
      0,
      0,
      0,
      1.483210,
      20.434860,
      2.906105,
      0,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      0.044413,
      2,
      NULL,
      NULL,
      3,
      0,
      2,
      2,
      2,
      2,
      1,
      0.387102,
      NULL,
      NULL,
      0,
      0,
      0.655422,
      0.673296,
      0,
      NULL,
      NULL,
      0,
      1,
      1.645366,
      1,
      0,
      1,
      NULL,
      NULL,
      0.636764,
      8,
      5,
      5.031719,
      1,
      NULL,
      3.335487,
      3,
      2.577266,
      6.534100,
      0.731920,
      3.192074,
      1.231848,
      NULL,
      3,
      1.303101,
      18,
      NULL,
      NULL,
      3,
      0,
      2.596961,
      5,
      '00214',
      '13042',
      NULL,
      NULL,
      '',
      '',
      '',
      0,
      '',
      '',
      NULL,
      0,
      24,
      6.578580,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      3.765874,
      1.515206,
      1,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.336957,
      NULL,
      1,
      163,
      2.845453,
      1,
      1,
      0,
      1,
      0,
      1,
      0,
      0,
      1.334094,
      0.235591,
      NULL,
      0.503744,
      0.327547,
      NULL,
      1,
      1,
      0,
      1.164991,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.065340,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.349304,
      1.520007,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      3.863554,
      NULL,
      3.939161,
      NULL,
      0.996553,
      NULL,
      3,
      NULL,
      1,
      NULL,
      0,
      1.008755,
      0.676881,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.947324,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.170255,
      0.633033,
      NULL,
      NULL,
      NULL,
      1.701635,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      2.677639,
      17.305758,
      1.814770,
      0.853270,
      NULL,
      NULL,
      NULL,
      1,
      1,
      2,
      10,
      2.839417,
      3.025832,
      5.601638,
      NULL,
      10,
      1.426368,
      1,
      1.451434,
      1,
      1.400310,
      NULL,
      0,
      0,
      NULL,
      2,
      2,
      NULL,
      1.880565,
      0.274336,
      NULL,
      NULL,
      3.366264,
      NULL,
      1.860165,
      1.784008,
      NULL,
      0,
      1,
      NULL,
      1,
      0.847128,
      NULL,
      1,
      0.504532,
      NULL,
      3,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      3.965267,
      1.839152,
      1.800941,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.144223,
      NULL,
      0,
      NULL,
      1.136539,
      NULL,
      NULL,
      3,
      5,
      1.181675,
      NULL,
      NULL,
      NULL,
      17.359075,
      2,
      NULL,
      1,
      NULL,
      '02122',
      '',
      1,
      '',
      '',
      '',
      0.144449,
      '',
      NULL,
      '');
commit;
end;
/


