set serveroutput on

declare
    db_user_name varchar2(128) := '_USERNAME_';
    v_subject_id varchar2(64) := 'subject_1';
    time_stamp_in timestamp := timestamp '2001-01-01 12:00:00.00';
    exp_name varchar2(128) := 'cash';
    research_group_name varchar2(128) := 'No Group';
    exp_contact_first_name_in VARCHAR2(128) := '_FIRSTNAME_';
    exp_contact_last_name_in VARCHAR2(128) := '_LASTNAME_';
    exp_contact_email_in varchar2(256) := '_EMAIL_';
    v_owner_id number;
    v_experiment_ID number;
    v_group_ID number;
    v_visit_ID number;
    v_segment_ID number;
    v_temp_subject_ID number;
begin
   update nc_assessmentScore set scoreType = 'varchar' where scoreType = 'bool';
   v_owner_id := get_database_user_id(db_user_name);
   
   v_experiment_ID := get_experiment_id(exp_name);
   if v_experiment_ID = -1 or v_experiment_ID is null then
       add_experiment(v_owner_id, v_owner_id, exp_name, 'Converting UI''s SAS database to MorphDB', exp_contact_first_name_in, exp_contact_last_name_in, exp_contact_email_in);
       commit;
       v_experiment_ID := get_experiment_id(exp_name);
   end if;
   
   v_group_ID := get_research_group_id(research_group_name);
   if v_group_ID = -1 or v_group_ID is null then
       add_research_group(research_group_name, 'University of Iowa Subjects','experimental', exp_name, v_owner_id, v_owner_id);
       commit;
       v_group_ID := get_research_group_id(research_group_name);
   end if;
   
   v_experiment_ID := get_experiment_id(exp_name);
   
   v_subject_id := '9011057';
   SELECT min(uniqueid) INTO v_temp_subject_ID FROM nc_humansubject WHERE subjectid=v_subject_id;
   if v_temp_subject_ID is null then
       INSERT INTO nc_humansubject (SUBJECTID, TABLEID, UNIQUEID, OWNER, MODTIME, MODUSER, EXTENSIONNAME, NC_ANIMALSPECIES_UNIQUEID, NAME, LOCALID) VALUES (v_subject_id, (SELECT tableid FROM nc_tableid WHERE tablename='NC_HUMANSUBJECT'), (SELECT NVL(MAX(uniqueid) + 1,1000000) from NC_HUMANSUBJECT), v_owner_id, sysdate, v_owner_id, 'humanSubject', (select uniqueid from nc_animalspecies where strain='human'), v_subject_id, v_subject_id);
       commit;
   end if;
   
   time_stamp_in := timestamp '1990-7-05 12:00:00.00';
   v_visit_ID := add_exp_component(v_subject_id, exp_name, research_group_name, time_stamp_in, '1', 'Generic visit', v_owner_id, v_owner_id);
   v_segment_ID := add_exp_segment(v_visit_ID, v_experiment_ID, v_subject_id,  1, 'Other protocol', v_owner_id, v_owner_id, time_stamp_in, 'Unknown');
   add_cash_value(v_experiment_ID, v_visit_ID, v_segment_ID, v_owner_id, v_subject_id, time_stamp_in,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      '2',
      NULL,
      NULL,
      NULL,
      '1024434',
      NULL,
      NULL,
      5,
      2,
      '2122',
      2.649330,
      NULL,
      NULL,
      NULL,
      ' 8-25-1986',
      NULL,
      NULL,
      0,
      0.856095,
      2,
      '10- 5-1988',
      4,
      0.037645,
      276,
      53.777477,
      2,
      ' 9- 7-1995',
      ' 0- 6-1993',
      NULL,
      0.718423,
      0.920445,
      0.625418,
      1,
      0.559812,
      1.921639,
      0,
      NULL,
      1.066943,
      6,
      0,
      18.781042,
      7.988856,
      19.378010,
      11.148052,
      4,
      14.138411,
      3,
      NULL,
      NULL,
      0.584133,
      NULL,
      1,
      0,
      0.814624,
      NULL,
      1.262490,
      2,
      0.117461,
      NULL,
      NULL,
      0,
      4,
      0,
      2.092767,
      1,
      1,
      0,
      NULL,
      0,
      5,
      NULL,
      1,
      0,
      0,
      NULL,
      1,
      6,
      0,
      2,
      2,
      NULL,
      0,
      NULL,
      NULL,
      1.466731,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      1,
      3,
      0,
      5,
      0,
      1,
      0,
      1,
      NULL,
      0,
      NULL,
      1,
      0,
      NULL,
      1,
      0,
      0,
      1.546973,
      NULL,
      0,
      1,
      0,
      0,
      NULL,
      0,
      NULL,
      3,
      1,
      NULL,
      0,
      NULL,
      0,
      1,
      0,
      NULL,
      2,
      4,
      5,
      1,
      0,
      1,
      3,
      4,
      4,
      NULL,
      1.095172,
      0.236209,
      ' 0-15-1986',
      13,
      ' 7-25-1994',
      22,
      1,
      0,
      2,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      0,
      0,
      4,
      0,
      0,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      6.011831,
      2.353027,
      0.132830,
      2,
      NULL,
      NULL,
      0.853615,
      1.144884,
      0.622034,
      NULL,
      0.897465,
      1.787881,
      NULL,
      NULL,
      NULL,
      3.432671,
      5.351289,
      9,
      3.065480,
      0.042551,
      5.720505,
      0,
      1,
      NULL,
      NULL,
      NULL,
      0.735523,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.010364,
      1.299764,
      0,
      0.880598,
      3.774607,
      0.978970,
      0.214428,
      1.287633,
      33,
      3.112293,
      0.515758,
      NULL,
      NULL,
      NULL,
      2,
      NULL,
      1,
      3,
      0,
      0,
      0,
      3,
      2,
      3,
      NULL,
      3,
      2,
      1.915369,
      NULL,
      2,
      NULL,
      1.098649,
      1.190731,
      NULL,
      0.108305,
      1,
      1.595781,
      NULL,
      1,
      1,
      NULL,
      0.077070,
      0,
      0,
      2.476089,
      0.118748,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.824683,
      NULL,
      35,
      37,
      86,
      NULL,
      0,
      4,
      NULL,
      '41411',
      '03243',
      0.255788,
      '',
      '',
      '',
      0,
      '',
      '',
      '',
      NULL,
      3.951021,
      41.138018,
      NULL,
      2.285846,
      4,
      0.217918,
      7,
      0,
      1,
      0,
      1.535482,
      0,
      NULL,
      NULL,
      1.179135,
      NULL,
      NULL,
      0.044292,
      NULL,
      NULL,
      1,
      1.263639,
      1,
      0.715902,
      NULL,
      NULL,
      0.092670,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.590197,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.724027,
      NULL,
      NULL,
      0,
      2,
      0,
      3,
      1.088096,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.385404,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      2,
      3,
      0,
      NULL,
      2.818337,
      NULL,
      6,
      7.697448,
      0,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0.564440,
      NULL,
      NULL,
      3,
      2.085714,
      1.479250,
      2,
      3.904367,
      1.394141,
      6,
      NULL,
      2.136554,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0.609362,
      NULL,
      NULL,
      1,
      3.668208,
      3,
      1,
      NULL,
      NULL,
      0.405039,
      3,
      4,
      2,
      NULL,
      NULL,
      0.365547,
      NULL,
      NULL,
      0,
      2.913196,
      NULL,
      2,
      2,
      2.077419,
      3.107334,
      1,
      1,
      1,
      8,
      NULL,
      NULL,
      1,
      1,
      8.870629,
      NULL,
      NULL,
      0.535285,
      0.402579,
      3.961411,
      0,
      NULL,
      NULL,
      1.103327,
      3.462883,
      NULL,
      2.307746,
      NULL,
      NULL,
      NULL,
      2,
      1,
      0,
      1.557731,
      NULL,
      NULL,
      NULL,
      0.779694,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      1.882999,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.873700,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.243415,
      NULL,
      NULL,
      1.488651,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      0,
      0.055697,
      NULL,
      NULL,
      NULL,
      NULL,
      0.839699,
      1.010433,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0,
      1.064630,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.903666,
      0,
      NULL,
      NULL,
      1.520729,
      0.281083,
      NULL,
      NULL,
      NULL,
      1,
      NULL,
      NULL,
      1.546139,
      1.004235,
      NULL,
      NULL,
      3.907408,
      2,
      NULL,
      NULL,
      0,
      2.483706,
      NULL,
      NULL,
      1,
      1,
      NULL,
      NULL,
      0.754354,
      0,
      NULL,
      NULL,
      NULL,
      0.834809,
      NULL,
      NULL,
      0.081679,
      0,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      NULL,
      1.087654,
      2,
      NULL,
      NULL,
      NULL,
      5,
      NULL,
      NULL,
      0.942780,
      NULL,
      NULL,
      NULL,
      3.817484,
      2,
      NULL,
      3.425721,
      4.747931,
      NULL,
      0.719167,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3.697310,
      8.045842,
      NULL,
      0.579103,
      NULL,
      NULL,
      1,
      NULL,
      1.915790,
      NULL,
      1.093793,
      1,
      NULL,
      1.543312,
      0,
      0,
      0.569041,
      1.577461,
      3,
      NULL,
      2,
      0,
      3,
      0.601574,
      NULL,
      1,
      1.615896,
      1.516193,
      0,
      NULL,
      1.959734,
      NULL,
      3,
      NULL,
      0,
      NULL,
      0,
      NULL,
      0.846819,
      NULL,
      14,
      NULL,
      1,
      14.677443,
      0.571809,
      1.726147,
      1,
      NULL,
      NULL,
      1.948254,
      NULL,
      1.761624,
      NULL,
      1,
      NULL,
      3,
      NULL,
      1.647679,
      NULL,
      1.643335,
      NULL,
      0.530477,
      NULL,
      0.850505,
      NULL,
      0.363214,
      NULL,
      0.181315,
      NULL,
      0.496306,
      NULL,
      1,
      NULL,
      0,
      NULL,
      1.541164,
      3.000402,
      1,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.843759,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.317403,
      3,
      NULL,
      2,
      NULL,
      2,
      NULL,
      79.518554,
      NULL,
      0,
      NULL,
      1.388289,
      NULL,
      0.138784,
      NULL,
      0.786563,
      0,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      NULL,
      1.836696,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      3,
      3,
      3.861057,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      0.743497,
      NULL,
      NULL,
      2.019573,
      NULL,
      NULL,
      NULL,
      607.476469,
      NULL,
      2,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1.119917,
      3,
      27.386119,
      NULL,
      1,
      NULL,
      NULL,
      NULL,
      0,
      NULL,
      1,
      0,
      0.860835,
      0.326814,
      NULL,
      NULL,
      1,
      2.578839,
      1,
      3.073188,
      NULL,
      0.060100,
      0,
      1.865190,
      1,
      0,
      0,
      0,
      1.256555,
      0.032902,
      3,
      0.517593,
      0.097153,
      1.078266,
      0,
      1.615855,
      0.074288,
      0.173180,
      1.033928,
      1.223002,
      0.974775,
      0,
      1.307401,
      0.340643,
      0,
      1,
      1,
      NULL,
      0.393096,
      3.851589,
      0.338128,
      2,
      3,
      NULL,
      0.645946,
      0,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.846835,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      NULL,
      0.215465,
      1.682185,
      1.181223,
      0.291306,
      1.606691,
      1,
      2,
      0,
      2,
      0.015706,
      NULL,
      NULL,
      24.078553,
      NULL,
      NULL,
      0,
      3,
      '22221',
      '00104',
      '22020',
      0.984169,
      '',
      NULL,
      '',
      NULL,
      '',
      '',
      '');
commit;
end;
/


